/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.content;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

class SelectContentPartDialog
extends Dialog {
    private List<IEditorPart> dirtyParts;
    private IEditorPart selectedPart;

    private SelectContentPartDialog(Shell parentShell, List<IEditorPart> dirtyParts) {
        super(parentShell);
        this.dirtyParts = dirtyParts;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Choose content editor");
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        Label infoLabel = new Label(group, 0);
        infoLabel.setText("Content was modified in mutliple editors. Choose correct one:");
        gd = new GridData(768);
        infoLabel.setLayoutData((Object)gd);
        final Combo combo = new Combo(group, 12);
        gd = new GridData(768);
        combo.setLayoutData((Object)gd);
        combo.add("");
        for (IEditorPart part : this.dirtyParts) {
            combo.add(part.getTitle());
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectContentPartDialog.this.selectedPart = combo.getSelectionIndex() >= 1 ? SelectContentPartDialog.this.dirtyParts.get(combo.getSelectionIndex() - 1) : null;
                SelectContentPartDialog.this.getButton(0).setEnabled(SelectContentPartDialog.this.selectedPart != null);
            }
        });
        return group;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return ctl;
    }

    public IEditorPart getSelectedPart() {
        return this.selectedPart;
    }

    public static IEditorPart selectContentPart(Shell parentShell, List<IEditorPart> dirtyParts) {
        SelectContentPartDialog scDialog = new SelectContentPartDialog(parentShell, dirtyParts);
        if (scDialog.open() == 0) {
            return scDialog.getSelectedPart();
        }
        return null;
    }
}

