/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.valueviewer;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.data.managers.ContentValueManager;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class ValueViewerPanel
implements IResultSetPanel,
IAdaptable {
    private static final Log log = Log.getLog(ValueViewerPanel.class);
    public static final String PANEL_ID = "value-view";
    public static final String SETTINGS_SECTION = "panel-value-view";
    private static final String VALUE_VIEW_CONTROL_ID = "org.jkiss.dbeaver.ui.resultset.panel.valueView";
    private IResultSetPresentation presentation;
    private Composite viewPlaceholder;
    private ResultSetValueController previewController;
    private IValueEditor valueEditor;
    private ReferenceValueEditor referenceValueEditor;
    private volatile boolean valueSaving;
    private IValueManager valueManager;

    public static IDialogSettings getPanelSettings() {
        return ResultSetUtils.getViewerSettings(SETTINGS_SECTION);
    }

    @Override
    public Control createContents(IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.viewPlaceholder = new Composite(parent, 0);
        this.viewPlaceholder.setLayout((Layout)new FillLayout());
        this.viewPlaceholder.addPaintListener(e -> {
            if (this.previewController == null && this.viewPlaceholder.getChildren().length == 0) {
                e.gc.setForeground(UIStyles.getDefaultTextForeground());
                String hidePanelCmd = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview", (IServiceLocator)this.presentation.getController().getSite(), (boolean)true);
                UIUtils.drawMessageOverControl((Control)this.viewPlaceholder, (PaintEvent)e, (String)ResultSetMessages.value_viewer_select_view_message, (int)0);
                UIUtils.drawMessageOverControl((Control)this.viewPlaceholder, (PaintEvent)e, (String)NLS.bind((String)ResultSetMessages.value_viewer_hide_panel_message, (Object)hidePanelCmd), (int)20);
            }
        });
        if (this.presentation instanceof ISelectionProvider) {
            ISelectionProvider selectionProvider = (ISelectionProvider)this.presentation;
            ISelectionChangedListener selectionListener = event -> {
                if (this.presentation.getController().getVisiblePanel() == this) {
                    this.refreshValue(false);
                }
            };
            selectionProvider.addSelectionChangedListener(selectionListener);
            this.viewPlaceholder.addDisposeListener(e -> selectionProvider.removeSelectionChangedListener(selectionListener));
        }
        return this.viewPlaceholder;
    }

    @Override
    public boolean isDirty() {
        return this.valueEditor != null && this.valueEditor.isDirty();
    }

    @Override
    public void activatePanel() {
        this.refreshValue(false);
    }

    @Override
    public void deactivatePanel() {
        if (this.viewPlaceholder != null && !this.viewPlaceholder.isDisposed()) {
            this.viewPlaceholder.dispose();
            this.viewPlaceholder = null;
        }
    }

    @Override
    public void setFocus() {
        this.viewPlaceholder.setFocus();
    }

    @Override
    public void refresh(boolean force) {
        this.refreshValue(force);
    }

    public void contributeActions(IContributionManager manager) {
        this.fillToolBar(manager);
    }

    private void refreshValue(boolean force) {
        Object value;
        boolean updateActions;
        DBDAttributeBinding attr = this.presentation.getCurrentAttribute();
        ResultSetRow row = this.presentation.getController().getCurrentRow();
        if (attr == null || row == null) {
            this.clearValue();
            return;
        }
        int[] rowIndexes = this.presentation.getCurrentRowIndexes();
        if (this.previewController == null) {
            this.previewController = new ResultSetValueController(this.presentation.getController(), new ResultSetCellLocation(attr, row, rowIndexes), IValueController.EditType.PANEL, this.viewPlaceholder){

                @Override
                public void updateValue(@Nullable Object value, boolean updatePresentation) {
                    ValueViewerPanel.this.valueSaving = true;
                    try {
                        super.updateValue(value, updatePresentation);
                    }
                    finally {
                        ValueViewerPanel.this.valueSaving = false;
                    }
                    ValueViewerPanel.this.presentation.updateValueView();
                }
            };
            updateActions = true;
            force = true;
        } else {
            force = force || this.previewController.getBinding() != attr || !CommonUtils.equalObjects((Object)rowIndexes, (Object)this.previewController.getRowIndexes());
            updateActions = force;
            this.previewController.setCellLocation(new ResultSetCellLocation(attr, row, rowIndexes));
        }
        if (!(force || this.valueManager != null && this.valueEditor != null)) {
            force = true;
        }
        if (!force && this.valueManager instanceof ContentValueManager && (value = this.previewController.getValue()) instanceof DBDContent && !ContentUtils.isTextContent((DBDContent)((DBDContent)value))) {
            force = true;
            updateActions = true;
        }
        this.viewValue(force);
        if (updateActions) {
            this.presentation.getController().updatePanelActions();
        }
    }

    private void viewValue(boolean forceRefresh) {
        if (this.valueSaving) {
            return;
        }
        if (forceRefresh) {
            this.cleanupPanel();
            this.referenceValueEditor = new ReferenceValueEditor(this.previewController, this.valueEditor);
            boolean referenceValue = this.referenceValueEditor.isReferenceValue();
            if (referenceValue) {
                this.previewController.setEditType(IValueController.EditType.INLINE);
            } else {
                this.previewController.setEditType(IValueController.EditType.PANEL);
            }
            this.valueManager = this.previewController.getValueManager();
            try {
                this.valueEditor = this.valueManager.createEditor(this.previewController);
            }
            catch (Throwable e2) {
                DBWorkbench.getPlatformUI().showError(ResultSetMessages.value_viewer_preview_error_title, ResultSetMessages.value_viewer_preview_error_message, e2);
                return;
            }
            if (this.valueEditor != null) {
                try {
                    this.valueEditor.createControl();
                }
                catch (Exception e3) {
                    log.error((Object)e3);
                }
                boolean singleLineEditor = false;
                Control control = this.valueEditor.getControl();
                if (control != null) {
                    singleLineEditor = control instanceof Combo || control instanceof CCombo || control instanceof Button || control instanceof Text && (control.getStyle() & 2) == 0;
                    UIUtils.addFocusTracker((IServiceLocator)this.presentation.getController().getSite(), (String)VALUE_VIEW_CONTROL_ID, (Control)control);
                    this.presentation.getController().lockActionsByFocus(control);
                }
                if (referenceValue || singleLineEditor) {
                    GridLayout gl = new GridLayout(1, false);
                    this.viewPlaceholder.setLayout((Layout)gl);
                    this.valueEditor.getControl().setLayoutData((Object)new GridData(768));
                    this.referenceValueEditor.setValueEditor(this.valueEditor);
                    this.referenceValueEditor.createEditorSelector(this.viewPlaceholder);
                } else {
                    this.viewPlaceholder.setLayout((Layout)new FillLayout());
                }
            } else {
                Composite placeholder = UIUtils.createPlaceholder((Composite)this.viewPlaceholder, (int)1);
                placeholder.setBackground(placeholder.getDisplay().getSystemColor(22));
                placeholder.addPaintListener(e -> {
                    Rectangle bounds = placeholder.getBounds();
                    String message = "No editor for [" + this.previewController.getValueType().getTypeName() + "]";
                    Point ext = e.gc.textExtent(message);
                    e.gc.drawText(message, (bounds.width - ext.x) / 2, bounds.height / 3 + 20);
                });
                this.referenceValueEditor = null;
            }
            this.viewPlaceholder.layout();
        }
        if (this.valueEditor instanceof BaseValueEditor) {
            ((BaseValueEditor)this.valueEditor).setAutoSaveEnabled(false);
        }
        if (this.valueEditor != null) {
            block23: {
                try {
                    Object newValue = this.previewController.getValue();
                    if (newValue instanceof DBDValueError) break block23;
                    if (newValue instanceof DBDValue) {
                        this.valueEditor.primeEditorValue(newValue);
                        break block23;
                    }
                    Object oldValue = null;
                    try {
                        if (this.previewController.getExecutionContext() != null) {
                            oldValue = this.valueEditor.extractEditorValue();
                        }
                    }
                    catch (Throwable throwable) {}
                    if (forceRefresh || !CommonUtils.equalObjects(oldValue, (Object)newValue)) {
                        this.valueEditor.primeEditorValue(newValue);
                    }
                }
                catch (DBException e4) {
                    log.error((Object)e4);
                }
            }
            this.valueEditor.setDirty(false);
        }
        if (this.valueEditor instanceof BaseValueEditor) {
            ((BaseValueEditor)this.valueEditor).setAutoSaveEnabled(true);
        }
    }

    public void saveValue() {
        if (this.valueEditor == null) {
            return;
        }
        try {
            try {
                this.valueSaving = true;
                Object newValue = this.valueEditor.extractEditorValue();
                this.previewController.updateValue(newValue, true);
                this.presentation.updateValueView();
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(ResultSetMessages.value_viewer_apply_error_title, ResultSetMessages.value_viewer_apply_error_message, (Throwable)e);
                this.valueSaving = false;
            }
        }
        finally {
            this.valueSaving = false;
        }
    }

    public void clearValue() {
        this.cleanupPanel();
        this.valueManager = null;
        this.valueEditor = null;
        this.presentation.getController().updateEditControls();
        this.viewPlaceholder.layout();
    }

    private void cleanupPanel() {
        UIUtils.disposeChildControls((Composite)this.viewPlaceholder);
    }

    private void fillToolBar(IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)new Separator());
        if (this.valueManager != null) {
            try {
                this.valueManager.contributeActions(contributionManager, this.previewController, this.valueEditor);
            }
            catch (Exception e) {
                log.error((Object)"Can't contribute value manager actions", (Throwable)e);
            }
        }
        contributionManager.add((IContributionItem)new GroupMarker("actions_add"));
        if (this.referenceValueEditor != null && this.referenceValueEditor.isReferenceValue()) {
            ContributionItem[] contributionItemArray = this.referenceValueEditor.getContributionItems();
            int n = contributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContributionItem contributionItem = contributionItemArray[n2];
                contributionManager.add((IContributionItem)contributionItem);
                ++n2;
            }
        }
        if (this.valueEditor != null && !this.valueEditor.isReadOnly()) {
            contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.presentation.getController().getSite(), (String)"org.jkiss.dbeaver.core.resultset.cell.save"));
            contributionManager.add((IAction)new Action(ResultSetMessages.value_viewer_auto_apply_action_text, 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.AUTO_SAVE));
                }

                public boolean isChecked() {
                    return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("resultset.edit.value.autoupdate");
                }

                public void run() {
                    boolean newValue = !this.isChecked();
                    DBWorkbench.getPlatform().getPreferenceStore().setValue("resultset.edit.value.autoupdate", newValue);
                    ValueViewerPanel.this.presentation.getController().updatePanelActions();
                }
            });
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.valueEditor != null) {
            if (adapter.isAssignableFrom(this.valueEditor.getClass())) {
                return adapter.cast(this.valueEditor);
            }
            if (this.valueEditor instanceof IAdaptable) {
                return (T)((IAdaptable)this.valueEditor).getAdapter(adapter);
            }
        }
        return null;
    }
}

