/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.model;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectRegistry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;

class StreamDataSourceContainer
implements DBPDataSourceContainer {
    private File inputFile;
    private String name;
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();
    private final DBVModel virtualModel;

    StreamDataSourceContainer(String name) {
        this.name = name;
        this.virtualModel = new DBVModel((DBPDataSourceContainer)this);
    }

    @NotNull
    public String getId() {
        return this.inputFile == null ? this.name : this.inputFile.getName();
    }

    @NotNull
    public DBPDriver getDriver() {
        throw new IllegalStateException("Not supported");
    }

    @NotNull
    public DBPDataSourceConfigurationStorage getConfigurationStorage() {
        throw new IllegalStateException("Stream datasource doesn't have config storage");
    }

    @NotNull
    public DBPDataSourceOrigin getOrigin() {
        throw new IllegalStateException("Stream datasource doesn't have origin");
    }

    @NotNull
    public DBPConnectionConfiguration getConnectionConfiguration() {
        return new DBPConnectionConfiguration();
    }

    @NotNull
    public DBPConnectionConfiguration getActualConnectionConfiguration() {
        return new DBPConnectionConfiguration();
    }

    @NotNull
    public DBNBrowseSettings getNavigatorSettings() {
        throw new IllegalStateException("Not supported");
    }

    public boolean isProvided() {
        return true;
    }

    public boolean isManageable() {
        return false;
    }

    public boolean isAccessCheckRequired() {
        return this.isManageable();
    }

    public boolean isExternallyProvided() {
        return false;
    }

    public boolean isTemplate() {
        return false;
    }

    public boolean isTemporary() {
        return true;
    }

    public boolean isConnectionReadOnly() {
        return true;
    }

    public boolean isSavePassword() {
        return false;
    }

    public void setSavePassword(boolean savePassword) {
    }

    public void setDescription(String description) {
    }

    public boolean isDefaultAutoCommit() {
        return false;
    }

    public void setDefaultAutoCommit(boolean autoCommit) {
    }

    public boolean isAutoCloseTransactions() {
        return false;
    }

    @Nullable
    public DBPTransactionIsolation getActiveTransactionsIsolation() {
        return null;
    }

    @Nullable
    public Integer getDefaultTransactionsIsolation() {
        return null;
    }

    public void setDefaultTransactionsIsolation(DBPTransactionIsolation isolationLevel) {
    }

    @Nullable
    public DBSObjectFilter getObjectFilter(Class<?> type, @Nullable DBSObject parentObject, boolean firstMatch) {
        return null;
    }

    public void setObjectFilter(Class<?> type, DBSObject parentObject, DBSObjectFilter filter) {
    }

    public DBVModel getVirtualModel() {
        return this.virtualModel;
    }

    public DBPNativeClientLocation getClientHome() {
        return null;
    }

    public DBWNetworkHandler[] getActiveNetworkHandlers() {
        return new DBWNetworkHandler[0];
    }

    public boolean isConnected() {
        return false;
    }

    public boolean connect(DBRProgressMonitor monitor, boolean initialize, boolean reflect) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean disconnect(DBRProgressMonitor monitor) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean reconnect(DBRProgressMonitor monitor) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    @Nullable
    public DBSObject getParentObject() {
        return null;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return null;
    }

    @Nullable
    public DBPDataSourceFolder getFolder() {
        return null;
    }

    public void setFolder(@Nullable DBPDataSourceFolder folder) {
    }

    public Collection<DBPDataSourceTask> getTasks() {
        return null;
    }

    public void acquire(DBPDataSourceTask user) {
    }

    public void release(DBPDataSourceTask user) {
    }

    public void fireEvent(DBPEvent event) {
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return DBWorkbench.getPlatform().getPreferenceStore();
    }

    @NotNull
    public DBPDataSourceRegistry getRegistry() {
        return null;
    }

    @NotNull
    public DBPProject getProject() {
        return null;
    }

    public void persistConfiguration() {
    }

    @NotNull
    public ISecurePreferences getSecurePreferences() {
        return DBWorkbench.getPlatform().getApplication().getSecureStorage().getSecurePreferences();
    }

    public Date getConnectTime() {
        return this.inputFile == null ? new Date() : new Date(this.inputFile.lastModified());
    }

    @NotNull
    public SQLDialectMetadata getScriptDialect() {
        return SQLDialectRegistry.getInstance().getDialect("basic");
    }

    public IVariableResolver getVariablesResolver(boolean actualConfig) {
        return null;
    }

    public DBPDataSourceContainer createCopy(DBPDataSourceRegistry forRegistry) {
        return null;
    }

    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    public boolean hasModifyPermission(DBPDataSourcePermission permission) {
        return false;
    }

    public List<DBPDataSourcePermission> getModifyPermission() {
        return null;
    }

    public void setModifyPermissions(@Nullable Collection<DBPDataSourcePermission> permissions) {
    }

    public void setName(String newName) {
    }

    @NotNull
    public String getName() {
        return this.inputFile == null ? this.name : this.inputFile.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBDDataFormatterProfile getDataFormatterProfile() {
        return DBWorkbench.getPlatform().getDataFormatterRegistry().getGlobalProfile();
    }

    public boolean isUseNativeDateTimeFormat() {
        return ModelPreferences.getPreferences().getBoolean("resultset.format.datetime.native");
    }

    public boolean isUseNativeNumericFormat() {
        return ModelPreferences.getPreferences().getBoolean("resultset.format.numeric.native");
    }

    public boolean isUseScientificNumericFormat() {
        return ModelPreferences.getPreferences().getBoolean("resultset.format.numeric.scientific");
    }

    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        return DefaultValueHandler.INSTANCE;
    }

    public boolean isHidden() {
        return true;
    }

    public boolean isForceUseSingleConnection() {
        return false;
    }

    public void setForceUseSingleConnection(boolean value) {
        throw new IllegalStateException("Not supported");
    }
}

