/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCParameterizedStatement;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class QMMConnectionInfo
extends QMMObject {
    private final DBPProject project;
    private final String containerId;
    private final String driverId;
    private UUID projectId;
    private String projectName;
    private String projectPath;
    private boolean isAnonymousProject;
    private String containerName;
    @Nullable
    private DBPConnectionConfiguration connectionConfiguration;
    private String instanceId;
    private String contextName;
    @Nullable
    private SQLDialect sqlDialect;
    private boolean transactional;
    private QMMStatementInfo statementStack;
    private QMMStatementExecuteInfo executionStack;
    private QMMTransactionInfo transaction;

    public QMMConnectionInfo(DBCExecutionContext context, boolean transactional) {
        this.project = context.getDataSource().getContainer().getProject();
        this.containerId = context.getDataSource().getContainer().getId();
        this.driverId = context.getDataSource().getContainer().getDriver().getFullId();
        this.initFromContext(context, transactional);
    }

    private QMMConnectionInfo(Builder builder) {
        this.project = builder.project;
        this.projectId = builder.projectId;
        this.projectName = builder.projectName;
        this.projectPath = builder.projectPath;
        this.isAnonymousProject = builder.isAnonymousProject;
        this.containerId = builder.containerId;
        this.driverId = builder.driverId;
        this.containerName = builder.containerName;
        this.connectionConfiguration = builder.connectionConfiguration;
        this.instanceId = builder.instanceId;
        this.contextName = builder.contextName;
        this.sqlDialect = builder.sqlDialect;
        this.transactional = builder.transactional;
        this.statementStack = builder.statementStack;
        this.executionStack = builder.executionStack;
        this.transaction = builder.transaction;
    }

    private void initFromContext(DBCExecutionContext context, boolean transactional) {
        this.containerName = context.getDataSource().getContainer().getName();
        this.connectionConfiguration = context.getDataSource().getContainer().getConnectionConfiguration();
        this.instanceId = context.getOwnerInstance().getName();
        this.contextName = context.getContextName();
        this.sqlDialect = context.getDataSource().getSQLDialect();
        this.transactional = transactional;
        if (transactional) {
            this.transaction = new QMMTransactionInfo(this, null);
        }
    }

    public QMMConnectionInfo(long openTime, long closeTime, String containerId, String containerName, String driverId, DBPConnectionConfiguration connectionConfiguration, String instanceID, String contextName, boolean transactional) {
        super(openTime, closeTime);
        this.project = null;
        this.containerId = containerId;
        this.containerName = containerName;
        this.driverId = driverId;
        this.connectionConfiguration = connectionConfiguration;
        this.instanceId = instanceID;
        this.contextName = contextName;
        this.transactional = transactional;
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            this.transaction.rollback(null);
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (!stat.isClosed()) {
                DBCStatement statRef = stat.getReference();
                String query = statRef == null ? "?" : statRef.getQueryString();
                log.warn("Statement " + stat.getObjectId() + " (" + query + ") is not closed");
                stat.close();
            }
            stat = stat.getPrevious();
        }
        super.close();
    }

    public void reopen(DBCExecutionContext context) {
        this.initFromContext(context, this.transactional);
        super.reopen();
    }

    @Override
    public String getText() {
        return String.valueOf(this.containerName) + " - " + this.contextName;
    }

    @Override
    public QMMObject.ObjectType getObjectType() {
        return QMMObject.ObjectType.ConnectionInfo;
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> serializedConnectionInfo = new LinkedHashMap<String, Object>();
        serializedConnectionInfo.put("containerId", this.getContainerId());
        serializedConnectionInfo.put("containerName", this.getContainerName());
        serializedConnectionInfo.put("driverId", this.getDriverId());
        serializedConnectionInfo.put("instanceId", this.getInstanceId());
        serializedConnectionInfo.put("contextName", this.getContextName());
        if (this.connectionConfiguration != null) {
            serializedConnectionInfo.put("connectionUserName", this.connectionConfiguration.getUserName());
            serializedConnectionInfo.put("connectionURL", this.connectionConfiguration.getUrl());
        }
        LinkedHashMap<String, Object> project = new LinkedHashMap<String, Object>();
        if (this.getProject() != null) {
            project.put("id", this.getProject().getProjectID());
            project.put("name", this.getProject().getName());
            project.put("path", this.getProject().getAbsolutePath().toString());
            SMSession projectSession = this.getProject().getSessionContext().findSpaceSession(this.getProject());
            boolean isAnonymousProject = projectSession == null || projectSession.getSessionPrincipal() == null;
            project.put("isAnonymous", isAnonymousProject);
        }
        serializedConnectionInfo.put("project", project);
        return serializedConnectionInfo;
    }

    public static QMMConnectionInfo fromMap(Map<String, Object> objectMap) {
        String containerId = CommonUtils.toString((Object)objectMap.get("containerId"));
        String containerName = CommonUtils.toString((Object)objectMap.get("containerName"));
        String driverId = CommonUtils.toString((Object)objectMap.get("driverId"));
        String instanceId = CommonUtils.toString((Object)objectMap.get("instanceId"));
        String contextName = CommonUtils.toString((Object)objectMap.get("contextName"));
        String connectionUserName = CommonUtils.toString((Object)objectMap.get("connectionUserName"));
        String connectionURL = CommonUtils.toString((Object)objectMap.get("connectionURL"));
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        configuration.setUserName(connectionUserName);
        configuration.setUrl(connectionURL);
        Map<String, Object> project = JSONUtils.getObject(objectMap, "project");
        UUID projectId = project.get("id") == null ? null : UUID.fromString(CommonUtils.toString((Object)project.get("id")));
        String projectName = CommonUtils.toString((Object)project.get("name"));
        String projectPath = CommonUtils.toString((Object)project.get("path"));
        boolean isAnonymous = CommonUtils.toBoolean((Object)project.get("isAnonymous"));
        return QMMConnectionInfo.builder().setContainerId(containerId).setContainerName(containerName).setDriverId(driverId).setInstanceId(instanceId).setContextName(contextName).setConnectionConfiguration(configuration).setProjectId(projectId).setProjectName(projectName).setProjectPath(projectPath).setIsAnonymousProject(isAnonymous).build();
    }

    public QMMTransactionInfo changeTransactional(boolean transactional) {
        if (this.transactional == transactional) {
            return null;
        }
        this.transactional = transactional;
        if (this.transaction != null) {
            this.transaction.commit();
        }
        this.transaction = new QMMTransactionInfo(this, this.transaction);
        return this.transaction.getPrevious();
    }

    public QMMTransactionInfo commit() {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.commit();
            }
            this.transaction = new QMMTransactionInfo(this, this.transaction);
            return this.transaction.getPrevious();
        }
        return null;
    }

    public QMMObject rollback(DBCSavepoint savepoint) {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.rollback(savepoint);
            }
            if (savepoint == null) {
                this.transaction = new QMMTransactionInfo(this, this.transaction);
                return this.transaction.getPrevious();
            }
            if (this.transaction != null) {
                return this.transaction.getSavepoint(savepoint);
            }
        }
        return null;
    }

    public QMMStatementInfo openStatement(DBCStatement statement) {
        this.statementStack = new QMMStatementInfo(this, statement, this.statementStack);
        return this.statementStack;
    }

    public QMMStatementInfo closeStatement(DBCStatement statement, long rows) {
        QMMStatementExecuteInfo execution = this.getExecution(statement);
        if (execution != null && execution.getUpdateRowCount() < 0L) {
            execution.close(rows, null);
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                stat.close();
                return stat;
            }
            stat = stat.getPrevious();
        }
        log.warn("Statement " + statement + " meta info not found");
        return null;
    }

    public QMMStatementInfo getStatement(DBCStatement statement) {
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                return stat;
            }
            stat = stat.getPrevious();
        }
        log.warn("Statement " + statement + " meta info not found");
        return null;
    }

    public QMMStatementExecuteInfo getExecution(DBCStatement statement) {
        QMMStatementExecuteInfo exec = this.executionStack;
        while (exec != null) {
            if (exec.getStatement().getReference() == statement) {
                return exec;
            }
            exec = exec.getPrevious();
        }
        return null;
    }

    public QMMStatementExecuteInfo beginExecution(DBCStatement statement) {
        QMMStatementInfo stat = this.getStatement(statement);
        if (stat != null) {
            String queryString = statement instanceof DBCParameterizedStatement ? ((DBCParameterizedStatement)statement).getFormattedQuery() : statement.getQueryString();
            QMMTransactionSavepointInfo savepoint = this.isTransactional() && this.getTransaction() != null ? this.getTransaction().getCurrentSavepoint() : null;
            this.executionStack = new QMMStatementExecuteInfo(stat, savepoint, queryString, this.executionStack);
            return this.executionStack;
        }
        return null;
    }

    public QMMStatementExecuteInfo endExecution(DBCStatement statement, long rowCount, Throwable error) {
        QMMStatementExecuteInfo exec = this.getExecution(statement);
        if (exec != null) {
            exec.close(rowCount, error);
        }
        return exec;
    }

    public QMMStatementExecuteInfo beginFetch(DBCResultSet resultSet) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec == null) {
            exec = this.beginExecution(resultSet.getSourceStatement());
        }
        if (exec != null) {
            exec.beginFetch();
        }
        return exec;
    }

    public QMMStatementExecuteInfo endFetch(DBCResultSet resultSet, long rowCount) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec != null) {
            exec.endFetch(rowCount);
        }
        return exec;
    }

    public DBPProject getProject() {
        return this.project;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getDriverId() {
        return this.driverId;
    }

    @Nullable
    public DBPConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public QMMStatementInfo getStatementStack() {
        return this.statementStack;
    }

    public QMMTransactionInfo getTransaction() {
        return this.transaction;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public SQLDialect getSQLDialect() {
        return this.sqlDialect;
    }

    public String toString() {
        return "SESSION " + this.containerName + " [" + this.contextName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QMMConnectionInfo)) {
            return false;
        }
        QMMConnectionInfo si = (QMMConnectionInfo)obj;
        return CommonUtils.equalObjects((Object)this.containerId, (Object)si.containerId) && CommonUtils.equalObjects((Object)this.contextName, (Object)si.contextName);
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAnonymousProject() {
        return this.isAnonymousProject;
    }

    private static final class Builder {
        private DBPProject project;
        private UUID projectId;
        private String projectName;
        private String projectPath;
        private boolean isAnonymousProject;
        private String containerId;
        private String driverId;
        private String containerName;
        private DBPConnectionConfiguration connectionConfiguration;
        private String instanceId;
        private String contextName;
        private SQLDialect sqlDialect;
        private boolean transactional;
        private QMMStatementInfo statementStack;
        private QMMStatementExecuteInfo executionStack;
        private QMMTransactionInfo transaction;

        public Builder setProject(DBPProject project) {
            this.project = project;
            return this;
        }

        public Builder setProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder setProjectPath(String projectPath) {
            this.projectPath = projectPath;
            return this;
        }

        public Builder setIsAnonymousProject(boolean isAnonymousProject) {
            this.isAnonymousProject = isAnonymousProject;
            return this;
        }

        public Builder setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public Builder setDriverId(String driverId) {
            this.driverId = driverId;
            return this;
        }

        public Builder setContainerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder setConnectionConfiguration(DBPConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setContextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public Builder setSqlDialect(SQLDialect sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        public Builder setTransactional(boolean transactional) {
            this.transactional = transactional;
            return this;
        }

        public Builder setStatementStack(QMMStatementInfo statementStack) {
            this.statementStack = statementStack;
            return this;
        }

        public Builder setExecutionStack(QMMStatementExecuteInfo executionStack) {
            this.executionStack = executionStack;
            return this;
        }

        public Builder setTransaction(QMMTransactionInfo transaction) {
            this.transaction = transaction;
            return this;
        }

        public QMMConnectionInfo build() {
            return new QMMConnectionInfo(this);
        }
    }
}

