/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPageContainer;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class MultiPageWizardDialog
extends TitleAreaDialog
implements IWizardContainer,
IWizardContainer2,
IPageChangeProvider,
IPreferencePageContainer {
    private IWizard wizard;
    private Composite pageArea;
    private Tree pagesTree;
    private IDialogPage prevPage;
    private ProgressMonitorPart monitorPart;
    private SashForm wizardSash;
    private volatile int runningOperations = 0;
    private String finishButtonLabel = IDialogConstants.OK_LABEL;
    private String cancelButtonLabel = IDialogConstants.CANCEL_LABEL;
    private final ListenerList<IPageChangedListener> pageChangedListeners = new ListenerList();
    private Composite leftBottomPanel;
    private Font boldFont;

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        this(window, wizard, null);
    }

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard, IStructuredSelection selection) {
        super(window.getShell());
        this.wizard = wizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (wizard instanceof IWorkbenchWizard) {
            if (selection == null && window.getSelectionService().getSelection() instanceof IStructuredSelection) {
                selection = (IStructuredSelection)window.getSelectionService().getSelection();
            }
            ((IWorkbenchWizard)wizard).init(window.getWorkbench(), selection);
        }
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer((IWizardContainer)this);
        UIUtils.disposeChildControls(this.leftBottomPanel);
        this.createBottomLeftArea(this.leftBottomPanel);
        this.leftBottomPanel.getParent().layout(true, true);
        this.updateNavigationTree();
        this.updateButtons();
    }

    protected boolean isNavigableWizard() {
        return false;
    }

    protected Tree getPagesTree() {
        return this.pagesTree;
    }

    protected boolean isResizable() {
        return true;
    }

    public int getShellStyle() {
        if (this.isModalWizard() || UIUtils.isInDialog()) {
            return 66608;
        }
        return 0xC70 | MultiPageWizardDialog.getDefaultOrientation();
    }

    protected boolean isModalWizard() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.showPage((IWizardPage)this.pagesTree.getItem(0).getData());
        this.showPage(this.getStartingPage());
        this.updateButtons();
        this.updateWindowTitle();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.wizard.addPages();
        this.wizardSash = new SashForm(composite, 256);
        this.wizardSash.setLayoutData((Object)new GridData(1808));
        Composite leftPane = UIUtils.createComposite((Composite)this.wizardSash, 1);
        this.pagesTree = new Tree(leftPane, 4);
        this.pagesTree.setLayoutData((Object)new GridData(1808));
        this.boldFont = UIUtils.makeBoldFont(this.pagesTree.getFont());
        this.pagesTree.addDisposeListener(e -> UIUtils.dispose((Resource)this.boldFont));
        leftPane.setBackground(this.pagesTree.getBackground());
        this.leftBottomPanel = UIUtils.createComposite(leftPane, 1);
        this.leftBottomPanel.setBackground(this.pagesTree.getBackground());
        this.createBottomLeftArea(this.leftBottomPanel);
        Composite pageContainer = UIUtils.createPlaceholder((Composite)this.wizardSash, 2);
        new Label(pageContainer, 514).setLayoutData((Object)new GridData(16384, 4, false, true));
        this.pageArea = UIUtils.createPlaceholder(pageContainer, 1);
        GridData gd = new GridData(1808);
        this.pageArea.setLayoutData((Object)gd);
        this.pageArea.setLayout((Layout)new GridLayout(1, true));
        this.wizardSash.setWeights(new int[]{220, 780});
        Point size = leftPane.computeSize(-1, -1);
        if (size.x > 0) {
            ((GridData)this.wizardSash.getLayoutData()).widthHint = size.x * 6;
        }
        this.updateNavigationTree();
        this.pagesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = MultiPageWizardDialog.this.pagesTree.getSelection();
                if (selection.length > 0) {
                    Object newPage = selection[0].getData();
                    if (MultiPageWizardDialog.this.runningOperations > 0 || newPage instanceof IWizardPageNavigable && !((IWizardPageNavigable)newPage).isPageNavigable()) {
                        TreeItem prevItem;
                        if (MultiPageWizardDialog.this.prevPage != null && (prevItem = UIUtils.getTreeItem(MultiPageWizardDialog.this.pagesTree, (Object)MultiPageWizardDialog.this.prevPage)) != null) {
                            MultiPageWizardDialog.this.pagesTree.select(prevItem);
                        }
                        return;
                    }
                }
                MultiPageWizardDialog.this.changePage();
            }
        });
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        this.monitorPart = new ProgressMonitorPart(composite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    MultiPageWizardDialog.this.cancelCurrentOperation();
                }
            }
        };
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return composite;
    }

    protected void createBottomLeftArea(Composite pane) {
    }

    protected void cancelCurrentOperation() {
    }

    private void changePage() {
        block15: {
            TreeItem[] selection = this.pagesTree.getSelection();
            if (selection.length != 1) {
                return;
            }
            TreeItem newItem = selection[0];
            if (this.prevPage == newItem.getData()) {
                return;
            }
            this.pageArea.setRedraw(false);
            IWizard wizard = this.getWizard();
            try {
                try {
                    GridData gd;
                    if (this.prevPage != null) {
                        gd = (GridData)this.prevPage.getControl().getLayoutData();
                        gd.exclude = true;
                        this.prevPage.setVisible(false);
                        if (this.prevPage instanceof ActiveWizardPage) {
                            ((ActiveWizardPage)this.prevPage).deactivatePage();
                        }
                    }
                    boolean pageCreated = false;
                    IDialogPage page = (IDialogPage)newItem.getData();
                    Control pageControl = page.getControl();
                    if (pageControl == null) {
                        page.createControl(this.pageArea);
                        pageControl = page.getControl();
                        if (pageControl != null) {
                            gd = (GridData)pageControl.getLayoutData();
                            if (gd == null) {
                                gd = new GridData(1808);
                                pageControl.setLayoutData((Object)gd);
                            }
                            gd.exclude = false;
                            pageCreated = true;
                        }
                    }
                    if (pageControl != null) {
                        gd = (GridData)pageControl.getLayoutData();
                        gd.exclude = false;
                        page.setVisible(true);
                    }
                    this.setTitle(page.getTitle());
                    this.setMessage(page.getDescription());
                    this.prevPage = page;
                    this.pageArea.layout();
                    if (pageCreated && this.isAutoLayoutAvailable()) {
                        UIUtils.asyncExec(() -> {
                            if (wizard.getContainer().getShell() != null) {
                                UIUtils.resizeShell(wizard.getContainer().getShell());
                            }
                        });
                    }
                    if (page instanceof ActiveWizardPage) {
                        ((ActiveWizardPage)page).updatePageCompletion();
                    }
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError("Page switch", "Error switching active page", e);
                    this.pageArea.setRedraw(true);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.pageArea.setRedraw(true);
                throw throwable;
            }
            this.pageArea.setRedraw(true);
        }
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
        this.updatePageCompleteMark(null);
    }

    protected boolean isAutoLayoutAvailable() {
        return true;
    }

    public void disableButtonsOnProgress() {
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
    }

    public void enableButtonsAfterProgress() {
        this.getButton(0).setEnabled(true);
        this.getButton(1).setEnabled(true);
    }

    public void setCompleteMarkAfterProgress() {
        TreeItem[] selection = this.pagesTree.getSelection();
        if (selection.length != 1) {
            return;
        }
        TreeItem selectedItem = selection[0];
        selectedItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.OK_MARK));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.getWizard().performCancel();
        } else if (buttonId == 0) {
            if (!this.getWizard().performFinish()) {
                return;
            }
        } else if (buttonId == 16) {
            this.finishPressed();
        } else if (buttonId == 15) {
            this.nextPressed();
        } else if (buttonId == 14) {
            this.backPressed();
        }
        super.buttonPressed(buttonId);
    }

    public IWizardPage getCurrentPage() {
        Object[] selection = this.pagesTree.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return null;
        }
        IDialogPage page = (IDialogPage)selection[0].getData();
        return page instanceof IWizardPage ? (IWizardPage)page : null;
    }

    public void showPage(IWizardPage page) {
        TreeItem[] treeItemArray = this.pagesTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Object[] subPages;
            TreeItem item = treeItemArray[n2];
            if (item.getData() == page) {
                this.pagesTree.setSelection(item);
                this.changePage();
                return;
            }
            if (item.getData() instanceof ICompositeDialogPageContainer && !ArrayUtils.isEmpty((Object[])(subPages = ((ICompositeDialogPageContainer)item.getData()).getDialogPages(false, false)))) {
                Object[] objectArray = subPages;
                int n4 = subPages.length;
                n3 = 0;
                while (n3 < n4) {
                    Object subPage = objectArray[n3];
                    if (subPage == page) {
                        this.pagesTree.setSelection(item);
                        this.changePage();
                        ((ICompositeDialogPageContainer)item.getData()).showSubPage((IDialogPage)page);
                        return;
                    }
                    ++n3;
                }
            }
            TreeItem[] treeItemArray2 = item.getItems();
            n3 = treeItemArray2.length;
            int n5 = 0;
            while (n5 < n3) {
                TreeItem child = treeItemArray2[n5];
                if (child.getData() == page) {
                    this.pagesTree.setSelection(child);
                    this.changePage();
                    return;
                }
                ++n5;
            }
            ++n2;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore());
    }

    public void updateNavigationTree() {
        this.pagesTree.setRedraw(false);
        try {
            IWizardPage[] pages;
            Object selectedPage = this.getSelectedPage();
            this.pagesTree.removeAll();
            new Point(0, 0);
            IWizardPage[] iWizardPageArray = pages = this.wizard.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                this.addNavigationItem(null, (IDialogPage)page);
                ++n2;
            }
            iWizardPageArray = this.pagesTree.getItems();
            n = iWizardPageArray.length;
            n2 = 0;
            while (n2 < n) {
                IWizardPage item = iWizardPageArray[n2];
                if (item.getData() == selectedPage) {
                    this.pagesTree.select((TreeItem)item);
                    break;
                }
                ++n2;
            }
            this.updatePageCompleteMark(null);
        }
        finally {
            this.pagesTree.setRedraw(true);
        }
    }

    private void updatePageCompleteMark(TreeItem parent) {
        if (!this.isNavigableWizard()) {
            return;
        }
        TreeItem[] treeItemArray = parent == null ? this.pagesTree.getItems() : parent.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object page = item.getData();
            if (!(page instanceof IWizardPageNavigable) || ((IWizardPageNavigable)page).isPageNavigable()) {
                if (page instanceof IWizardPage && !((IWizardPage)page).isPageComplete()) {
                    item.setImage(null);
                } else {
                    item.setFont(null);
                    item.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.OK_MARK));
                }
                this.updatePageCompleteMark(item);
            }
            ++n2;
        }
    }

    private TreeItem addNavigationItem(TreeItem parentItem, IDialogPage page) {
        Object[] subPages;
        if (page instanceof IWizardPageNavigable && !((IWizardPageNavigable)page).isPageApplicable()) {
            return null;
        }
        TreeItem item = parentItem == null ? new TreeItem(this.pagesTree, 0) : new TreeItem(parentItem, 0);
        item.setText(CommonUtils.toString((Object)page.getTitle(), (String)page.getClass().getSimpleName()));
        if (page instanceof IWizardPageNavigable && !((IWizardPageNavigable)page).isPageNavigable()) {
            int nnColor = UIStyles.isDarkTheme() ? 18 : 17;
            item.setForeground(this.getShell().getDisplay().getSystemColor(nnColor));
        }
        item.setData((Object)page);
        if (page instanceof IDialogPageProvider && !ArrayUtils.isEmpty((Object[])(subPages = ((IDialogPageProvider)page).getDialogPages(true, this.resizeHasOccurred)))) {
            Object[] objectArray = subPages;
            int n = subPages.length;
            int n2 = 0;
            while (n2 < n) {
                Object subPage = objectArray[n2];
                this.addNavigationItem(item, (IDialogPage)subPage);
                ++n2;
            }
        }
        return item;
    }

    protected void updatePageCompletion() {
        IWizardPage page = this.getCurrentPage();
        if (page instanceof ActiveWizardPage) {
            ((ActiveWizardPage)page).updatePageCompletion();
        }
    }

    public void updateButtons() {
        IWizardPage currentPage;
        Button finishButton = this.getButton(0);
        if (finishButton != null && !finishButton.isDisposed()) {
            finishButton.setEnabled(this.wizard.canFinish());
        }
        if ((currentPage = this.getCurrentPage()) != null) {
            Button prevButton;
            Button nextButton = this.getButton(15);
            if (nextButton != null) {
                nextButton.setEnabled(this.getCurrentPage().isPageComplete() && this.wizard.getNextPage(currentPage) != null);
            }
            if ((prevButton = this.getButton(14)) != null) {
                prevButton.setEnabled(this.wizard.getPreviousPage(currentPage) != null);
            }
        }
        this.updatePageCompleteMark(null);
    }

    public void updateMessage() {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage == null) {
            return;
        }
        String errorMessage = currentPage.getErrorMessage();
        if (!CommonUtils.isEmpty((String)errorMessage)) {
            this.setMessage(errorMessage, 3);
        } else {
            this.setMessage(CommonUtils.notEmpty((String)currentPage.getDescription()), 0);
        }
    }

    public void updateTitle() {
        this.updateWindowTitle();
    }

    public void updateTitleBar() {
    }

    public void updateWindowTitle() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setText(this.getWizard().getWindowTitle());
            this.updateMessage();
        }
    }

    public boolean close() {
        if (this.runningOperations > 0) {
            return false;
        }
        return super.close();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean isDisableControlsOnRun;
        if (this.monitorPart != null) {
            this.monitorPart.setVisible(true);
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState pageEnableState = (isDisableControlsOnRun = this.isDisableControlsOnRun()) ? ControlEnableState.disable((Control)this.wizardSash) : null;
        ControlEnableState buttonsEnableState = isDisableControlsOnRun ? ControlEnableState.disable((Control)this.getButtonBar()) : null;
        try {
            ++this.runningOperations;
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            --this.runningOperations;
            if (buttonsEnableState != null) {
                buttonsEnableState.restore();
            }
            if (pageEnableState != null) {
                pageEnableState.restore();
            }
            if (this.monitorPart != null && !this.monitorPart.isDisposed()) {
                this.monitorPart.done();
                this.monitorPart.setVisible(false);
            }
        }
    }

    protected boolean isDisableControlsOnRun() {
        return false;
    }

    protected void showPage(String pageName) {
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (pageName.equals(page.getName())) {
                this.showPage(page);
                break;
            }
            ++n2;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.finishButtonLabel, this.getShell().getDefaultButton() == null);
        this.createButton(parent, 1, this.cancelButtonLabel, false);
    }

    protected void setFinishButtonLabel(String finishButtonLabel) {
        this.finishButtonLabel = finishButtonLabel;
    }

    protected void setCancelButtonLabel(String cancelButtonLabel) {
        this.cancelButtonLabel = cancelButtonLabel;
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    @NotNull
    protected IWizardPage getStartingPage() {
        return (IWizardPage)this.pagesTree.getItem(0).getData();
    }

    protected void finishPressed() {
    }

    public void nextPressed() {
        IWizard wizard = this.getWizard();
        IWizardPage currentPage = this.getCurrentPage();
        if (!currentPage.isPageComplete()) {
            return;
        }
        IWizardPage nextPage = wizard.getNextPage(currentPage);
        if (nextPage != null) {
            this.showPage(nextPage);
        }
    }

    public void backPressed() {
        IWizardPage currentPage;
        IWizard wizard = this.getWizard();
        IWizardPage prevPage = wizard.getPreviousPage(currentPage = this.getCurrentPage());
        if (prevPage != null) {
            this.showPage(prevPage);
        }
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    private void firePageChanged(final PageChangedEvent event) {
        for (final IPageChangedListener l : this.pageChangedListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
        }
    }

    public void updateSize() {
        this.updateSize(this.getCurrentPage());
    }

    private void updateSize(IWizardPage page) {
        if (page == null || page.getControl() == null) {
            return;
        }
        this.updateSizeForPage(page);
        this.pageArea.layout();
    }

    private void updateSizeForPage(IWizardPage page) {
        Point delta = this.calculatePageSizeDelta(page);
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
            this.constrainShellSize();
        }
    }

    private void updateSizeForWizard(IWizard sizingWizard) {
        IWizardPage[] pages;
        Point delta = new Point(0, 0);
        IWizardPage[] iWizardPageArray = pages = sizingWizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            Point pageDelta = this.calculatePageSizeDelta(page);
            delta.x = Math.max(delta.x, pageDelta.x);
            delta.y = Math.max(delta.y, pageDelta.y);
            ++n2;
        }
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
        }
    }

    private Point calculatePageSizeDelta(IWizardPage page) {
        Control pageControl = page.getControl();
        if (pageControl == null) {
            return new Point(0, 0);
        }
        Point contentSize = pageControl.computeSize(-1, -1, true);
        Rectangle rect = this.pageArea.getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    private void setShellSize(int width, int height) {
        Rectangle size = this.getShell().getBounds();
        size.height = height;
        size.width = width;
        this.getShell().setBounds(this.getConstrainedShellBounds(size));
    }
}

