/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMController;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.registry.BasePlatformImpl;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.SecurityProviderUtils;
import org.jkiss.dbeaver.runtime.qm.QMControllerImpl;
import org.jkiss.dbeaver.runtime.qm.QMLogFileWriter;
import org.jkiss.dbeaver.ui.resources.DefaultResourceHandlerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;

public class DesktopPlatform
extends BasePlatformImpl
implements DBPPlatformEclipse {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.core";
    private static final String TEMP_PROJECT_NAME = ".dbeaver-temp";
    private static final Log log = Log.getLog(DesktopPlatform.class);
    static DesktopPlatform instance;
    @NotNull
    private static volatile boolean isClosing;
    private File tempFolder;
    private BaseWorkspaceImpl workspace;
    private QMControllerImpl queryManager;
    private QMLogFileWriter qmLogWriter;
    private DBACertificateStorage certificateStorage;
    private static boolean disposed;

    static {
        isClosing = false;
        disposed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DesktopPlatform getInstance() {
        if (instance != null) return instance;
        Class<DesktopPlatform> clazz = DesktopPlatform.class;
        synchronized (DesktopPlatform.class) {
            if (disposed) {
                throw new IllegalStateException("DBeaver core already disposed");
            }
            if (instance != null) return instance;
            DesktopPlatform.createInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static DesktopPlatform createInstance() {
        log.debug((Object)("Initializing " + GeneralUtils.getProductTitle()));
        if (Platform.getProduct() != null) {
            Bundle definingBundle = Platform.getProduct().getDefiningBundle();
            if (definingBundle != null) {
                log.debug((Object)("Host plugin: " + definingBundle.getSymbolicName() + " " + definingBundle.getVersion()));
            } else {
                log.debug((Object)"No product bundle found");
            }
        }
        try {
            instance = new DesktopPlatform();
            instance.initialize();
            return instance;
        }
        catch (Throwable e) {
            log.error((Object)"Error initializing desktop platform", e);
            throw new IllegalStateException("Error initializing desktop platform", e);
        }
    }

    public static String getCorePluginID() {
        return DBeaverActivator.getInstance().getBundle().getSymbolicName();
    }

    public static boolean isStandalone() {
        return BaseApplicationImpl.getInstance().isStandalone();
    }

    public static boolean isClosing() {
        if (isClosing) {
            return true;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        return false;
    }

    static void setClosing(boolean closing) {
        isClosing = closing;
    }

    public static DBPPreferenceStore getGlobalPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    private DesktopPlatform() {
    }

    protected void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize Core...");
        if (this.getPreferenceStore().getBoolean("security.jce.bc")) {
            SecurityProviderUtils.registerSecurityProvider();
        }
        this.certificateStorage = new DefaultCertificateStorage(new File(DBeaverActivator.getInstance().getStateLocation().toFile(), "security"));
        this.workspace = (BaseWorkspaceImpl)this.getApplication().createWorkspace((DBPPlatform)this, ResourcesPlugin.getWorkspace());
        this.workspace.initializeProjects();
        QMUtils.initApplication((DBPPlatform)this);
        this.queryManager = new QMControllerImpl();
        this.qmLogWriter = new QMLogFileWriter();
        this.queryManager.registerMetaListener((QMMetaListener)this.qmLogWriter);
        super.initialize();
        log.debug((Object)("Core initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    public synchronized void dispose() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Shutdown Core...");
        DesktopPlatform.setClosing(true);
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationController) {
            ((DBPApplicationController)application).setHeadlessMode(true);
        }
        super.dispose();
        if (this.workspace != null) {
            this.workspace.dispose();
            this.workspace = null;
        }
        if (this.qmLogWriter != null) {
            this.queryManager.unregisterMetaListener((QMMetaListener)this.qmLogWriter);
            this.qmLogWriter.dispose();
            this.qmLogWriter = null;
        }
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
        DataSourceProviderRegistry.getInstance().dispose();
        if (DesktopPlatform.isStandalone() && this.workspace != null && !application.isExclusiveMode()) {
            try {
                this.workspace.save((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException ex) {
                log.error((Object)"Can't save workspace", (Throwable)ex);
            }
        }
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((File)this.tempFolder)) {
                log.warn((Object)("Can't delete temp folder '" + this.tempFolder.getAbsolutePath() + "'"));
            }
            this.tempFolder = null;
        }
        instance = null;
        disposed = true;
        System.gc();
        log.debug((Object)("Shutdown completed in " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    @NotNull
    public DBPWorkspaceEclipse getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPResourceHandler getDefaultResourceHandler() {
        return DefaultResourceHandlerImpl.INSTANCE;
    }

    @NotNull
    public DBPApplication getApplication() {
        return BaseApplicationImpl.getInstance();
    }

    @NotNull
    public QMController getQueryManager() {
        return this.queryManager;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.certificateStorage;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return this.getApplication().getSecureStorage();
    }

    @NotNull
    public DBPExternalFileManager getExternalFileManager() {
        return this.workspace;
    }

    @NotNull
    public File getTempFolder(DBRProgressMonitor monitor, String name) {
        block7: {
            if (this.tempFolder == null) {
                monitor.subTask("Create temp folder");
                try {
                    String tempFolderPath = System.getProperty("dbeaver.io.tmpdir");
                    if (!CommonUtils.isEmpty((String)tempFolderPath)) {
                        File dbTempFolder = new File(tempFolderPath = GeneralUtils.replaceVariables((String)tempFolderPath, (IVariableResolver)new SystemVariablesResolver()));
                        if (!dbTempFolder.mkdirs()) {
                            throw new IOException("Can't create temp directory '" + dbTempFolder.getAbsolutePath() + "'");
                        }
                    } else {
                        tempFolderPath = System.getProperty("java.io.tmpdir");
                    }
                    Path tempDirectory = Files.createTempDirectory(Paths.get(tempFolderPath, new String[0]), TEMP_PROJECT_NAME, new FileAttribute[0]);
                    this.tempFolder = tempDirectory.toFile();
                }
                catch (IOException iOException) {
                    String sysUserFolder;
                    String sysTempFolder = System.getProperty("java.io.tmpdir");
                    if (CommonUtils.isEmpty((String)sysTempFolder)) break block7;
                    this.tempFolder = new File(sysTempFolder, TEMP_PROJECT_NAME);
                    if (this.tempFolder.mkdirs() || CommonUtils.isEmpty((String)(sysUserFolder = System.getProperty("user.home")))) break block7;
                    this.tempFolder = new File(sysUserFolder, TEMP_PROJECT_NAME);
                    if (this.tempFolder.mkdirs()) break block7;
                    this.tempFolder = new File(TEMP_PROJECT_NAME);
                }
            }
        }
        if (!this.tempFolder.exists() && !this.tempFolder.mkdirs()) {
            log.error((Object)("Can't create temp directory " + this.tempFolder.getAbsolutePath()));
        }
        return this.tempFolder;
    }

    @NotNull
    public File getConfigurationFile(String fileName) {
        return DBeaverActivator.getConfigurationFile(fileName);
    }

    public boolean isShuttingDown() {
        return DesktopPlatform.isClosing();
    }
}

