/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.InstallBundleAction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.NLS;

public class UninstallBundleAction
extends ProvisioningAction {
    public static final String ID = "uninstallBundle";

    public IStatus execute(Map<String, Object> parameters) {
        return UninstallBundleAction.uninstallBundle(parameters);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return InstallBundleAction.installBundle(parameters);
    }

    public static IStatus uninstallBundle(Map<String, Object> parameters) {
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String bundleId = (String)parameters.get("bundle");
        if (bundleId == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"bundle", (Object)ID));
        }
        if (QueryUtil.isFragment((IInstallableUnit)iu)) {
            System.out.println("What is a fragment doing here!!! -- " + iu);
            return Status.OK_STATUS;
        }
        BundleInfo bundleInfo = Util.findBundleInfo(manipulator.getConfigData(), iu);
        if (bundleInfo == null) {
            return Util.createWarning(NLS.bind((String)Messages.failed_find_bundleinfo, (Object)iu));
        }
        manipulator.getConfigData().removeBundle(bundleInfo);
        return Status.OK_STATUS;
    }
}

