/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.EclipseApplicationImpl;
import org.jkiss.dbeaver.registry.TimezoneRegistry;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverSettingsImporter;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverSplashHandler;
import org.jkiss.dbeaver.ui.app.standalone.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.app.standalone.rpc.InstanceClient;
import org.jkiss.dbeaver.ui.app.standalone.update.VersionUpdateDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Version;

public class DBeaverApplication
extends EclipseApplicationImpl
implements DBPApplicationController {
    private static final Log log;
    public static final String APPLICATION_PLUGIN_ID = "org.jkiss.dbeaver.ui.app.standalone";
    public static final String WORKSPACE_DIR_LEGACY = "${user.home}/.dbeaver";
    public static final String WORKSPACE_DIR_4 = "${user.home}/.dbeaver4";
    public static final String WORKSPACE_DIR_6;
    private static final Path FILE_WITH_WORKSPACES;
    public static final String DBEAVER_DATA_DIR = "DBeaverData";
    public static final String WORKSPACE_DIR_CURRENT;
    public static final String[] WORKSPACE_DIR_PREVIOUS;
    static final String VERSION_PROP_PRODUCT_NAME = "product-name";
    static final String VERSION_PROP_PRODUCT_VERSION = "product-version";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    static boolean WORKSPACE_MIGRATED;
    static DBeaverApplication instance;
    private boolean exclusiveMode = false;
    private boolean reuseWorkspace = false;
    private boolean primaryInstance = true;
    private boolean headlessMode = false;
    private IInstanceController instanceServer;
    private OutputStream debugWriter;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private Display display = null;
    private boolean resetUIOnRestart;
    private boolean resetWorkspaceOnRestart;
    private long lastUserActivityTime = -1L;

    static {
        String workingDirectory;
        log = Log.getLog(DBeaverApplication.class);
        WORKSPACE_DIR_PREVIOUS = new String[]{WORKSPACE_DIR_4, WORKSPACE_DIR_LEGACY};
        WORKSPACE_MIGRATED = false;
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WIN")) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            workingDirectory = String.valueOf(appData) + "\\" + DBEAVER_DATA_DIR;
        } else if (osName.contains("MAC")) {
            workingDirectory = String.valueOf(System.getProperty("user.home")) + "/Library/" + DBEAVER_DATA_DIR;
        } else {
            String dataHome = System.getProperty("XDG_DATA_HOME");
            if (dataHome == null) {
                dataHome = String.valueOf(System.getProperty("user.home")) + "/.local/share";
            }
            String badWorkingDir = String.valueOf(dataHome) + "/." + DBEAVER_DATA_DIR;
            String goodWorkingDir = String.valueOf(dataHome) + "/" + DBEAVER_DATA_DIR;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        WORKSPACE_DIR_CURRENT = WORKSPACE_DIR_6 = new File(workingDirectory, "workspace6").getAbsolutePath();
        FILE_WITH_WORKSPACES = Paths.get(workingDirectory, ".workspaces");
    }

    public static DBeaverApplication getInstance() {
        return instance;
    }

    public long getLastUserActivityTime() {
        return this.lastUserActivityTime;
    }

    public Object start(IApplicationContext context) {
        String defaultHomePath;
        instance = this;
        Location instanceLoc = Platform.getInstanceLocation();
        CommandLine commandLine = DBeaverCommandLine.getCommandLine();
        if (DBeaverCommandLine.handleCommandLine(commandLine, defaultHomePath = this.getDefaultInstanceLocation())) {
            System.err.println("Commands processed. Exit " + GeneralUtils.getProductName() + ".");
            return IApplication.EXIT_OK;
        }
        boolean ideWorkspaceSet = DBeaverApplication.setIDEWorkspace(instanceLoc);
        try {
            if (!instanceLoc.isSet() ? !this.setDefaultWorkspacePath(instanceLoc) : instanceLoc.isLocked() && !ideWorkspaceSet && !this.isExclusiveMode() && !this.setDefaultWorkspacePath(instanceLoc)) {
                return IApplication.EXIT_OK;
            }
            if (this.isExclusiveMode()) {
                this.markLocationReadOnly(instanceLoc);
            } else if (!instanceLoc.isLocked()) {
                instanceLoc.lock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.headlessMode = true;
            if (DBeaverCommandLine.handleCustomParameters(commandLine)) {
                Integer n = IApplication.EXIT_OK;
                return n;
            }
        }
        finally {
            this.headlessMode = false;
        }
        if (this.isExclusiveMode()) {
            return IApplication.EXIT_OK;
        }
        this.initDebugWriter();
        TimezoneRegistry.overrideTimezone();
        this.updateSplashHandler();
        Runtime runtime = Runtime.getRuntime();
        log.debug((Object)(String.valueOf(GeneralUtils.getProductName()) + " " + GeneralUtils.getProductVersion() + " is starting"));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        log.debug((Object)("Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (" + System.getProperty("sun.arch.data.model") + "bit)"));
        log.debug((Object)("Install path: '" + SystemVariablesResolver.getInstallPath() + "'"));
        log.debug((Object)("Instance path: '" + instanceLoc.getURL() + "'"));
        log.debug((Object)("Memory available " + runtime.totalMemory() / 0x100000L + "Mb/" + runtime.maxMemory() / 0x100000L + "Mb"));
        DBeaverApplication.writeWorkspaceInfo();
        this.initializeApplication();
        this.instanceServer = DBeaverInstanceServer.startInstanceServer(commandLine, this.createInstanceController());
        PlatformUI.getPreferenceStore().setDefault("KEY_CONFIGURATION_ID", "org.jkiss.dbeaver.defaultKeyScheme");
        try {
            log.debug((Object)"Run workbench");
            this.getDisplay();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
            if (this.resetUIOnRestart || this.resetWorkspaceOnRestart) {
                this.resetUISettings(instanceLoc);
            }
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        catch (Throwable e) {
            log.debug((Object)"Internal error in workbench lifecycle", e);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            this.shutdown();
            this.display.dispose();
            this.display = null;
        }
    }

    private void markLocationReadOnly(Location instanceLoc) {
        try {
            Field isReadOnlyField = instanceLoc.getClass().getDeclaredField("isReadOnly");
            isReadOnlyField.setAccessible(true);
            isReadOnlyField.set(instanceLoc, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static boolean setIDEWorkspace(@NotNull Location instanceLoc) {
        if (instanceLoc.isSet()) {
            return false;
        }
        Collection<String> recentWorkspaces = DBeaverApplication.getRecentWorkspaces(instanceLoc);
        if (recentWorkspaces.isEmpty()) {
            return false;
        }
        String lastWorkspace = recentWorkspaces.iterator().next();
        if (!CommonUtils.isEmpty((String)lastWorkspace) && !WORKSPACE_DIR_CURRENT.equals(lastWorkspace)) {
            try {
                URL selectedWorkspaceURL = new URL("file", null, lastWorkspace);
                instanceLoc.set(selectedWorkspaceURL, true);
                return true;
            }
            catch (Exception e) {
                System.err.println("Can't set IDE workspace to '" + lastWorkspace + "'");
                e.printStackTrace();
            }
        }
        return false;
    }

    @NotNull
    private static Collection<String> getRecentWorkspaces(@NotNull Location instanceLoc) {
        ArrayList<Object> recentWorkspaces;
        int maxSize;
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        String[] arrayOfRecentWorkspaces = launchData.getRecentWorkspaces();
        if (arrayOfRecentWorkspaces == null) {
            maxSize = 0;
            recentWorkspaces = new ArrayList<String>();
        } else {
            maxSize = arrayOfRecentWorkspaces.length;
            recentWorkspaces = new ArrayList<String>(Arrays.asList(arrayOfRecentWorkspaces));
        }
        recentWorkspaces.removeIf(Objects::isNull);
        Collection<String> backedUpWorkspaces = DBeaverApplication.getBackedUpWorkspaces();
        if (recentWorkspaces.equals(backedUpWorkspaces) && backedUpWorkspaces.contains(WORKSPACE_DIR_CURRENT)) {
            return backedUpWorkspaces;
        }
        List<String> workspaces = Stream.concat(recentWorkspaces.stream(), backedUpWorkspaces.stream()).distinct().limit(maxSize).collect(Collectors.toList());
        if (!recentWorkspaces.contains(WORKSPACE_DIR_CURRENT)) {
            if (recentWorkspaces.size() < maxSize) {
                recentWorkspaces.add(WORKSPACE_DIR_CURRENT);
            } else if (maxSize > 1) {
                workspaces.set(recentWorkspaces.size() - 1, WORKSPACE_DIR_CURRENT);
            }
        }
        launchData.setRecentWorkspaces(Arrays.copyOf(workspaces.toArray(new String[0]), maxSize));
        launchData.writePersistedData();
        DBeaverApplication.saveWorkspacesToBackup(workspaces);
        return workspaces;
    }

    @NotNull
    private static Collection<String> getBackedUpWorkspaces() {
        if (!Files.exists(FILE_WITH_WORKSPACES, new LinkOption[0]) || Files.isDirectory(FILE_WITH_WORKSPACES, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.readAllLines(FILE_WITH_WORKSPACES);
        }
        catch (IOException e) {
            System.err.println("Unable to read backed up workspaces");
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static void saveWorkspacesToBackup(@NotNull List<? extends CharSequence> workspaces) {
        try {
            if (!Files.exists(FILE_WITH_WORKSPACES.getParent(), new LinkOption[0])) {
                Files.createDirectories(FILE_WITH_WORKSPACES.getParent(), new FileAttribute[0]);
            } else if (Files.isDirectory(FILE_WITH_WORKSPACES, new LinkOption[0])) {
                try {
                    Files.delete(FILE_WITH_WORKSPACES);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Files.write(FILE_WITH_WORKSPACES, workspaces, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            System.err.println("Unable to save backed up workspaces");
            e.printStackTrace();
        }
    }

    @Nullable
    public Path getDefaultWorkingFolder() {
        return Path.of(WORKSPACE_DIR_CURRENT, new String[0]);
    }

    private String getDefaultInstanceLocation() {
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc.isSet()) {
            try {
                defaultHomePath = RuntimeUtils.getLocalFileFromURL((URL)instanceLoc.getURL()).getAbsolutePath();
            }
            catch (IOException e) {
                System.err.println("Unable to resolve workspace location " + instanceLoc);
                e.printStackTrace();
            }
        }
        return defaultHomePath;
    }

    private void updateSplashHandler() {
        if (ArrayUtils.contains((Object[])Platform.getApplicationArgs(), (Object)"-nosplash")) {
            return;
        }
        try {
            this.getDisplay();
            Shell shell = WorkbenchPlugin.getSplashShell((Display)this.display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.println("Error updating splash shell");
        }
        Log.addListener((message, t) -> DBeaverSplashHandler.showMessage(CommonUtils.toString((Object)message)));
    }

    protected IInstanceController createInstanceController() {
        return new DBeaverInstanceServer();
    }

    private void resetUISettings(Location instanceLoc) {
        try {
            File settingsFile;
            File instanceDir = new File(instanceLoc.getURL().toURI());
            if (instanceDir.exists() && (settingsFile = new File(instanceDir, ".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi")).exists()) {
                settingsFile.deleteOnExit();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error resetting UI settings", e);
        }
    }

    private void markFoldertoDelete(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.markFoldertoDelete(file);
                } else {
                    log.debug((Object)("Delete resource file " + file.getAbsolutePath()));
                    file.deleteOnExit();
                }
                ++n2;
            }
        }
        folder.deleteOnExit();
    }

    protected void initializeApplication() {
    }

    private Display getDisplay() {
        if (this.display == null) {
            log.debug((Object)"Create display");
            Display.setAppName((String)GeneralUtils.getProductName());
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = PlatformUI.createDisplay();
            }
            this.addIdleListeners();
        }
        return this.display;
    }

    private void addIdleListeners() {
        int[] events = new int[]{1, 2, 3, 5, 4, 37};
        Listener idleListener = event -> {
            long l = this.lastUserActivityTime = System.currentTimeMillis();
        };
        int[] nArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            int event2 = nArray[n2];
            this.display.addFilter(event2, idleListener);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setDefaultWorkspacePath(Location instanceLoc) {
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        Path homeDir = Path.of(defaultHomePath, new String[0]);
        try {
            if (!Files.exists(homeDir, new LinkOption[0]) || Files.list(homeDir).count() == 0L) {
                DBeaverSettingsImporter importer;
                Path previousVersionWorkspaceDir = null;
                String[] stringArray = WORKSPACE_DIR_PREVIOUS;
                int n = WORKSPACE_DIR_PREVIOUS.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldDir = stringArray[n2];
                    Path oldWorkspaceDir = Path.of(oldDir = GeneralUtils.replaceSystemPropertyVariables((String)oldDir), new String[0]);
                    if (Files.exists(oldWorkspaceDir, new LinkOption[0]) && Files.exists(GeneralUtils.getMetadataFolder((Path)oldWorkspaceDir), new LinkOption[0])) {
                        previousVersionWorkspaceDir = oldWorkspaceDir;
                        break;
                    }
                    ++n2;
                }
                if (previousVersionWorkspaceDir != null && !(importer = new DBeaverSettingsImporter(this, this.getDisplay())).migrateFromPreviousVersion(previousVersionWorkspaceDir.toFile(), homeDir.toFile())) {
                    return false;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error migrating old workspace version", e);
        }
        try {
            URL defaultHomeURL = new URL("file", null, defaultHomePath);
            boolean keepTrying = true;
            while (keepTrying) {
                if (!instanceLoc.isLocked()) {
                    if (instanceLoc.set(defaultHomeURL, true)) return true;
                }
                if (this.exclusiveMode || this.reuseWorkspace) {
                    instanceLoc.set(defaultHomeURL, false);
                    keepTrying = false;
                    this.primaryInstance = false;
                    continue;
                }
                int msgResult = this.showMessageBox("DBeaver - Can't lock workspace", "Can't lock workspace at " + defaultHomePath + ".\n" + "It seems that you have another DBeaver instance running.\n" + "You may ignore it and work without lock but it is recommended to shutdown previous instance otherwise you may corrupt workspace data.", 3592);
                switch (msgResult) {
                    case 512: {
                        return false;
                    }
                    case 2048: {
                        instanceLoc.set(defaultHomeURL, false);
                        keepTrying = false;
                        this.primaryInstance = false;
                        break;
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            System.err.println("Can't switch workspace to '" + defaultHomePath + "' - " + e.getMessage());
        }
        return true;
    }

    public static void writeWorkspaceInfo() {
        Path metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((Path)metadataFolder);
        props.setProperty(VERSION_PROP_PRODUCT_NAME, GeneralUtils.getProductName());
        props.setProperty(VERSION_PROP_PRODUCT_VERSION, GeneralUtils.getProductVersion().toString());
        BaseWorkspaceImpl.writeWorkspaceInfo((Path)metadataFolder, (Properties)props);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new ApplicationWorkbenchAdvisor();
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    private void shutdown() {
        log.debug((Object)"DBeaver is stopping");
        try {
            try {
                this.instanceServer = null;
                RuntimeUtils.runTask(monitor -> DBeaverInstanceServer.stopInstanceServer(), (String)"Stop RMI", (long)1000L);
            }
            catch (Throwable e) {
                log.error((Object)e);
                instance = null;
                log.debug((Object)"DBeaver shutdown completed");
                this.stopDebugWriter();
            }
        }
        finally {
            instance = null;
            log.debug((Object)"DBeaver shutdown completed");
            this.stopDebugWriter();
        }
    }

    private void initDebugWriter() {
        File debugLogFile;
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (!preferenceStore.getBoolean("logs.debug.enabled")) {
            return;
        }
        String logLocation = preferenceStore.getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = GeneralUtils.getMetadataFolder().resolve("dbeaver-debug.log").toAbsolutePath().toString();
        }
        if ((debugLogFile = new File(logLocation = GeneralUtils.replaceVariables((String)logLocation, (IVariableResolver)new SystemVariablesResolver()))).exists() && !debugLogFile.delete()) {
            System.err.println("Can't delete debug log file");
            return;
        }
        try {
            this.debugWriter = new FileOutputStream(debugLogFile);
            this.oldSystemOut = System.out;
            this.oldSystemErr = System.err;
            System.setOut(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemOut)));
            System.setErr(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemErr)));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void stopDebugWriter() {
        if (this.oldSystemOut != null) {
            System.setOut(this.oldSystemOut);
        }
        if (this.oldSystemErr != null) {
            System.setErr(this.oldSystemErr);
        }
        if (this.debugWriter != null) {
            IOUtils.close((Closeable)this.debugWriter);
            this.debugWriter = null;
        }
    }

    public IInstanceController getInstanceServer() {
        return this.instanceServer;
    }

    public IInstanceController createInstanceClient() {
        return InstanceClient.createClient(this.getDefaultInstanceLocation());
    }

    private static File getDefaultWorkspaceLocation(String path) {
        return new File(System.getProperty("user.home"), path);
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return this.primaryInstance;
    }

    public boolean isHeadlessMode() {
        return this.headlessMode;
    }

    public boolean isExclusiveMode() {
        return this.exclusiveMode;
    }

    public void setExclusiveMode(boolean exclusiveMode) {
        this.exclusiveMode = exclusiveMode;
    }

    public boolean isReuseWorkspace() {
        return this.reuseWorkspace;
    }

    public void setReuseWorkspace(boolean reuseWorkspace) {
        this.reuseWorkspace = reuseWorkspace;
    }

    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        return null;
    }

    public String getDefaultProjectName() {
        return "General";
    }

    private int showMessageBox(String title, String message, int style) {
        Shell shell = new Shell(this.getDisplay(), 16384);
        shell.setText(GeneralUtils.getProductTitle());
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        int msgResult = messageBox.open();
        shell.dispose();
        return msgResult;
    }

    public void notifyVersionUpgrade(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showSkip) {
        VersionUpdateDialog dialog = new VersionUpdateDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public void setResetUIOnRestart(boolean resetUIOnRestart) {
        this.resetUIOnRestart = resetUIOnRestart;
    }

    public void setResetWorkspaceOnRestart(boolean resetWorkspaceOnRestart) {
        this.resetWorkspaceOnRestart = resetWorkspaceOnRestart;
    }

    private class ProxyPrintStream
    extends OutputStream {
        private final OutputStream debugWriter;
        private final OutputStream stdOut;

        ProxyPrintStream(OutputStream debugWriter, OutputStream stdOut) {
            this.debugWriter = debugWriter;
            this.stdOut = stdOut;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.debugWriter.write(b, off, len);
            this.stdOut.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.debugWriter.flush();
            this.stdOut.flush();
        }
    }
}

