/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOListener;
import org.jkiss.dbeaver.model.fs.nio.NIOMonitor;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBNFileSystems
extends DBNNode
implements NIOListener {
    private static final Log log = Log.getLog(DBNFileSystems.class);
    private DBNFileSystem[] children;

    public DBNFileSystems(DBNProject parentNode) {
        super(parentNode);
        NIOMonitor.addListener(this);
    }

    @Override
    protected void dispose(boolean reflect) {
        super.dispose(reflect);
        NIOMonitor.removeListener(this);
    }

    @Override
    public String getNodeType() {
        return "FileSystemRoot";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return "File Systems";
    }

    @Override
    public String getNodeDescription() {
        return "All virtual file systems";
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public DBNFileSystem getFileSystem(@Nullable String type, @NotNull String id) {
        if (this.children == null) {
            return null;
        }
        DBNFileSystem[] dBNFileSystemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fsNode = dBNFileSystemArray[n2];
            DBFVirtualFileSystem fs = fsNode.getFileSystem();
            if ((type == null || fs.getType().equals(type)) && fs.getId().equals(id)) {
                return fsNode;
            }
            ++n2;
        }
        return null;
    }

    public DBNFileSystemRoot getRootFolder(@NotNull DBRProgressMonitor monitor, @NotNull String id) throws DBException {
        DBNFileSystem[] dBNFileSystemArray = this.getChildren(monitor);
        int n = dBNFileSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fsNode = dBNFileSystemArray[n2];
            DBNFileSystemRoot rootFolder = fsNode.getChild(monitor, id);
            if (rootFolder != null) {
                return rootFolder;
            }
            ++n2;
        }
        return null;
    }

    public DBNFileSystem[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNFileSystem[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Read available file systems", 1);
        ArrayList<DBNFileSystem> result = new ArrayList<DBNFileSystem>();
        DBFFileSystemDescriptor[] dBFFileSystemDescriptorArray = DBWorkbench.getPlatform().getFileSystemRegistry().getFileSystemProviders();
        int n = dBFFileSystemDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBFVirtualFileSystem[] fsList;
            DBFFileSystemDescriptor fsProvider = dBFFileSystemDescriptorArray[n2];
            DBFVirtualFileSystem[] dBFVirtualFileSystemArray = fsList = fsProvider.getInstance().getAvailableFileSystems(monitor, this.getModel().getModelAuthContext());
            int n3 = fsList.length;
            int n4 = 0;
            while (n4 < n3) {
                DBFVirtualFileSystem fs = dBFVirtualFileSystemArray[n4];
                DBNFileSystem newChild = new DBNFileSystem(this, fs);
                result.add(newChild);
                ++n4;
            }
            ++n2;
        }
        result.sort(DBUtils.nameComparatorIgnoreCase());
        monitor.done();
        return result.toArray(new DBNFileSystem[0]);
    }

    public DBNPathBase findNodeByPath(DBRProgressMonitor monitor, String path) throws DBException {
        this.getChildren(monitor);
        DBNFileSystemRoot fsNode = null;
        DBNPathBase curPath = null;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!(name.isEmpty() || curPath == null && name.endsWith(":"))) {
                if (fsNode == null) {
                    fsNode = this.getRootFolder(monitor, name);
                    if (fsNode == null) {
                        return null;
                    }
                } else {
                    if (curPath == null) {
                        fsNode.getChildren(monitor);
                        curPath = fsNode.getChild(name);
                    } else {
                        curPath.getChildren(monitor);
                        curPath = curPath.getChild(name);
                    }
                    if (curPath == null) {
                        return null;
                    }
                }
            }
            ++n2;
        }
        return curPath == null ? fsNode : curPath;
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) {
        this.children = null;
        return this;
    }

    public void resetFileSystems() {
        this.children = null;
        this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(DBNNode.NodePathType.dbvfs.getPrefix()) + ((DBNProject)this.getParentNode()).getRawNodeItemPath() + "/" + this.getNodeName();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public void resourceChanged(NIOResource resource, NIOListener.Action action) {
        if (!CommonUtils.equalObjects((Object)this.getOwnerProject().getEclipseProject(), (Object)resource.getProject())) {
            return;
        }
        if (this.children == null) {
            return;
        }
        DBFVirtualFileSystemRoot dbfRoot = resource.getRoot().getRoot();
        DBNFileSystem[] dBNFileSystemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fs = dBNFileSystemArray[n2];
            if (CommonUtils.equalObjects((Object)fs.getFileSystem(), (Object)dbfRoot.getFileSystem())) {
                DBNFileSystemRoot rootNode = fs.getRoot(dbfRoot);
                if (rootNode == null) break;
                String[] pathSegments = resource.getFullPath().segments();
                DBNPathBase parentNode = rootNode;
                int i = 1;
                while (i < pathSegments.length - 1) {
                    String itemName = pathSegments[i];
                    if ((parentNode = parentNode.getChild(itemName)) == null) {
                        return;
                    }
                    ++i;
                }
                switch (action) {
                    case CREATE: {
                        parentNode.addChildResource(resource.getNioPath());
                        break;
                    }
                    case DELETE: {
                        parentNode.removeChildResource(resource.getNioPath());
                        break;
                    }
                }
                break;
            }
            ++n2;
        }
    }

    public String toString() {
        return "FileSystems(" + this.getOwnerProject().getName() + ")";
    }
}

