/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.ExternalContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentChars;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCContentCLOB
extends JDBCContentLOB
implements DBDContent {
    private static final Log log = Log.getLog(JDBCContentCLOB.class);
    private Clob clob;
    private Reader tmpReader;

    public JDBCContentCLOB(DBCExecutionContext executionContext, Clob clob) {
        super(executionContext);
        this.clob = clob;
    }

    @Override
    public long getLOBLength() throws DBCException {
        if (this.clob == null) {
            return 0L;
        }
        try {
            return this.clob.length();
        }
        catch (Throwable e) {
            throw new DBCException(e, this.executionContext);
        }
    }

    @Override
    @NotNull
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.clob != null) {
            DBPPlatform platform;
            long contentLength = this.getContentLength();
            if (contentLength < (long)(platform = this.executionContext.getDataSource().getContainer().getPlatform()).getPreferenceStore().getInt("content.memory.maxsize")) {
                try {
                    String subString = this.clob.getSubString(1L, (int)contentLength);
                    this.storage = new JDBCContentChars(this.executionContext, subString);
                }
                catch (Exception e) {
                    log.debug("Can't get CLOB as substring", e);
                    try {
                        this.storage = StringContentStorage.createFromReader(this.clob.getCharacterStream(), contentLength);
                    }
                    catch (IOException iOException) {
                        throw new DBCException("IO error while reading content", e);
                    }
                    catch (Throwable throwable) {
                        throw new DBCException((Throwable)e, this.executionContext);
                    }
                }
            } else {
                File tempFile;
                try {
                    tempFile = ContentUtils.createTempContentFile(monitor, platform, "clob" + this.clob.hashCode());
                }
                catch (IOException e) {
                    throw new DBCException("Can't create temp file", e);
                }
                try {
                    Throwable e = null;
                    Object var7_12 = null;
                    try (OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), this.getDefaultEncoding());){
                        ContentUtils.copyStreams(this.clob.getCharacterStream(), contentLength, os, monitor);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    ContentUtils.deleteTempFile(tempFile);
                    throw new DBCException("IO error while copying content", e);
                }
                catch (Throwable e) {
                    ContentUtils.deleteTempFile(tempFile);
                    throw new DBCException(e, this.executionContext);
                }
                this.storage = new TemporaryContentStorage(platform, tempFile, this.getDefaultEncoding(), true);
            }
            this.releaseClob();
        }
        return this.storage;
    }

    @Override
    public void release() {
        this.releaseTempStream();
        this.releaseClob();
        super.release();
    }

    private void releaseClob() {
        if (this.clob != null) {
            try {
                this.clob.free();
            }
            catch (Throwable e) {
                log.debug("Error freeing CLOB: " + e.getClass().getName() + ": " + e.getMessage());
            }
            this.clob = null;
        }
    }

    private void releaseTempStream() {
        if (this.tmpReader != null) {
            ContentUtils.close(this.tmpReader);
            this.tmpReader = null;
        }
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        block12: {
            try {
                if (this.storage != null) {
                    this.releaseTempStream();
                    this.tmpReader = this.storage.getContentReader();
                    try {
                        preparedStatement.setNCharacterStream(paramIndex, this.tmpReader);
                    }
                    catch (Throwable e) {
                        if (e instanceof SQLException && !(e instanceof SQLFeatureNotSupportedException)) {
                            throw (SQLException)e;
                        }
                        long streamLength = ContentUtils.calculateContentLength(this.storage.getContentReader());
                        try {
                            preparedStatement.setCharacterStream(paramIndex, this.tmpReader, streamLength);
                            break block12;
                        }
                        catch (Throwable e1) {
                            if (e1 instanceof SQLException && !(e instanceof SQLFeatureNotSupportedException)) {
                                throw (SQLException)e1;
                            }
                            preparedStatement.setCharacterStream(paramIndex, this.tmpReader, (int)streamLength);
                        }
                    }
                    break block12;
                }
                if (this.clob != null) {
                    preparedStatement.setClob(paramIndex, this.clob);
                } else {
                    preparedStatement.setNull(paramIndex, 2005);
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
            catch (Throwable e) {
                throw new DBCException("IO error while binding content", e);
            }
        }
    }

    @Override
    public Object getRawValue() {
        return this.clob;
    }

    @Override
    public boolean isNull() {
        return this.clob == null && this.storage == null;
    }

    @Override
    protected JDBCContentLOB createNewContent() {
        return new JDBCContentCLOB(this.executionContext, null);
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        if (this.clob == null && this.storage == null) {
            return null;
        }
        if (this.storage != null) {
            if (this.storage instanceof DBDContentCached) {
                return CommonUtils.toString((Object)((DBDContentCached)((Object)this.storage)).getCachedValue());
            }
            if (this.storage instanceof ExternalContentStorage) {
                return "[" + ((ExternalContentStorage)this.storage).getFile().getName() + "]";
            }
        }
        return "[CLOB]";
    }
}

