/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.views;

import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndexColumn;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class GenericTableIndexConfigurator
implements DBEObjectConfigurator<GenericTableIndex> {
    public GenericTableIndex configureObject(DBRProgressMonitor monitor, Object table, final GenericTableIndex index, Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)table;
        final boolean supportUniqueIndexes = tableBase.supportUniqueIndexes();
        final Collection tableIndexTypes = tableBase.getTableIndexTypes();
        return (GenericTableIndex)new UITask<GenericTableIndex>(){

            protected GenericTableIndex runTask() {
                EditIndexPage editPage = new EditIndexPage("Create index", (DBSTableIndex)index, tableIndexTypes, supportUniqueIndexes);
                if (!editPage.edit()) {
                    return null;
                }
                index.setIndexType(editPage.getIndexType());
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)((GenericTableBase)index.getTable()).getName()));
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    if (colIndex == 1) {
                        idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                    }
                    index.addColumn(new GenericTableIndexColumn(index, (GenericTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc"))));
                }
                idxName.append("_IDX");
                index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
                index.setUnique(editPage.isUnique());
                return index;
            }
        }.execute();
    }
}

