/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards.navicat;

import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.utils.CommonUtils;

public class NavicatEncrypt {
    private static final String NAVICAT_CODE = "3DC5CA39";
    private byte[] _iv;
    private SecretKeySpec keySpec;
    private Cipher _chiperCrypt;
    private Cipher _chiperDecrypt;

    public NavicatEncrypt() {
        this.initKey();
        this.initChiperEncrypt();
        this.initChiperDecrypt();
        this.initIV();
    }

    private void initKey() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(NAVICAT_CODE.getBytes("US-ASCII"), 0, NAVICAT_CODE.length());
            byte[] key = md.digest();
            this.keySpec = new SecretKeySpec(key, "Blowfish");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initChiperEncrypt() {
        try {
            this._chiperCrypt = Cipher.getInstance("Blowfish/ECB/NoPadding");
            this._chiperCrypt.init(1, this.keySpec);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initChiperDecrypt() {
        try {
            this._chiperDecrypt = Cipher.getInstance("Blowfish/ECB/NoPadding");
            this._chiperDecrypt.init(2, this.keySpec);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initIV() {
        try {
            byte[] initVec = CommonUtils.parseHexString((String)"FFFFFFFFFFFFFFFF");
            this._iv = this._chiperCrypt.doFinal(initVec);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void xorBytes(byte[] a, byte[] b) {
        int i = 0;
        while (i < a.length) {
            int aVal = a[i] & 0xFF;
            int bVal = b[i] & 0xFF;
            a[i] = (byte)(aVal ^ bVal);
            ++i;
        }
    }

    private void xorBytes(byte[] a, byte[] b, int l) {
        int i = 0;
        while (i < l) {
            int aVal = a[i] & 0xFF;
            int bVal = b[i] & 0xFF;
            a[i] = (byte)(aVal ^ bVal);
            ++i;
        }
    }

    public String encrypt(String inputString) {
        try {
            byte[] inData = inputString.getBytes("US-ASCII");
            byte[] outData = this.encrypt(inData);
            return CommonUtils.toHexString((byte[])outData);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    private byte[] encrypt(byte[] inData) {
        try {
            byte[] CV = Arrays.copyOf(this._iv, this._iv.length);
            byte[] ret = new byte[inData.length];
            int left = inData.length % 8;
            int rounded = Math.floorDiv(inData.length, 8);
            int i = 0;
            while (i < rounded) {
                byte[] tmp = Arrays.copyOfRange(inData, i * 8, i * 8 + 8);
                this.xorBytes(tmp, CV);
                tmp = this._chiperCrypt.doFinal(tmp);
                this.xorBytes(CV, tmp);
                int j = 0;
                while (j < tmp.length) {
                    ret[i * 8 + j] = tmp[j];
                    ++j;
                }
                ++i;
            }
            if (left != 0) {
                CV = this._chiperCrypt.doFinal(CV);
                byte[] tmp = Arrays.copyOfRange(inData, rounded * 8, rounded * 8 + left);
                this.xorBytes(tmp, CV, left);
                int j = 0;
                while (j < tmp.length) {
                    ret[rounded * 8 + j] = tmp[j];
                    ++j;
                }
            }
            return ret;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String decrypt(String hexString) {
        try {
            byte[] inData = CommonUtils.parseHexString((String)hexString);
            byte[] outData = this.decrypt(inData);
            return new String(outData);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    private byte[] decrypt(byte[] inData) {
        try {
            byte[] CV = Arrays.copyOf(this._iv, this._iv.length);
            byte[] ret = new byte[inData.length];
            int left = inData.length % 8;
            int rounded = Math.floorDiv(inData.length, 8);
            int i = 0;
            while (i < rounded) {
                byte[] tmp = Arrays.copyOfRange(inData, i * 8, i * 8 + 8);
                tmp = this._chiperDecrypt.doFinal(tmp);
                this.xorBytes(tmp, CV);
                int j = 0;
                while (j < tmp.length) {
                    ret[i * 8 + j] = tmp[j];
                    ++j;
                }
                j = 0;
                while (j < CV.length) {
                    CV[j] = (byte)(CV[j] ^ inData[i * 8 + j]);
                    ++j;
                }
                ++i;
            }
            if (left != 0) {
                CV = this._chiperDecrypt.doFinal(CV);
                byte[] tmp = Arrays.copyOfRange(inData, rounded * 8, rounded * 8 + left);
                this.xorBytes(tmp, CV, left);
                int j = 0;
                while (j < tmp.length) {
                    ret[rounded * 8 + j] = tmp[j];
                    ++j;
                }
            }
            return ret;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

