/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.Map;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridRow;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetValueReflector;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetCellEditor;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class Spreadsheet
extends LightGrid
implements Listener {
    public static final int MAX_INLINE_EDIT_WITH = 300;
    @NotNull
    private final SpreadsheetCellEditor tableEditor;
    @NotNull
    private final IWorkbenchPartSite site;
    @NotNull
    private final SpreadsheetPresentation presentation;
    @NotNull
    private final IGridContentProvider contentProvider;
    @NotNull
    private final IGridLabelProvider labelProvider;
    @Nullable
    private final IGridController gridController;
    private Clipboard clipboard;

    public Spreadsheet(@NotNull Composite parent, int style, @NotNull IWorkbenchPartSite site, @NotNull SpreadsheetPresentation presentation, @NotNull IGridContentProvider contentProvider, @NotNull IGridLabelProvider labelProvider, @Nullable IGridController gridController) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, true);
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.site = site;
        this.presentation = presentation;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.gridController = gridController;
        this.clipboard = new Clipboard(this.getDisplay());
        super.setRowHeaderVisible(true);
        super.setLinesVisible(true);
        super.setHeaderVisible(true);
        super.setMaxColumnDefWidth(DBWorkbench.getPlatform().getPreferenceStore().getInt("resultset.max.column.def.width"));
        super.addListener(8, (Listener)this);
        super.addListener(3, (Listener)this);
        super.addListener(1, (Listener)this);
        super.addListener(2, (Listener)this);
        super.addListener(1000, (Listener)this);
        super.addListener(1001, (Listener)this);
        super.addListener(1002, (Listener)this);
        this.tableEditor = new SpreadsheetCellEditor(this);
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.verticalAlignment = 128;
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.grabVertical = true;
        this.tableEditor.minimumWidth = 50;
        this.hookContextMenu();
        this.hookAccessibility();
        super.addDisposeListener(e -> {
            if (this.clipboard != null && !this.clipboard.isDisposed()) {
                this.clipboard.dispose();
            }
        });
    }

    @NotNull
    public SpreadsheetPresentation getPresentation() {
        return this.presentation;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public GridPos getCursorPosition() {
        if (super.isDisposed()) {
            return new GridPos(-1, -1);
        }
        return super.getFocusPos();
    }

    @Nullable
    public GridCell getCursorCell() {
        if (super.isDisposed()) {
            return null;
        }
        return super.getFocusCell();
    }

    public boolean shiftCursor(int xOffset, int yOffset, boolean keepSelection) {
        GridCell newCell;
        if (xOffset == 0 && yOffset == 0) {
            return false;
        }
        GridPos curPos = this.getCursorPosition();
        if (curPos == null) {
            return false;
        }
        GridPos newPos = new GridPos(curPos.col, curPos.row);
        if (yOffset != 0) {
            int newRow = curPos.row + yOffset;
            if (newRow < 0) {
                newRow = 0;
            }
            if (newRow >= this.getItemCount()) {
                newRow = this.getItemCount() - 1;
            }
            newPos.row = newRow;
        }
        if (xOffset != 0) {
            int newCol = curPos.col + xOffset;
            if (newCol < 0) {
                newCol = 0;
            }
            if (newCol >= this.getColumnCount()) {
                newCol = this.getColumnCount() - 1;
            }
            newPos.col = newCol;
        }
        if ((newCell = this.posToCell(newPos)) != null) {
            this.setCursor(newCell, keepSelection, true, true);
        }
        return true;
    }

    void setCursor(@NotNull GridCell cell, boolean keepSelection, boolean showColumn, boolean notify) {
        Event selectionEvent = new Event();
        selectionEvent.data = cell;
        GridPos pos = this.cellToPos(cell);
        if (pos.row >= 0) {
            super.setFocusItem(pos.row);
            super.showItem(pos.row);
        }
        if (pos.col >= 0) {
            super.setFocusColumn(pos.col);
            if (showColumn) {
                super.showColumn(pos.col);
            }
        }
        if (!keepSelection) {
            super.deselectAll();
        }
        super.selectCell(pos);
        if (notify) {
            selectionEvent.data = cell;
            this.notifyListeners(13, selectionEvent);
        }
    }

    public void addCursorChangeListener(Listener listener) {
        super.addListener(13, listener);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: {
                boolean ctrlPressed;
                boolean bl = ctrlPressed = (event.stateMask & 0x40000) != 0;
                if (!(!ctrlPressed && (event.keyCode == 13 || event.keyCode >= 0x1000030 && event.keyCode <= 16777273 || event.keyCode == 45 || event.keyCode == 43 || event.keyCode == 16777259 || event.keyCode == 16777261 || event.keyCode >= 97 && event.keyCode <= 122 || event.keyCode >= 48 && event.keyCode <= 57)) && !Character.isLetterOrDigit(event.character)) break;
                Control editorControl = this.tableEditor.getEditor();
                if (editorControl == null || editorControl.isDisposed()) {
                    editorControl = this.presentation.openValueEditor(true);
                }
                SpreadsheetPresentation presentation = this.getPresentation();
                DBDAttributeBinding attribute = presentation.getCurrentAttribute();
                if (editorControl == null || attribute == null || presentation.getController().getAttributeReadOnlyStatus(attribute) != null || event.keyCode == 13 || editorControl.isDisposed()) break;
                String strValue = String.valueOf(event.character);
                if (editorControl instanceof Text) {
                    ((Text)editorControl).insert(strValue);
                    break;
                }
                if (!(editorControl instanceof StyledText)) break;
                ((StyledText)editorControl).insert(strValue);
                break;
            }
            case 8: {
                if (event.button != 1) {
                    return;
                }
                GridPos pos = super.getCell(new Point(event.x, event.y));
                GridPos focusPos = super.getFocusPos();
                if (pos == null || focusPos == null || !pos.equals(super.getFocusPos())) break;
                DoubleClickBehavior doubleClickBehavior = (DoubleClickBehavior)CommonUtils.valueOf(DoubleClickBehavior.class, (String)this.presentation.getPreferenceStore().getString("resultset.behavior.doubleClick"), (Enum)DoubleClickBehavior.NONE);
                switch (doubleClickBehavior) {
                    case NONE: {
                        return;
                    }
                    case EDITOR: {
                        this.presentation.openValueEditor(false);
                        break;
                    }
                    case INLINE_EDITOR: {
                        this.presentation.openValueEditor(true);
                        break;
                    }
                    case COPY_VALUE: {
                        ResultSetCopySettings copySettings = new ResultSetCopySettings();
                        copySettings.setFormat(DBDDisplayFormat.EDIT);
                        ResultSetUtils.copyToClipboard(this.presentation.copySelection(copySettings));
                        break;
                    }
                    case COPY_PASTE_VALUE: {
                        IResultSetValueReflector valueReflector = (IResultSetValueReflector)GeneralUtils.adapt((Object)this.presentation.getController().getContainer(), IResultSetValueReflector.class);
                        if (valueReflector != null) {
                            ResultSetCellLocation currentCellLocation = this.presentation.getCurrentCellLocation();
                            if (currentCellLocation.getAttribute() == null || currentCellLocation.getRow() == null) break;
                            Object cellValue = this.presentation.getController().getModel().getCellValue(currentCellLocation);
                            ResultSetCopySettings copySettings = new ResultSetCopySettings();
                            Map<Transfer, Object> selFormats = this.presentation.copySelection(copySettings);
                            Object textValue = selFormats.get(TextTransfer.getInstance());
                            if (textValue == null) break;
                            valueReflector.insertCurrentCellValue(currentCellLocation.getAttribute(), cellValue, CommonUtils.toString((Object)textValue));
                            break;
                        }
                        this.presentation.openValueEditor(true);
                    }
                }
                break;
            }
            case 3: {
                int cfr_ignored_0 = event.button;
                break;
            }
            case 1000: {
                this.presentation.changeSorting(event.data, event.stateMask);
                break;
            }
            case 1002: {
                this.presentation.showFiltering(event.data);
                break;
            }
            case 1001: {
                UIUtils.asyncExec(() -> this.presentation.navigateLink((GridCell)event.data, event.stateMask));
            }
        }
    }

    @Override
    public void refreshData(boolean refreshColumns, boolean keepState, boolean fitValue) {
        this.cancelInlineEditor();
        super.refreshData(refreshColumns, keepState, fitValue);
        super.redraw();
    }

    @Override
    protected void toggleCellValue(IGridColumn column, IGridRow row) {
        this.presentation.toggleCellValue(column, row);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(null, "org.jkiss.dbeaver.ui.controls.resultset.conext.menu");
        Menu menu = menuMgr.createContextMenu((Control)this);
        menuMgr.addMenuListener(manager -> {
            GridPos focusPos = this.getFocusPos();
            this.presentation.fillContextMenu(manager, this.isHoveringOnRowHeader() ? null : (focusPos.col >= 0 && focusPos.col < this.getColumnCount() ? this.getColumn(focusPos.col) : null), this.isHoveringOnHeader() ? null : (focusPos.row >= 0 && focusPos.row < this.gridRows.length ? this.gridRows[focusPos.row] : null));
        });
        menuMgr.setRemoveAllWhenShown(true);
        super.setMenu(menu);
        if (this.site instanceof IEditorSite) {
            ((IEditorSite)this.site).registerContextMenu("spreadsheet_menu", menuMgr, (ISelectionProvider)this.presentation, false);
        } else {
            this.site.registerContextMenu(menuMgr, (ISelectionProvider)this.presentation);
        }
    }

    public void cancelInlineEditor() {
        Control oldEditor = this.tableEditor.getEditor();
        if (oldEditor != null) {
            if (!oldEditor.isDisposed()) {
                oldEditor.dispose();
                UIUtils.asyncExec(() -> {
                    if (UIUtils.getDisplay().getFocusControl() == null) {
                        this.setFocus();
                    }
                });
            }
            this.tableEditor.setEditor(null);
        }
    }

    @Override
    @NotNull
    public IGridContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    @NotNull
    public IGridLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IGridController getGridController() {
        return this.gridController;
    }

    public void redrawGrid() {
        Rectangle bounds = super.getBounds();
        super.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    public boolean isRowVisible(int rowNum) {
        return rowNum >= super.getTopIndex() && rowNum <= super.getBottomIndex();
    }

    public void showCellEditor(Composite editor) {
        Point editorSize = editor.computeSize(-1, -1);
        int minHeight = editorSize.y;
        int minWidth = editorSize.x;
        if (minWidth > 300) {
            minWidth = 300;
        }
        this.tableEditor.minimumHeight = minHeight;
        this.tableEditor.minimumWidth = minWidth;
        GridPos pos = this.getFocusPos();
        this.tableEditor.setEditor((Control)editor, pos.col, pos.row);
    }

    public void packColumns(boolean fitValue) {
        this.refreshData(true, false, fitValue);
    }

    private void hookAccessibility() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new GridAccessibleListener());
        this.addCursorChangeListener(event -> accessible.selectionChanged());
    }

    public static enum DoubleClickBehavior {
        NONE,
        EDITOR,
        INLINE_EDITOR,
        COPY_VALUE,
        COPY_PASTE_VALUE;

    }

    private static class GridAccessibleListener
    implements AccessibleListener {
        private GridAccessibleListener() {
        }

        public void getName(AccessibleEvent e) {
            e.result = "Results grid";
        }

        public void getHelp(AccessibleEvent e) {
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
        }

        public void getDescription(AccessibleEvent e) {
            e.result = "Results grid";
        }
    }
}

