/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.dnd;

import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef3.dnd.TemplateTransfer;
import org.eclipse.gef3.requests.CreateRequest;
import org.eclipse.gef3.requests.CreationFactory;
import org.eclipse.gef3.requests.SimpleFactory;
import org.eclipse.swt.dnd.Transfer;

public class TemplateTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public TemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TemplateTransfer.getInstance());
    }

    @Override
    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory(TemplateTransfer.getInstance().getTemplate()));
        return request;
    }

    protected final CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof CreationFactory) {
            return (CreationFactory)template;
        }
        if (template instanceof Class) {
            return new SimpleFactory((Class)template);
        }
        return null;
    }

    @Override
    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    @Override
    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    @Override
    protected void handleDrop() {
        super.handleDrop();
        this.selectAddedObject();
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            viewer.select((EditPart)editpart);
        }
    }

    @Override
    protected void updateTargetRequest() {
        CreateRequest request = this.getCreateRequest();
        request.setLocation(this.getDropLocation());
    }
}

