/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.parser.common.ParseTreeNode;
import org.jkiss.dbeaver.parser.common.ParserState;
import org.jkiss.dbeaver.parser.common.grammar.GrammarInfo;
import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;
import org.jkiss.dbeaver.parser.common.grammar.nfa.GrammarNfaOperation;

public class ParseResult {
    private final String text;
    private final GrammarInfo grammar;
    private final ParserState boundary;
    private final List<ParserState> results;
    private final List<ParseTreeNode> trees;

    public ParseResult(String text, GrammarInfo grammar, ParserState boundary, List<ParserState> results) {
        this.text = text;
        this.grammar = grammar;
        this.boundary = boundary;
        this.results = results;
        this.trees = new ArrayList<ParseTreeNode>(results.size());
    }

    public boolean isSuccess() {
        return !this.results.isEmpty();
    }

    public List<ParseTreeNode> getTrees(boolean withWhitespaces) {
        if (this.trees.size() != this.results.size()) {
            this.collectOperations(withWhitespaces);
        }
        return Collections.unmodifiableList(this.trees);
    }

    private void collectOperations(boolean withWhitespaces) {
        for (ParserState result : this.results) {
            ArrayList<ParserState> states = new ArrayList<ParserState>();
            ParserState state = result;
            while (state != null) {
                states.add(state);
                state = state.getPrev();
            }
            Collections.reverse(states);
            ParseTreeNode tree = this.makeParseTree(withWhitespaces, states);
            this.trees.add(tree);
        }
    }

    private ParseTreeNode makeParseTree(boolean withWhitespaces, List<ParserState> states) {
        ParseTreeNode treeRoot;
        GrammarRule skipRule = this.grammar.findRule(this.grammar.getSkipRuleName());
        ParseTreeNode current = treeRoot = new ParseTreeNode(null, 0, this.text.length(), null, new ArrayList<ParseTreeNode>());
        int pos = 0;
        int skipDepth = 0;
        for (ParserState state : states) {
            if (state.getStep() == null || state.getStep().getOperations() == null) continue;
            for (GrammarNfaOperation op : state.getStep().getOperations()) {
                switch (op.getKind()) {
                    case RULE_START: {
                        if (skipDepth == 0) {
                            if (!withWhitespaces && op.getRule() == skipRule) {
                                ++skipDepth;
                                break;
                            }
                            ParseTreeNode newNode = new ParseTreeNode(op.getRule(), pos, -1, current, new ArrayList<ParseTreeNode>());
                            current.getChildren().add(newNode);
                            current = newNode;
                            break;
                        }
                        ++skipDepth;
                        break;
                    }
                    case RULE_END: {
                        if (skipDepth == 0) {
                            int endPos = current.getChildren().size() > 0 ? current.getChildren().get(current.getChildren().size() - 1).getEndPosition() : pos;
                            current.setEndPosition(endPos);
                            current = current.getParent();
                            break;
                        }
                        --skipDepth;
                        break;
                    }
                }
            }
            if (state.getStep().getPattern() != null && skipDepth == 0) {
                current.getChildren().add(new ParseTreeNode(null, pos, state.getPosition(), current, new ArrayList<ParseTreeNode>()));
            }
            pos = state.getPosition();
        }
        return treeRoot;
    }
}

