/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableIndexColumn;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class ExasolTableIndex
extends JDBCTableIndex<ExasolSchema, ExasolTable>
implements DBPNamedObject {
    private long size;
    private Timestamp createTime;
    private Timestamp lastCommit;
    private ExasolTable table;
    private List<ExasolTableIndexColumn> columns;
    private Boolean isGeometry;
    private DBSIndexType type;

    public ExasolTableIndex(ExasolTable table, String indexName, DBSIndexType indexType, boolean persisted) {
        super((DBSObjectContainer)((ExasolSchema)table.getContainer()), (JDBCTable)table, indexName, indexType, persisted);
        this.size = -1L;
        this.type = new DBSIndexType("LOCAL", "LOCAL");
        this.table = table;
        this.isGeometry = false;
    }

    public ExasolTableIndex(DBRProgressMonitor monitor, ExasolTable table, String indexName, ResultSet dbResult) {
        super((DBSObjectContainer)((ExasolSchema)table.getContainer()), (JDBCTable)table, indexName, new DBSIndexType(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TYPE"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"INDEX_TYPE")), true);
        this.size = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MEM_OBJECT_SIZE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastCommit = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_COMMIT");
        this.table = table;
        this.type = super.getIndexType();
        this.isGeometry = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"IS_GEOMETRY", (boolean)false);
    }

    public ExasolSchema getContainer() {
        return (ExasolSchema)this.getTable().getContainer();
    }

    public ExasolTable getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return false;
    }

    public DBSIndexType getIndexType() {
        return DBSIndexType.STATISTIC;
    }

    @Property(viewable=true, editable=false, order=15)
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=17)
    public DBSIndexType getType() {
        return this.type;
    }

    @Property(viewable=true, editable=false, order=20, formatter=ByteNumberFormat.class)
    public long getSize() {
        return this.size;
    }

    @Property(viewable=true, editable=false, order=30)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, editable=false, order=40)
    public Timestamp getLastCommit() {
        return this.lastCommit;
    }

    public List<ExasolTableIndexColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.columns;
    }

    public ExasolDataSource getDataSource() {
        return this.table.getSchema().getDataSource();
    }

    @Property(viewable=false, order=100)
    public String getDescription() {
        return null;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(this.type.getName()) + " " + this.getColumnString();
    }

    public List<ExasolTableIndexColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ExasolTableIndexColumn> columns) {
        this.columns = columns;
    }

    public ExasolTableIndexColumn getColumn(String columnName) {
        return (ExasolTableIndexColumn)DBUtils.findObject(this.columns, (String)columnName);
    }

    public Boolean getIsGeometry() {
        return this.isGeometry;
    }

    public String getSimpleColumnString() {
        String[] colNames = (String[])this.columns.stream().map(c -> c.getName()).toArray(String[]::new);
        return "(" + CommonUtils.joinStrings((String)",", (String[])colNames) + ")";
    }

    public String getColumnString() {
        String[] colNames = (String[])this.columns.stream().map(c -> DBUtils.getQuotedIdentifier((DBSObject)c)).toArray(String[]::new);
        return "(" + CommonUtils.joinStrings((String)",", (String[])colNames) + ")";
    }

    public void addColumn(ExasolTableIndexColumn column) {
        if (this.columns == null) {
            this.columns = new ArrayList<ExasolTableIndexColumn>();
        }
        this.columns.add(column);
    }
}

