/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageGeneral;
import org.jkiss.dbeaver.ui.dialogs.connection.NavigatorSettingsStorage;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;

public class PrefPageConnectionsGeneral
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage,
NavigatorSettingsStorage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.connections";
    private CSmartCombo<DBPConnectionType> connectionTypeCombo;
    private Combo navigatorSettingsCombo;
    private DBPConnectionType defaultConnectionType;
    private DBNBrowseSettings defaultNavigatorSettings;

    public PrefPageConnectionsGeneral() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
        this.defaultNavigatorSettings = DataSourceNavigatorSettings.PRESET_FULL.getSettings();
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group groupDefaults = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_connection_label_default_settings, (int)2, (int)2, (int)0);
        this.connectionTypeCombo = ConnectionPageGeneral.createConnectionTypeCombo((Composite)groupDefaults);
        this.connectionTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionsGeneral.this.defaultConnectionType = (DBPConnectionType)PrefPageConnectionsGeneral.this.connectionTypeCombo.getSelectedItem();
            }
        });
        this.navigatorSettingsCombo = ConnectionPageGeneral.createNavigatorSettingsCombo((Composite)groupDefaults, this, null);
        Group groupObjects = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_eclipse_ui_general_group_general, (int)1, (int)2, (int)0);
        Label descLabel = new Label((Composite)groupObjects, 64);
        descLabel.setText(CoreMessages.pref_page_eclipse_ui_general_connections_group_label);
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.drivers");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.errorHandle");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.meta");
        this.addLinkToSettings((Composite)groupObjects, "org.jkiss.dbeaver.preferences.main.transactions");
        this.performDefaults();
        return composite;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable iAdaptable) {
    }

    private void addLinkToSettings(Composite composite, String pageID) {
        new PreferenceLinkArea(composite, 0, pageID, "<a>''{0}''</a> " + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
    }

    @Override
    public DBNBrowseSettings getNavigatorSettings() {
        return this.defaultNavigatorSettings;
    }

    @Override
    public void setNavigatorSettings(DBNBrowseSettings settings) {
        this.defaultNavigatorSettings = settings;
    }

    protected void performDefaults() {
        this.defaultConnectionType = DBPConnectionType.getDefaultConnectionType();
        this.connectionTypeCombo.select((Object)this.defaultConnectionType);
        this.defaultNavigatorSettings = DataSourceNavigatorSettings.getDefaultSettings();
        ConnectionPageGeneral.updateNavigatorSettingsPreset(this.navigatorSettingsCombo, this.defaultNavigatorSettings);
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.defaultConnectionType != DBPConnectionType.getDefaultConnectionType()) {
            DBPConnectionType.setDefaultConnectionType((DBPConnectionType)this.defaultConnectionType);
        }
        if (!this.defaultNavigatorSettings.equals(DataSourceNavigatorSettings.getDefaultSettings())) {
            DataSourceNavigatorSettings.setDefaultSettings((DBNBrowseSettings)this.defaultNavigatorSettings);
        }
        return super.performOk();
    }
}

