/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ProjectMetadata
implements DBPProject {
    private static final Log log = Log.getLog(ProjectMetadata.class);
    public static final String SETTINGS_STORAGE_FILE = "project-settings.json";
    public static final String METADATA_STORAGE_FILE = "project-metadata.json";
    public static final String PROP_PROJECT_ID = "id";
    private static final String EMPTY_PROJECT_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n<name>${project-name}</name>\n<comment></comment>\n<projects>\n</projects>\n<buildSpec>\n</buildSpec>\n<natures>\n</natures>\n</projectDescription>";
    private static final Gson METADATA_GSON = new GsonBuilder().setLenient().serializeNulls().create();
    private final AbstractJob metadataSyncJob;
    private final DBPWorkspace workspace;
    private final IProject project;
    private final SMSessionContext sessionContext;
    private String projectName;
    private Path projectPath;
    private volatile ProjectFormat format = ProjectFormat.UNKNOWN;
    private volatile DataSourceRegistry dataSourceRegistry;
    private volatile TaskManagerImpl taskManager;
    private volatile Map<String, Object> properties;
    private volatile Map<String, Map<String, Object>> resourceProperties;
    private DBASecureStorage secureStorage;
    private UUID projectID;
    private final Object metadataSync = new Object();
    private boolean inMemory;

    public ProjectMetadata(DBPWorkspace workspace, IProject project, SMSessionContext sessionContext) {
        this.workspace = workspace;
        this.project = project;
        this.metadataSyncJob = new ProjectSyncJob();
        this.sessionContext = sessionContext == null ? workspace.getAuthContext() : sessionContext;
    }

    public ProjectMetadata(DBPWorkspace workspace, String name, Path path, SMSessionContext sessionContext) {
        this(workspace, workspace.getActiveProject() == null ? null : workspace.getActiveProject().getEclipseProject(), sessionContext);
        this.projectName = name;
        this.projectPath = path;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    @NotNull
    public DBPWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean isVirtual() {
        return this.projectName != null;
    }

    @NotNull
    public String getName() {
        return this.projectName != null ? this.projectName : this.project.getName();
    }

    public UUID getProjectID() {
        if (this.projectID == null) {
            String idStr = CommonUtils.toString((Object)this.getProjectProperty(PROP_PROJECT_ID), null);
            if (CommonUtils.isEmpty((String)idStr)) {
                this.projectID = UUID.randomUUID();
                this.setProjectProperty(PROP_PROJECT_ID, this.projectID.toString());
            } else {
                this.projectID = UUID.fromString(idStr);
            }
        }
        return this.projectID;
    }

    @NotNull
    public Path getAbsolutePath() {
        return this.projectPath != null ? this.projectPath : this.project.getLocation().toFile().toPath();
    }

    @NotNull
    public IProject getEclipseProject() {
        return this.project;
    }

    @NotNull
    public Path getMetadataFolder(boolean create) {
        Path metadataFolder = this.getMetadataPath();
        if (create && !Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(metadataFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Error creating metadata folder" + metadataFolder), (Throwable)e);
            }
        }
        return metadataFolder;
    }

    @NotNull
    private Path getMetadataPath() {
        return this.getAbsolutePath().resolve(".dbeaver");
    }

    public boolean isOpen() {
        return this.project == null || this.project.isOpen();
    }

    public void ensureOpen() throws IllegalStateException {
        block7: {
            if (this.format != ProjectFormat.UNKNOWN) {
                return;
            }
            if (this.project != null && !this.project.isOpen()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    this.project.open((IProgressMonitor)monitor);
                    this.project.refreshLocal(1, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    if (!this.workspace.getPlatform().getApplication().isStandalone() || !e.getMessage().contains(".project")) break block7;
                    try {
                        this.recoverProjectDescription();
                        this.project.open((IProgressMonitor)monitor);
                        this.project.refreshLocal(1, (IProgressMonitor)monitor);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Error opening project", (Throwable)e2);
                        return;
                    }
                }
            }
        }
        if (this.inMemory) {
            this.format = ProjectFormat.MODERN;
            return;
        }
        Path mdFolder = this.getMetadataFolder(false);
        Path dsConfig = this.getAbsolutePath().resolve(".dbeaver-data-sources.xml");
        this.format = !Files.exists(mdFolder, new LinkOption[0]) && Files.exists(dsConfig, new LinkOption[0]) ? ProjectFormat.LEGACY : ProjectFormat.MODERN;
        this.checkAndUpdateProjectStructure();
    }

    public void recoverProjectDescription() throws IOException {
        Path mdFile = this.getAbsolutePath().resolve(".project");
        log.debug((Object)("Recovering project '" + this.project.getName() + "' metadata " + mdFile.toAbsolutePath()));
        IOUtils.writeFileFromString((File)mdFile.toFile(), (String)EMPTY_PROJECT_TEMPLATE.replace("${project-name}", this.project.getName()));
    }

    public boolean isRegistryLoaded() {
        return this.dataSourceRegistry != null;
    }

    public boolean isModernProject() {
        return this.getFormat() == ProjectFormat.MODERN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBPDataSourceRegistry getDataSourceRegistry() {
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.dataSourceRegistry == null) {
                this.dataSourceRegistry = new DataSourceRegistry(this.workspace.getPlatform(), this);
            }
        }
        return this.dataSourceRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBTTaskManager getTaskManager() {
        this.ensureOpen();
        if (this.taskManager == null) {
            Object object = this.metadataSync;
            synchronized (object) {
                if (this.taskManager == null) {
                    this.taskManager = new TaskManagerImpl(this);
                }
            }
        }
        return this.taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBASecureStorage getSecureStorage() {
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.secureStorage == null) {
                this.secureStorage = this.workspace.getPlatform().getApplication().getProjectSecureStorage((DBPProject)this);
            }
        }
        return this.secureStorage;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProjectProperty(String propName) {
        ProjectMetadata projectMetadata = this;
        synchronized (projectMetadata) {
            this.loadProperties();
            return this.properties.get(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectProperty(String propName, Object propValue) {
        ProjectMetadata projectMetadata = this;
        synchronized (projectMetadata) {
            this.loadProperties();
            if (propValue == null) {
                this.properties.remove(propName);
            } else {
                this.properties.put(propName, propValue);
            }
            this.saveProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        if (this.properties != null) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            Path settingsFile = this.getMetadataPath().resolve(SETTINGS_STORAGE_FILE);
            if (Files.exists(settingsFile, new LinkOption[0]) && settingsFile.toFile().length() > 0L) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (BufferedReader settingsReader = Files.newBufferedReader(settingsFile, StandardCharsets.UTF_8);){
                        this.properties = JSONUtils.parseMap((Gson)METADATA_GSON, (Reader)settingsReader);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' setting from " + settingsFile.toAbsolutePath()), e);
                }
            }
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
        }
    }

    private void saveProperties() {
        if (this.isInMemory()) {
            return;
        }
        Path settingsFile = this.getMetadataPath().resolve(SETTINGS_STORAGE_FILE);
        String settingsString = METADATA_GSON.toJson(this.properties);
        try {
            Path configFolder = settingsFile.getParent();
            if (!Files.exists(configFolder, new LinkOption[0])) {
                Files.createDirectories(configFolder, new FileAttribute[0]);
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStreamWriter settingsWriter = new OutputStreamWriter(Files.newOutputStream(settingsFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                settingsWriter.write(settingsString);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error writing project '" + this.getName() + "' setting to " + settingsFile.toAbsolutePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourceProperty(IResource resource, String propName) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> resProps = this.resourceProperties.get(resource.getProjectRelativePath().toString());
            if (resProps != null) {
                return resProps.get(propName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getResourceProperties(IResource resource) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            return this.resourceProperties.get(resource.getProjectRelativePath().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> getResourceProperties() {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            return new LinkedHashMap<String, Map<String, Object>>(this.resourceProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setResourceProperty(IResource resource, String propName, Object propValue) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            String filePath = resource.getProjectRelativePath().toString();
            Map<String, Object> resProps = this.resourceProperties.get(filePath);
            if (resProps == null) {
                if (propValue == null) {
                    return;
                }
                resProps = new LinkedHashMap<String, Object>();
                this.resourceProperties.put(filePath, resProps);
            }
            if (propValue == null) {
                if (resProps.remove(propName) == null) {
                    if (!resProps.isEmpty()) {
                        return;
                    }
                    this.resourceProperties.remove(filePath);
                }
            } else {
                Object oldValue = resProps.put(propName, propValue);
                if (Objects.equals(oldValue, propValue)) {
                    return;
                }
            }
        }
        this.flushMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceProperties(IResource resource, Map<String, Object> props) {
        this.loadMetadata();
        Object object = this.metadataSync;
        synchronized (object) {
            String filePath = resource.getProjectRelativePath().toString();
            Map<String, Object> resProps = this.resourceProperties.get(filePath);
            if (resProps == null) {
                if (props.isEmpty()) {
                    return;
                }
                resProps = new LinkedHashMap<String, Object>();
                this.resourceProperties.put(filePath, resProps);
            }
            boolean hasChanges = false;
            for (Map.Entry<String, Object> pe : props.entrySet()) {
                if (pe.getValue() == null) {
                    if (resProps.remove(pe.getKey()) == null) continue;
                    hasChanges = true;
                    continue;
                }
                Object oldValue = resProps.get(pe.getKey());
                if (CommonUtils.equalObjects((Object)oldValue, (Object)pe.getValue())) continue;
                resProps.put(pe.getKey(), pe.getValue());
                hasChanges = true;
            }
            if (!hasChanges) {
                return;
            }
        }
        this.flushMetadata();
    }

    public void dispose() {
        if (this.dataSourceRegistry != null) {
            this.dataSourceRegistry.dispose();
        }
    }

    public ProjectFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetadata() {
        if (this.isInMemory()) {
            return;
        }
        this.ensureOpen();
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                return;
            }
            Path mdFile = this.getMetadataPath().resolve(METADATA_STORAGE_FILE);
            if (Files.exists(mdFile, new LinkOption[0]) && mdFile.toFile().length() > 0L) {
                TreeMap<String, Map<String, Object>> mdCache = new TreeMap<String, Map<String, Object>>();
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (BufferedReader mdReader = Files.newBufferedReader(mdFile, StandardCharsets.UTF_8);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (JsonReader jsonReader = METADATA_GSON.newJsonReader((Reader)mdReader);){
                            jsonReader.beginObject();
                            while (jsonReader.hasNext()) {
                                String topName = jsonReader.nextName();
                                if (!"resources".equals(topName)) continue;
                                jsonReader.beginObject();
                                while (jsonReader.hasNext()) {
                                    String resourceName = jsonReader.nextName();
                                    HashMap<String, Object> resProperties = new HashMap<String, Object>();
                                    jsonReader.beginObject();
                                    while (jsonReader.hasNext()) {
                                        Object propValue;
                                        String propName = jsonReader.nextName();
                                        switch (jsonReader.peek()) {
                                            case NUMBER: {
                                                propValue = jsonReader.nextDouble();
                                                break;
                                            }
                                            case BOOLEAN: {
                                                propValue = jsonReader.nextBoolean();
                                                break;
                                            }
                                            case NULL: {
                                                propValue = null;
                                                break;
                                            }
                                            default: {
                                                propValue = jsonReader.nextString();
                                            }
                                        }
                                        resProperties.put(propName, propValue);
                                    }
                                    jsonReader.endObject();
                                    if (resProperties.isEmpty()) continue;
                                    mdCache.put(resourceName, resProperties);
                                }
                                jsonReader.endObject();
                            }
                            jsonReader.endObject();
                            this.resourceProperties = mdCache;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error reading project '" + this.getName() + "' metadata from " + mdFile.toAbsolutePath()), e);
                }
            }
            if (this.resourceProperties == null) {
                this.resourceProperties = new TreeMap<String, Map<String, Object>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateProjectStructure() {
        if (this.format == ProjectFormat.UNKNOWN || this.format == ProjectFormat.MODERN) {
            return;
        }
        Path mdConfig = this.getMetadataPath().resolve(METADATA_STORAGE_FILE);
        if (!Files.exists(mdConfig, new LinkOption[0])) {
            log.debug((Object)("Migrate Eclipse resource properties to the project metadata (" + mdConfig.toAbsolutePath() + ")"));
            Map<String, Map<String, Object>> projectResourceProperties = this.extractProjectResourceProperties();
            Object object = this.metadataSync;
            synchronized (object) {
                this.resourceProperties = projectResourceProperties;
            }
            this.flushMetadata();
        }
        this.format = ProjectFormat.MODERN;
    }

    private Map<String, Map<String, Object>> extractProjectResourceProperties() {
        final LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        if (!(this.workspace instanceof DBPWorkspaceEclipse)) {
            return result;
        }
        DBPWorkspaceEclipse workspaceEclipse = (DBPWorkspaceEclipse)this.workspace;
        try {
            BucketTree bucketTree = new BucketTree((Workspace)workspaceEclipse.getEclipseWorkspace(), (Bucket)new PropertyBucket());
            try {
                final IPath projectPath = this.project.getFullPath();
                bucketTree.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry entry) {
                        Object value = entry.getValue();
                        if (value instanceof String[][]) {
                            String[][] bucketProps;
                            String[][] stringArray = bucketProps = (String[][])value;
                            int n = bucketProps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] resProps = stringArray[n2];
                                if (resProps.length == 3 && "org.jkiss.dbeaver".equals(resProps[0]) && !"sql-editor-project-id".equals(resProps[1])) {
                                    Map propsMap = result.computeIfAbsent(entry.getPath().makeRelativeTo(projectPath).toString(), s -> new LinkedHashMap());
                                    propsMap.put(resProps[1], resProps[2]);
                                }
                                ++n2;
                            }
                        }
                        return 0;
                    }
                }, projectPath, Integer.MAX_VALUE);
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error extracting project metadata", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushMetadata() {
        if (this.inMemory) {
            return;
        }
        Object object = this.metadataSync;
        synchronized (object) {
            this.metadataSyncJob.schedule(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResourceFromCache(IPath path) {
        boolean cacheChanged = false;
        Object object = this.metadataSync;
        synchronized (object) {
            if (this.resourceProperties != null) {
                cacheChanged = this.resourceProperties.remove(path.toString()) != null;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateResourceCache(IPath oldPath, IPath newPath) {
        boolean cacheChanged = false;
        Object object = this.metadataSync;
        synchronized (object) {
            Map<String, Object> props;
            if (this.resourceProperties != null && (props = this.resourceProperties.remove(oldPath.toString())) != null) {
                this.resourceProperties.put(newPath.toString(), props);
                cacheChanged = true;
            }
        }
        if (cacheChanged) {
            this.flushMetadata();
        }
    }

    public String toString() {
        return this.getName();
    }

    public static enum ProjectFormat {
        UNKNOWN,
        LEGACY,
        MODERN;

    }

    private class ProjectSyncJob
    extends AbstractJob {
        ProjectSyncJob() {
            super("Project metadata sync");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            this.setName("Project '" + ProjectMetadata.this.getName() + "' sync job");
            ContentUtils.makeFileBackup((Path)ProjectMetadata.this.getMetadataFolder(false).resolve(ProjectMetadata.METADATA_STORAGE_FILE));
            Object object = ProjectMetadata.this.metadataSync;
            synchronized (object) {
                block29: {
                    Path mdFile = ProjectMetadata.this.getMetadataPath().resolve(ProjectMetadata.METADATA_STORAGE_FILE);
                    if (CommonUtils.isEmpty(ProjectMetadata.this.resourceProperties) && !Files.exists(mdFile, new LinkOption[0])) {
                        return Status.OK_STATUS;
                    }
                    try {
                        if (CommonUtils.isEmpty(ProjectMetadata.this.resourceProperties)) break block29;
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (BufferedWriter mdWriter = Files.newBufferedWriter(mdFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                            Throwable throwable2 = null;
                            Object var8_12 = null;
                            try (JsonWriter jsonWriter = METADATA_GSON.newJsonWriter((Writer)mdWriter);){
                                jsonWriter.beginObject();
                                jsonWriter.name("resources");
                                jsonWriter.beginObject();
                                for (Map.Entry<String, Map<String, Object>> resEntry : ProjectMetadata.this.resourceProperties.entrySet()) {
                                    jsonWriter.name(resEntry.getKey());
                                    jsonWriter.beginObject();
                                    Map<String, Object> resProps = resEntry.getValue();
                                    for (Map.Entry<String, Object> propEntry : resProps.entrySet()) {
                                        jsonWriter.name(propEntry.getKey());
                                        Object value = propEntry.getValue();
                                        if (value == null) {
                                            jsonWriter.nullValue();
                                            continue;
                                        }
                                        if (value instanceof Number) {
                                            jsonWriter.value((Number)value);
                                            continue;
                                        }
                                        if (value instanceof Boolean) {
                                            jsonWriter.value((Boolean)value);
                                            continue;
                                        }
                                        jsonWriter.value(CommonUtils.toString((Object)value));
                                    }
                                    jsonWriter.endObject();
                                }
                                jsonWriter.endObject();
                                jsonWriter.endObject();
                                jsonWriter.flush();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)"Error flushing project metadata", (Throwable)e);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

