/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.EclipsePluginApplicationImpl;
import org.jkiss.dbeaver.registry.ProjectSecureStorage;
import org.jkiss.utils.CommonUtils;

public abstract class BaseApplicationImpl
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(BaseApplicationImpl.class);
    private static DBPApplication INSTANCE;

    protected BaseApplicationImpl() {
        if (INSTANCE != null && !(INSTANCE instanceof EclipsePluginApplicationImpl)) {
            log.error((Object)("Multiple application instances created: " + INSTANCE.getClass().getName() + ", " + this.getClass().getName()));
        }
        INSTANCE = this;
    }

    public static DBPApplication getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EclipsePluginApplicationImpl();
        }
        return INSTANCE;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return true;
    }

    public boolean isHeadlessMode() {
        return false;
    }

    public boolean isExclusiveMode() {
        return false;
    }

    public boolean isMultiuser() {
        return false;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    @NotNull
    public DBASecureStorage getProjectSecureStorage(DBPProject project) {
        return new ProjectSecureStorage(project);
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        return "N/A";
    }

    public long getLastUserActivityTime() {
        return -1L;
    }

    public String getProductProperty(String propName) {
        return Platform.getProduct().getProperty(propName);
    }

    public boolean hasProductFeature(String featureName) {
        return CommonUtils.toBoolean((Object)Platform.getProduct().getProperty("feature." + featureName));
    }

    public Object start(IApplicationContext context) throws Exception {
        return EXIT_OK;
    }

    public void stop() {
    }
}

