/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public interface DBSStructureAssistant<CONTEXT extends DBCExecutionContext> {
    public DBSObjectType[] getSupportedObjectTypes();

    public DBSObjectType[] getSearchObjectTypes();

    public DBSObjectType[] getHyperlinkObjectTypes();

    public DBSObjectType[] getAutoCompleteObjectTypes();

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor var1, @NotNull CONTEXT var2, @NotNull ObjectsSearchParams var3) throws DBException;

    default public boolean supportsSearchInCommentsFor(@NotNull DBSObjectType objectType) {
        return false;
    }

    default public boolean supportsSearchInDefinitionsFor(@NotNull DBSObjectType objectType) {
        return false;
    }

    public static class ObjectsSearchParams {
        @NotNull
        private final DBSObjectType[] objectTypes;
        @NotNull
        private String mask;
        @Nullable
        private DBSObject parentObject;
        private int maxResults = Integer.MAX_VALUE;
        private boolean caseSensitive;
        private boolean searchInComments;
        private boolean searchInDefinitions;
        private boolean globalSearch;
        private boolean isLikeCondition;

        public ObjectsSearchParams(@NotNull DBSObjectType[] objectTypes, @NotNull String mask) {
            this.objectTypes = objectTypes;
            this.mask = mask;
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.parentObject;
        }

        public void setParentObject(@Nullable DBSObject parentObject) {
            this.parentObject = parentObject;
        }

        @NotNull
        public DBSObjectType[] getObjectTypes() {
            return this.objectTypes;
        }

        @NotNull
        public String getMask() {
            return this.mask;
        }

        public void setMask(@NotNull String mask) {
            this.mask = mask;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public int getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(int maxResults) {
            this.maxResults = maxResults;
        }

        public boolean isSearchInComments() {
            return this.searchInComments;
        }

        public void setSearchInComments(boolean searchInComments) {
            this.searchInComments = searchInComments;
        }

        public boolean isSearchInDefinitions() {
            return this.searchInDefinitions;
        }

        public void setSearchInDefinitions(boolean searchInDefinitions) {
            this.searchInDefinitions = searchInDefinitions;
        }

        public boolean isGlobalSearch() {
            return this.globalSearch;
        }

        public void setGlobalSearch(boolean globalSearch) {
            this.globalSearch = globalSearch;
        }

        public boolean isLikeCondition() {
            return this.isLikeCondition;
        }

        public void setLikeCondition(boolean likeCondition) {
            this.isLikeCondition = likeCondition;
        }
    }
}

