/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleDecorator;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.utils.CommonUtils;

public class CustomCheckboxCellEditor
extends CellEditor
implements BooleanStyleDecorator {
    private static final boolean CHANGE_ON_ACTIVATE = false;
    private Label checkBox;
    private boolean initialValue;
    private boolean checked;
    private BooleanStyleSet booleanStyles;
    private UIElementAlignment alignment;

    public CustomCheckboxCellEditor(Composite parent) {
        super(parent);
        IPropertyChangeListener styleChangeListener = event -> {
            this.booleanStyles = BooleanStyleSet.getDefaultStyles(DBWorkbench.getPlatform().getPreferenceStore());
        };
        BooleanStyleSet.installStyleChangeListener((Control)parent, styleChangeListener);
        styleChangeListener.propertyChange(null);
    }

    protected Control createControl(Composite parent) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        ph.setLayout((Layout)gl);
        ph.setBackground(parent.getBackground());
        this.checkBox = new Label(ph, 0);
        this.checkBox.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.checkBox.setBackground(ph.getBackground());
        ph.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomCheckboxCellEditor.this.focusLost();
            }
        });
        ph.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case ' ': {
                        CustomCheckboxCellEditor.this.checked = !CustomCheckboxCellEditor.this.checked;
                        CustomCheckboxCellEditor.this.updateCheckVisuals();
                        CustomCheckboxCellEditor.this.applyEditorValue();
                        break;
                    }
                    case '\u001b': {
                        CustomCheckboxCellEditor.this.checked = CustomCheckboxCellEditor.this.initialValue;
                    }
                    case '\r': {
                        CustomCheckboxCellEditor.this.applyEditorValue();
                        CustomCheckboxCellEditor.this.fireApplyEditorValue();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CustomCheckboxCellEditor.this.checked = !CustomCheckboxCellEditor.this.checked;
                CustomCheckboxCellEditor.this.updateCheckVisuals();
                CustomCheckboxCellEditor.this.applyEditorValue();
            }
        });
        return ph;
    }

    private void updateCheckVisuals() {
        BooleanStyle style = this.booleanStyles.getStyle(this.checked);
        if (style.getMode() == BooleanMode.TEXT) {
            this.checkBox.setText(style.getText());
            this.checkBox.setForeground(UIUtils.getSharedColor(style.getColor()));
        } else {
            this.checkBox.setImage(DBeaverIcons.getImage((DBPImage)style.getIcon()));
        }
        UIElementAlignment alignment = this.alignment == null ? style.getAlignment() : this.alignment;
        ((GridData)this.checkBox.getLayoutData()).horizontalAlignment = alignment.getStyle();
        ((GridData)this.checkBox.getLayoutData()).horizontalIndent = alignment == UIElementAlignment.LEFT ? 3 : 0;
        this.checkBox.getParent().layout(true, true);
    }

    protected Boolean doGetValue() {
        return this.checked;
    }

    protected void doSetFocus() {
        this.checkBox.getParent().setFocus();
    }

    protected void doSetValue(Object value) {
        boolean val;
        Assert.isTrue((this.checkBox != null && value instanceof Boolean ? 1 : 0) != 0);
        this.checked = val = CommonUtils.toBoolean((Object)value);
        this.initialValue = val;
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.grabHorizontal = true;
        layoutData.horizontalAlignment = 0x1000000;
        return layoutData;
    }

    private void applyEditorValue() {
        Boolean newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.updateCheckVisuals();
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }

    public void activate() {
        this.updateCheckVisuals();
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
    }

    @Override
    public void setBooleanAlignment(@NotNull UIElementAlignment alignment) {
        this.alignment = alignment;
    }
}

