/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgreExecutionPlan;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeBase;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNodeExternal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;

public class PostgreQueryPlaner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    public static final String PARAM_ANALYSE = "use.analyze";
    private final PostgreDataSource dataSource;
    public static final String FORMAT_VERSION = "1";

    public PostgreQueryPlaner(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public PostgreDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        PostgreExecutionPlan plan = new PostgreExecutionPlan(!this.dataSource.getServerType().supportsExplainPlanXML(), this.dataSource.getServerType().supportsExplainPlanVerbose(), query, configuration);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return this.dataSource.getServerType().supportsExplainPlan() ? DBCPlanStyle.PLAN : DBCPlanStyle.QUERY;
    }

    public void serialize(@NotNull Writer writer, @NotNull DBCPlan plan) throws IOException {
        this.serializeJson(writer, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return PostgreQueryPlaner.FORMAT_VERSION;
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonArray attributes = new JsonArray();
                if (node instanceof PostgrePlanNodeBase) {
                    PostgrePlanNodeBase pgNode = (PostgrePlanNodeBase)node;
                    for (Map.Entry<String, String> e : pgNode.attributes.entrySet()) {
                        JsonObject attr = new JsonObject();
                        attr.add(e.getKey(), (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)e.getValue())));
                        attributes.add((JsonElement)attr);
                    }
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws IOException, InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            String query = this.getQuery(jo);
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            List planNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> new PostgrePlanNodeExternal((PostgreDataSource)datasource, node, (PostgrePlanNodeExternal)parent));
            return new PostgreExecutionPlan(query, planNodes);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

