/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.edit.OracleTableColumnManager;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleView;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.prop.DBECommandComposite;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OracleViewManager
extends SQLTableManager<OracleView, OracleSchema> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{OracleTableConstraint.class, OracleTableForeignKey.class};

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((OracleView)command.getObject()).getName())) {
            throw new DBException("View name cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleView> getObjectsCache(OracleView object) {
        return object.getSchema().tableCache;
    }

    protected String getBaseObjectName() {
        return "NewView";
    }

    protected OracleView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        OracleSchema schema = (OracleSchema)container;
        OracleView newView = new OracleView(schema, "NEW_VIEW");
        this.setNewObjectName(monitor, schema, newView);
        newView.setViewText("CREATE OR REPLACE VIEW " + newView.getFullyQualifiedName(DBPEvaluationContext.DDL) + " AS\nSELECT 1 AS A FROM DUAL");
        return newView;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actions, (DBECommandComposite<OracleView, SQLObjectEditor.PropertyHandler>)command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceViewQuery(monitor, actionList, (DBECommandComposite<OracleView, SQLObjectEditor.PropertyHandler>)command, options);
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + ((OracleView)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    /*
     * Unable to fully structure code
     */
    private void createOrReplaceViewQuery(DBRProgressMonitor monitor, @NotNull List<DBEPersistAction> actions, DBECommandComposite<OracleView, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        block5: {
            view = (OracleView)command.getObject();
            hasComment = command.hasProperty((Object)"comment");
            if (hasComment && command.getProperties().size() <= 1) break block5;
            viewText = view.getViewText().trim();
            sqlScriptElements = SQLScriptParser.parseScript((DBPDataSource)view.getDataSource(), (String)viewText);
            if (sqlScriptElements.size() <= 1) ** GOTO lbl13
            for (SQLScriptElement scriptElement : sqlScriptElements) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view part", scriptElement.getText()));
            }
            return;
lbl-1000:
            // 1 sources

            {
                viewText = viewText.substring(0, viewText.length() - 1);
lbl13:
                // 2 sources

                ** while (viewText.endsWith((String)";"))
            }
lbl14:
            // 1 sources

            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", viewText));
        }
        if (hasComment || CommonUtils.getOption(options, (String)"object.save") && CommonUtils.isNotEmpty((String)view.getComment())) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + view.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS '" + CommonUtils.notEmpty((String)view.getComment()) + "'"));
        }
        if ((!hasComment || command.getProperties().size() != 1) && CommonUtils.getOption(options, (String)"object.save")) {
            for (OracleTableColumn column : CommonUtils.safeCollection(view.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getComment(monitor))) continue;
                OracleTableColumnManager.addColumnCommentAction(actions, (DBSEntityAttribute)column, (DBSEntity)view);
            }
        }
    }
}

