/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.imageio.ImageIO;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXML
extends StreamExporterAbstract {
    private DBDAttributeBinding[] columns;
    private String tableName;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        out.write("<?xml version=\"1.0\" encoding=\"" + this.getSite().getOutputEncoding() + "\"?>\n");
        this.tableName = this.escapeXmlElementName(this.getSite().getSource().getName());
        out.write("<!DOCTYPE " + this.tableName + " [\n");
        out.write("  <!ELEMENT " + this.tableName + " (DATA_RECORD*)>\n");
        out.write("  <!ELEMENT DATA_RECORD (");
        int columnsSize = this.columns.length;
        int i = 0;
        while (i < columnsSize) {
            String colName = this.columns[i].getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = this.columns[i].getName();
            }
            out.write(String.valueOf(this.escapeXmlElementName(colName)) + "?");
            if (i < columnsSize - 1) {
                out.write(",");
            }
            ++i;
        }
        out.write(")+>\n");
        i = 0;
        while (i < columnsSize) {
            out.write("  <!ELEMENT " + this.escapeXmlElementName(this.columns[i].getName()) + " (#PCDATA)>\n");
            ++i;
        }
        out.write("]>\n");
        out.write("<" + this.tableName + ">\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        out = this.getWriter();
        out.write("  <DATA_RECORD>\n");
        i = 0;
        while (i < row.length) {
            column = this.columns[i];
            columnName = this.escapeXmlElementName(column.getName());
            out.write("    <" + columnName + ">");
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null);
            } else if (row[i] instanceof DBDContent) {
                content = (DBDContent)row[i];
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl41
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        var10_10 = null;
                        var11_12 = null;
                        try {
                            reader = cs.getContentReader();
                            try {
                                this.writeCellValue(reader);
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        catch (Throwable var11_13) {
                            if (var10_10 == null) {
                                var10_10 = var11_13;
                            } else if (var10_10 != var11_13) {
                                var10_10.addSuppressed(var11_13);
                            }
                            throw var10_10;
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    content.release();
                }
            } else {
                this.writeTextCell(super.getValueDisplayString(column, row[i]));
            }
lbl41:
            // 5 sources

            out.write("</" + columnName + ">\n");
            ++i;
        }
        out.write("  </DATA_RECORD>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        this.getWriter().write("</" + this.tableName + ">\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            value = value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            this.getWriter().write(value);
        }
    }

    private void writeImageCell(File file) throws DBException {
        if (file != null && file.exists()) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new DBException("Can't read an exported image " + image, (Throwable)e);
            }
            if (image != null) {
                String imagePath = file.getAbsolutePath();
                imagePath = "files/" + imagePath.substring(imagePath.lastIndexOf(File.separator));
                this.getWriter().write(imagePath);
            }
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            int i = 0;
            while (i < count) {
                if (buffer[i] == '<') {
                    this.getWriter().write("&lt;");
                } else if (buffer[i] == '>') {
                    this.getWriter().write("&gt;");
                } else if (buffer[i] == '&') {
                    this.getWriter().write("&amp;");
                } else {
                    this.getWriter().write(buffer[i]);
                }
                ++i;
            }
        }
    }

    private String escapeXmlElementName(String name) {
        return name.replaceAll("[^\\p{Alpha}\\p{Digit}]+", "_");
    }
}

