/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.utils.CommonUtils;

public class DTUtils {
    public static void addSummary(StringBuilder summary, String option, Object value) {
        summary.append("\t").append(option).append(": ").append(value).append("\n");
    }

    public static void addSummary(StringBuilder summary, String option, boolean value) {
        summary.append("\t").append(option).append(": ").append(value ? "Yes" : "No").append("\n");
    }

    public static void addSummary(StringBuilder summary, DataTransferProcessorDescriptor processor, Map<?, ?> props) {
        summary.append(NLS.bind((String)DTMessages.data_transfer_summary_title, (Object)processor.getName())).append(":\n");
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = processor.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            Object propValue = props.get(prop.getId());
            if (propValue == null) {
                propValue = prop.getDefaultValue();
            }
            if (propValue != null) {
                DTUtils.addSummary(summary, prop.getDisplayName(), propValue);
            }
            ++n2;
        }
    }

    public static String getTableName(DBPDataSource dataSource, DBPNamedObject source, boolean shortName) {
        DBSDataContainer dataContainer;
        SQLQueryContainer queryContainer;
        if (source instanceof DBSEntity) {
            return shortName ? DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)source)) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        String tableName = null;
        if (source instanceof SQLQueryContainer) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, (SQLQueryContainer)source, shortName);
        } else if (source instanceof IAdaptable && (queryContainer = (SQLQueryContainer)((IAdaptable)source).getAdapter(SQLQueryContainer.class)) != null) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, queryContainer, shortName);
        }
        if (tableName == null && source instanceof IAdaptable && (dataContainer = (DBSDataContainer)((IAdaptable)source).getAdapter(DBSDataContainer.class)) instanceof DBSEntity) {
            String string = tableName = shortName ? DBUtils.getQuotedIdentifier((DBSObject)dataContainer) : DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (tableName == null) {
            return shortName ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)source.getName()) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return tableName;
    }

    public static String getTableNameFromQuery(DBPDataSource dataSource, SQLQueryContainer queryContainer, boolean shortName) {
        DBCEntityMetaData singleSource;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && (singleSource = ((SQLQuery)query).getEntityMetadata(true)) != null) {
            SQLDialect dialect = dataSource.getSQLDialect();
            String entity = DTUtils.transformName(dialect, singleSource.getEntityName());
            if (shortName) {
                return entity;
            }
            String schema = DTUtils.transformName(dialect, singleSource.getSchemaName());
            String catalog = DTUtils.transformName(dialect, singleSource.getCatalogName());
            String structSeparator = String.valueOf(dialect.getStructSeparator());
            StringBuilder nameBuilder = new StringBuilder();
            if (catalog != null) {
                nameBuilder.append(catalog).append(structSeparator);
            }
            if (schema != null) {
                nameBuilder.append(schema).append(structSeparator);
            }
            nameBuilder.append(entity);
            return nameBuilder.toString();
        }
        return null;
    }

    @Nullable
    private static String transformName(@NotNull SQLDialect dialect, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (dialect.isQuotedIdentifier(name)) {
            return name;
        }
        DBPIdentifierCase identifierCase = dialect.storesUnquotedCase();
        return identifierCase.transform(name);
    }

    @NotNull
    public static List<DBSAttributeBase> getSourceAndTargetAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity target, @NotNull DBSDataContainer container, @NotNull Object controller) throws DBException {
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        for (DBSEntityAttribute attr2 : CommonUtils.safeList((List)target.getAttributes(monitor))) {
            if (DBUtils.isHiddenObject((Object)attr2)) continue;
            attributes.add((DBSAttributeBase)attr2);
        }
        List<DBSAttributeBase> sourceAttributes = DTUtils.getAttributes(monitor, container, controller);
        for (DBSAttributeBase attribute : sourceAttributes) {
            boolean match = attributes.stream().anyMatch(attr -> attr.getName().equalsIgnoreCase(attribute.getName()));
            if (match) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @NotNull
    public static List<DBSAttributeBase> getAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, @NotNull Object controller) throws DBException {
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        if (container instanceof DBSEntity && !(container instanceof DBSDocumentContainer)) {
            for (DBSEntityAttribute attr : CommonUtils.safeList((List)((DBSEntity)container).getAttributes(monitor))) {
                if (DBUtils.isHiddenObject((Object)attr)) continue;
                attributes.add((DBSAttributeBase)attr);
            }
        } else {
            DBCExecutionContext context;
            DBCExecutionContext dBCExecutionContext = context = container instanceof DBPContextProvider ? ((DBPContextProvider)container).getExecutionContext() : DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
            if (context == null) {
                throw new DBCException("No execution context");
            }
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)context.getDataSource(), monitor1 -> {
                MetadataReceiver receiver = new MetadataReceiver(container);
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (DBCSession session = context.openSession(monitor1, DBCExecutionPurpose.META, "Read query meta data");){
                        container.readData((DBCExecutionSource)new AbstractExecutionSource(container, session.getExecutionContext(), controller), session, (DBDDataReceiver)receiver, null, 0L, 1L, 0L, 1);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                if (receiver.attributes == null) {
                    throw new InvocationTargetException((Throwable)new DBCException("Query does not contain any attributes"));
                }
                DBDAttributeBinding[] dBDAttributeBindingArray = receiver.attributes;
                int n = receiver.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                    if (!DBUtils.isHiddenObject((Object)attr)) {
                        attributes.add((DBSAttributeBase)attr);
                    }
                    ++n2;
                }
            });
        }
        return attributes;
    }

    private static class MetadataReceiver
    implements DBDDataReceiver {
        private final DBSDataContainer container;
        private DBDAttributeBinding[] attributes;

        public MetadataReceiver(DBSDataContainer container) {
            this.container = container;
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.attributes = DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)this.container, (DBCResultSet)resultSet);
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void close() {
        }
    }
}

