/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.sql.JDBCType;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.data.formatters.TimestampFormatSample;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;

public class CustomTimeEditor {
    private static final String FORMAT_PATTERN = "pattern";
    private DateTime dateEditor;
    private DateTime timeEditor;
    private final Composite basePart;
    private static final String TIMESTAMP_DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String format = "";
    private Label timeLabel;
    private Label dateLabel;
    private int millis = -1;
    private final boolean isInline;
    private InputMode inputMode = InputMode.None;
    private final Calendar calendar = Calendar.getInstance();
    private Text textEditor;

    public void createDateFormat(@NotNull DBSTypedObject valueType) {
        JDBCType jdbcType = JDBCType.valueOf(valueType.getTypeID());
        switch (jdbcType) {
            case DATE: {
                this.inputMode = InputMode.Date;
                this.timeEditor.dispose();
                if (this.timeLabel == null) break;
                this.timeLabel.dispose();
                break;
            }
            case TIME: {
                this.inputMode = InputMode.Time;
                this.dateEditor.dispose();
                if (this.dateLabel == null) break;
                this.dateLabel.dispose();
                break;
            }
            default: {
                this.inputMode = InputMode.DateTime;
            }
        }
    }

    public CustomTimeEditor(@NotNull Composite parent, int style, boolean isPanel, boolean isInline) {
        this.basePart = this.getComposite(parent, style, isPanel, isInline);
        this.isInline = isInline;
    }

    @NotNull
    private Composite getComposite(@NotNull Composite parent, int style, boolean isPanel, boolean isInline) {
        Composite basePart = new Composite(parent, style);
        GridLayout layout = new GridLayout(2, false);
        if (isInline) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        basePart.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 131072, true, false, 1, 1);
        if (!isInline) {
            this.dateLabel = UIUtils.createLabel(basePart, "Date");
        }
        this.dateEditor = new DateTime(basePart, 4);
        this.dateEditor.setLayoutData((Object)layoutData);
        if (!isInline) {
            this.timeLabel = UIUtils.createLabel(basePart, "Time");
        }
        this.timeEditor = new DateTime(basePart, 65664);
        this.timeEditor.setLayoutData((Object)layoutData);
        this.textEditor = new Text(basePart, isPanel && !isInline ? style : style | 0x800);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.textEditor.setLayoutData((Object)gridData);
        this.textEditor.setVisible(false);
        gridData.exclude = true;
        basePart.pack();
        basePart.layout();
        this.format = this.getTimestampFormat();
        return basePart;
    }

    public void setToTextComposite() {
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.textEditor.setLayoutData((Object)gridData);
        this.textEditor.setVisible(true);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.basePart.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 128, true, false, 1, 1);
        if (!this.timeEditor.isDisposed()) {
            this.timeEditor.setLayoutData((Object)layoutData);
            this.timeEditor.setVisible(layoutData.exclude);
            if (this.timeLabel != null) {
                this.timeLabel.setLayoutData((Object)layoutData);
                this.timeLabel.setVisible(layoutData.exclude);
            }
        }
        if (!this.dateEditor.isDisposed()) {
            this.dateEditor.setLayoutData((Object)layoutData);
            this.dateEditor.setVisible(layoutData.exclude);
            if (this.dateLabel != null) {
                this.dateLabel.setLayoutData((Object)layoutData);
                this.dateLabel.setVisible(layoutData.exclude);
            }
        }
        layoutData.exclude = true;
        this.basePart.layout();
    }

    public void setToDateComposite() {
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        this.textEditor.setLayoutData((Object)gridData);
        this.textEditor.setVisible(false);
        gridData.exclude = true;
        GridLayout layout = new GridLayout(2, false);
        if (this.isInline) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.basePart.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 131072, true, false, 1, 1);
        GridData layoutDataForLabels = new GridData(4, 0x1000000, false, false, 1, 1);
        if (!this.dateEditor.isDisposed()) {
            this.dateEditor.setLayoutData((Object)layoutData);
            this.dateEditor.setVisible(true);
            this.dateLabel.setLayoutData((Object)layoutDataForLabels);
            this.dateLabel.setVisible(true);
        }
        if (!this.timeEditor.isDisposed()) {
            this.timeEditor.setLayoutData((Object)layoutData);
            this.timeEditor.setVisible(true);
            this.timeLabel.setLayoutData((Object)layoutDataForLabels);
            this.timeLabel.setVisible(true);
        }
        this.basePart.layout();
    }

    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    public void addSelectionAdapter(@NotNull SelectionAdapter listener) {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.addSelectionListener((SelectionListener)listener);
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.addSelectionListener((SelectionListener)listener);
        }
    }

    public void addModifyListener(@NotNull ModifyListener listener) {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.addModifyListener(listener);
        }
    }

    private String getTimestampFormat() {
        TimestampFormatSample prefFormat = new TimestampFormatSample();
        Map map = prefFormat.getDefaultProperties(Locale.getDefault());
        Object pattern = map.get(FORMAT_PATTERN);
        if (pattern instanceof String) {
            this.format = (String)pattern;
            return this.format;
        }
        return TIMESTAMP_DEFAULT_FORMAT;
    }

    public void setTextValue(@Nullable String value) {
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.setText(value != null ? value : "");
        }
    }

    public void setValue(@Nullable Date value) {
        if (value != null) {
            this.calendar.setTime(value);
        }
        if (!this.dateEditor.isDisposed()) {
            this.dateEditor.setDate(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
        }
        if (!this.timeEditor.isDisposed()) {
            this.timeEditor.addTraverseListener(e -> {
                boolean bl = this.timeEditor.setFocus();
            });
            this.timeEditor.setTime(this.calendar.get(11), this.calendar.get(12), this.calendar.get(13));
            try {
                this.millis = this.calendar.get(14);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.millis = -1;
            }
        }
    }

    @Nullable
    public String getValueAsString() {
        if (this.textEditor != null && !this.textEditor.isDisposed() && this.textEditor.isVisible()) {
            return this.textEditor.getText();
        }
        return null;
    }

    @Nullable
    public Date getValueAsDate() {
        switch (this.inputMode) {
            case Time: {
                this.calendar.set(0, 0, 0, this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            case Date: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay());
                break;
            }
            case DateTime: {
                this.calendar.set(this.dateEditor.getYear(), this.dateEditor.getMonth(), this.dateEditor.getDay(), this.timeEditor.getHours(), this.timeEditor.getMinutes(), this.timeEditor.getSeconds());
                break;
            }
            default: {
                this.calendar.set(0, 0, 0, 0, 0, 0);
            }
        }
        if (this.millis != -1) {
            this.calendar.set(14, this.millis);
        }
        return this.calendar.getTime();
    }

    public void setEditable(boolean editable) {
        if (this.dateEditor != null && !this.dateEditor.isDisposed()) {
            this.dateEditor.setEnabled(editable);
        }
        if (this.timeEditor != null && !this.timeEditor.isDisposed()) {
            this.timeEditor.setEnabled(editable);
        }
        if (this.textEditor != null && !this.textEditor.isDisposed()) {
            this.textEditor.setEditable(editable);
        }
    }

    public Composite getControl() {
        return this.basePart;
    }

    private static enum InputMode {
        None,
        Date,
        Time,
        DateTime;

    }
}

