/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDLabelValuePairExt;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSDocumentAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.utils.CommonUtils;

class GenericFilterValueEdit {
    private static final Log log = Log.getLog(GenericFilterValueEdit.class);
    private TableViewer tableViewer;
    private String filterPattern;
    private IValueEditor editor;
    @NotNull
    private final ResultSetViewer viewer;
    @NotNull
    private final DBDAttributeBinding attribute;
    @NotNull
    private final ResultSetRow[] rows;
    @NotNull
    private final DBCLogicalOperator operator;
    private boolean isCheckedTable;
    private static final int INPUT_DELAY_BEFORE_LOAD = 300;
    private static final int MAX_MULTI_VALUES = 1000;
    private static final String MULTI_KEY_LABEL = "...";
    private Composite buttonsPanel;
    private Button toggleButton;
    private final transient Set<Object> savedValues = new HashSet<Object>();
    private boolean queryDatabase = true;
    private boolean showRowCount;
    private boolean showDistinctValuesCount;
    private boolean caseInsensitiveSearch;
    private volatile transient KeyLoadJob loadJob;

    GenericFilterValueEdit(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow[] rows, @NotNull DBCLogicalOperator operator) {
        this.viewer = viewer;
        this.attribute = attribute;
        this.rows = rows;
        this.operator = operator;
    }

    @NotNull
    public ResultSetViewer getViewer() {
        return this.viewer;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    @NotNull
    public DBDAttributeBinding getAttribute() {
        return this.attribute;
    }

    @NotNull
    public ResultSetRow[] getRows() {
        return this.rows;
    }

    @NotNull
    public DBCLogicalOperator getOperator() {
        return this.operator;
    }

    public IValueEditor getEditor() {
        return this.editor;
    }

    public void setEditor(IValueEditor editor) {
        this.editor = editor;
    }

    void setupTable(Composite composite, int style, boolean visibleLines, boolean visibleHeader, Object layoutData) {
        this.tableViewer = new TableViewer(composite, style);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(visibleHeader);
        table.setLayoutData(layoutData);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        boolean bl = this.isCheckedTable = (style & 0x20) == 32;
        if (this.isCheckedTable) {
            this.buttonsPanel = UIUtils.createComposite((Composite)composite, (int)2);
            this.buttonsPanel.setLayoutData((Object)new GridData(768));
            this.toggleButton = UIUtils.createDialogButton((Composite)this.buttonsPanel, (String)"&Select All", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] items = GenericFilterValueEdit.this.tableViewer.getTable().getItems();
                    if (Boolean.FALSE.equals(GenericFilterValueEdit.this.toggleButton.getData())) {
                        TableItem[] tableItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            item.setChecked(false);
                            ++n2;
                        }
                        GenericFilterValueEdit.this.toggleButton.setData((Object)false);
                        GenericFilterValueEdit.this.savedValues.clear();
                    } else {
                        TableItem[] tableItemArray = items;
                        int n = items.length;
                        int n3 = 0;
                        while (n3 < n) {
                            TableItem item = tableItemArray[n3];
                            item.setChecked(true);
                            GenericFilterValueEdit.this.savedValues.add(((DBDLabelValuePair)item.getData()).getValue());
                            ++n3;
                        }
                        GenericFilterValueEdit.this.toggleButton.setData((Object)true);
                    }
                    GenericFilterValueEdit.this.updateToggleButton(GenericFilterValueEdit.this.toggleButton);
                }
            });
            this.updateToggleButton(this.toggleButton);
            GridData gd = new GridData(32);
            gd.widthHint = 120;
            this.toggleButton.setLayoutData((Object)gd);
            UIUtils.createEmptyLabel((Composite)this.buttonsPanel, (int)1, (int)1).setLayoutData((Object)new GridData(768));
            this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32) {
                        DBDLabelValuePair value = (DBDLabelValuePair)e.item.getData();
                        if (((TableItem)e.item).getChecked()) {
                            GenericFilterValueEdit.this.savedValues.add(value.getValue());
                        } else {
                            GenericFilterValueEdit.this.savedValues.remove(value.getValue());
                        }
                        GenericFilterValueEdit.this.updateToggleButton(GenericFilterValueEdit.this.toggleButton);
                    }
                }
            });
        }
    }

    private void updateToggleButton(Button toggleButton) {
        boolean hasCheckedItems = this.hasCheckedItems();
        toggleButton.setText(hasCheckedItems ? "&Clear All" : "&Select All");
        toggleButton.setData((Object)(!hasCheckedItems ? 1 : 0));
    }

    private boolean hasCheckedItems() {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem items = tableItemArray[n2];
            if (items.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void addContextMenu(Action[] actions) {
        UIUtils.createTableContextMenu((Table)this.tableViewer.getTable(), menu -> {
            Action[] actionArray2 = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action act = actionArray2[n2];
                menu.add((IAction)act);
                ++n2;
            }
            menu.add((IContributionItem)new Separator());
            return true;
        });
    }

    Collection<DBDLabelValuePair> getMultiValues() {
        return (Collection)this.tableViewer.getInput();
    }

    Text addFilterText(Composite composite) {
        AbstractJob loadValuesJob = new AbstractJob("Load values timeout"){

            protected IStatus run(DBRProgressMonitor monitor) {
                UIUtils.asyncExec(() -> GenericFilterValueEdit.this.loadValues(null));
                return Status.OK_STATUS;
            }
        };
        loadValuesJob.setSystem(true);
        loadValuesJob.setUser(false);
        Text valueFilterText = new Text(composite, 2048);
        valueFilterText.setLayoutData((Object)new GridData(768));
        valueFilterText.addModifyListener(e -> {
            this.filterPattern = valueFilterText.getText();
            if (this.filterPattern.isEmpty()) {
                this.filterPattern = null;
            }
            if (!loadValuesJob.isCanceled()) {
                loadValuesJob.cancel();
            }
            loadValuesJob.schedule(300L);
        });
        valueFilterText.addDisposeListener(e -> {
            KeyLoadJob curLoadJob = this.loadJob;
            if (curLoadJob != null && !curLoadJob.isCanceled()) {
                curLoadJob.cancel();
            }
            if (!loadValuesJob.isCanceled()) {
                loadValuesJob.cancel();
            }
        });
        return valueFilterText;
    }

    void loadValues(@Nullable Consumer<Result> onFinish) {
        KeyLoadJob curLoadJob = this.loadJob;
        if (curLoadJob != null) {
            if (!curLoadJob.isCanceled()) {
                curLoadJob.cancel();
            }
            curLoadJob.schedule(200L);
            return;
        }
        if (!this.queryDatabase) {
            this.loadMultiValueList(Collections.emptyList(), true, onFinish);
        } else {
            DBSEntityReferrer enumerableConstraint = ResultSetUtils.getEnumerableConstraint(this.attribute);
            if (enumerableConstraint != null) {
                this.loadConstraintEnum(enumerableConstraint, onFinish);
            } else if (this.attribute.getEntityAttribute() instanceof DBSAttributeEnumerable) {
                this.loadAttributeEnum((DBSAttributeEnumerable)this.attribute.getEntityAttribute(), onFinish);
            } else if (this.attribute.getDataContainer() instanceof DBSDocumentAttributeEnumerable) {
                this.loadDictionaryEnum((DBSDocumentAttributeEnumerable)this.attribute.getDataContainer(), onFinish);
            } else {
                this.loadMultiValueList(Collections.emptyList(), true, onFinish);
            }
        }
    }

    private void loadConstraintEnum(final DBSEntityReferrer refConstraint, @Nullable Consumer<Result> onFinish) {
        this.loadJob = new KeyLoadJob(this, "Load constraint '" + refConstraint.getName() + "' values", onFinish){

            @Override
            List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor monitor) throws DBException {
                DBSEntityAttribute tableColumn = attribute.getEntityAttribute();
                if (tableColumn == null) {
                    return null;
                }
                DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)refConstraint, (DBSEntityAttribute)tableColumn);
                if (fkColumn == null) {
                    return null;
                }
                if (!(refConstraint instanceof DBSEntityAssociation)) {
                    return null;
                }
                DBSEntityAssociation association = (DBSEntityAssociation)refConstraint;
                DBSEntityAttribute refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                if (refColumn == null) {
                    return null;
                }
                DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
                DBSEntityConstraint refConstraint2 = association.getReferencedConstraint();
                DBSDictionary enumConstraint = (DBSDictionary)refConstraint2.getParentObject();
                if (fkAttribute != null && enumConstraint != null) {
                    return enumConstraint.getDictionaryEnumeration(monitor, refColumn, (Object)filterPattern, null, true, true, caseInsensitiveSearch, 1000);
                }
                return null;
            }
        };
        this.loadJob.schedule();
    }

    private void loadAttributeEnum(final DBSAttributeEnumerable attributeEnumerable, @Nullable Consumer<Result> onFinish) {
        this.loadJob = new KeyLoadJob(this, "Load '" + this.attribute.getName() + "' values", onFinish){
            private List<DBDLabelValuePair> result;

            @Override
            List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor monitor) throws DBException {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)attributeEnumerable.getDataSource(), param -> {
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)attributeEnumerable, (String)"Read value enumeration");){
                            this.result = attributeEnumerable.getValueEnumeration(session, (Object)filterPattern, 1000, showRowCount, true, caseInsensitiveSearch);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return this.result;
            }

            @Override
            @Nullable
            protected Long readDistinctValuesCount(@NotNull DBRProgressMonitor monitor) throws DBException {
                Long[] result = new Long[1];
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)attributeEnumerable.getDataSource(), param -> {
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)attributeEnumerable, (String)"Read count of distinct values");){
                            longArray[0] = attributeEnumerable.getDistinctValuesCount(session);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return result[0];
            }
        };
        this.loadJob.schedule();
    }

    private void loadDictionaryEnum(final @NotNull DBSDocumentAttributeEnumerable dictionaryEnumerable, @Nullable Consumer<Result> onFinish) {
        this.loadJob = new KeyLoadJob(this, "Load '" + this.attribute.getName() + "' values", onFinish){

            @Override
            @NotNull
            List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor monitor) throws DBException {
                ArrayList<DBDLabelValuePair> result = new ArrayList<DBDLabelValuePair>();
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)dictionaryEnumerable.getDataSource(), param -> {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)dictionaryEnumerable, (String)"Read value enumeration");){
                            result.addAll(dictionaryEnumerable.getValueEnumeration(session, (DBSAttributeBase)attribute, filterPattern, showRowCount, caseInsensitiveSearch, 1000));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return result;
            }
        };
        this.loadJob.schedule();
    }

    private void loadMultiValueList(@NotNull Collection<DBDLabelValuePair> values, boolean mergeResultsWithData, @Nullable Consumer<Result> onFinish) {
        Widget item;
        ViewerColumnController vcc;
        Object itemString;
        if (this.tableViewer == null || this.tableViewer.getControl() == null || this.tableViewer.getControl().isDisposed()) {
            return;
        }
        Pattern pattern = null;
        if (!CommonUtils.isEmpty((String)this.filterPattern) && this.attribute.getDataKind() == DBPDataKind.STRING) {
            pattern = Pattern.compile(SQLUtils.makeLikePattern((String)("%" + this.filterPattern + "%")), 2);
        }
        boolean hasNulls = false;
        HashMap<Object, DBDLabelValuePair> rowData = new HashMap<Object, DBDLabelValuePair>();
        for (DBDLabelValuePair pair : values) {
            DBDLabelValuePair oldLabel = (DBDLabelValuePair)rowData.get(pair.getValue());
            if (oldLabel != null) {
                String multiLabel = String.valueOf(oldLabel.getLabel()) + "," + pair.getLabel();
                if (multiLabel.length() > 200) {
                    multiLabel = String.valueOf(multiLabel.substring(0, 200)) + MULTI_KEY_LABEL;
                }
                rowData.put(pair.getValue(), new DBDLabelValuePair(multiLabel, pair.getValue()));
                continue;
            }
            rowData.put(pair.getValue(), pair);
        }
        if (mergeResultsWithData) {
            for (ResultSetRow row : this.viewer.getModel().getAllRows()) {
                Object cellValue = this.viewer.getModel().getCellValue(this.attribute, row);
                if (DBUtils.isNullValue((Object)cellValue)) {
                    hasNulls = true;
                    continue;
                }
                DBDLabelValuePair dictValue = this.findValue(rowData, cellValue);
                if (dictValue == null && cellValue instanceof Date) {
                    DBDValueHandler valueHandler = DBUtils.findValueHandler((DBPDataSource)this.attribute.getDataSource(), (DBSTypedObject)this.attribute);
                    String displayString = valueHandler.getValueDisplayString((DBSTypedObject)this.attribute, cellValue, DBDDisplayFormat.NATIVE);
                    dictValue = this.findValue(rowData, displayString);
                }
                if (dictValue == null) {
                    rowData.put(cellValue, (DBDLabelValuePair)new DBDLabelValuePairExt(null, cellValue, 1L));
                    continue;
                }
                if (!values.isEmpty() || !(dictValue instanceof DBDLabelValuePairExt)) continue;
                ((DBDLabelValuePairExt)dictValue).incCount();
            }
        }
        ArrayList sortedList = new ArrayList(rowData.values());
        if (pattern != null) {
            Iterator iter = sortedList.iterator();
            while (iter.hasNext()) {
                DBDLabelValuePair valuePair = (DBDLabelValuePair)iter.next();
                String itemString2 = this.attribute.getValueHandler().getValueDisplayString((DBSTypedObject)this.attribute, valuePair.getValue(), DBDDisplayFormat.UI);
                if (pattern.matcher(itemString2).matches() || valuePair.getLabel() != null && pattern.matcher(valuePair.getLabel()).matches()) continue;
                iter.remove();
            }
        } else if (this.filterPattern != null && this.attribute.getDataKind() == DBPDataKind.NUMERIC) {
            double minValue = CommonUtils.toDouble((Object)this.filterPattern);
            Iterator<Object> iter = sortedList.iterator();
            while (iter.hasNext()) {
                DBDLabelValuePair valuePair = (DBDLabelValuePair)iter.next();
                itemString = this.attribute.getValueHandler().getValueDisplayString((DBSTypedObject)this.attribute, valuePair.getValue(), DBDDisplayFormat.EDIT);
                double itemValue = CommonUtils.toDouble((Object)itemString);
                if (!(itemValue < minValue)) continue;
                iter.remove();
            }
        }
        try {
            sortedList.sort(DBDLabelValuePair::compareTo);
        }
        catch (Exception e) {
            log.error((Object)"Error sorting value collection", (Throwable)e);
        }
        if (hasNulls) {
            boolean nullPresents = false;
            for (DBDLabelValuePair val : rowData.values()) {
                if (!DBUtils.isNullValue((Object)val.getValue())) continue;
                nullPresents = true;
                break;
            }
            if (!nullPresents) {
                sortedList.add(0, new DBDLabelValuePair(DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)DBDDisplayFormat.UI), null));
            }
        }
        HashSet<Object> checkedValues = new HashSet<Object>();
        itemString = this.rows;
        int valuePair = this.rows.length;
        int iter = 0;
        while (iter < valuePair) {
            ResultSetRow row = itemString[iter];
            Object value = this.viewer.getModel().getCellValue(this.attribute, row);
            checkedValues.add(value);
            ++iter;
        }
        DBDAttributeConstraint constraint = this.viewer.getModel().getDataFilter().getConstraint(this.attribute);
        if (constraint != null && constraint.getOperator() == DBCLogicalOperator.IN && constraint.getValue() instanceof Object[]) {
            Collections.addAll(checkedValues, (Object[])constraint.getValue());
        }
        checkedValues.addAll(this.savedValues);
        this.tableViewer.setInput(sortedList);
        DBDLabelValuePair firstVisibleItem = null;
        if (this.isCheckedTable) {
            for (DBDLabelValuePair row : sortedList) {
                Object cellValue = row.getValue();
                if (!checkedValues.contains(cellValue)) continue;
                TableItem t = (TableItem)this.tableViewer.testFindItem((Object)row);
                t.setChecked(true);
                if (firstVisibleItem != null) continue;
                firstVisibleItem = row;
            }
        }
        if ((vcc = ViewerColumnController.getFromControl((Control)this.tableViewer.getTable())) != null) {
            vcc.repackColumns();
        } else {
            UIUtils.packColumns((Table)this.tableViewer.getTable(), (boolean)true);
        }
        if (firstVisibleItem != null && (item = this.tableViewer.testFindItem(firstVisibleItem)) != null) {
            this.tableViewer.getTable().setSelection((TableItem)item);
            this.tableViewer.getTable().showItem((TableItem)item);
        }
        this.updateToggleButton(this.toggleButton);
        if (onFinish != null) {
            Result result = new Result();
            if (this.showDistinctValuesCount) {
                result.setTotalDistinctCount(Long.valueOf(sortedList.size()));
            }
            onFinish.accept(result);
        }
    }

    private DBDLabelValuePair findValue(Map<Object, DBDLabelValuePair> rowData, Object cellValue) {
        DBDLabelValuePair value = rowData.get(cellValue);
        if (value != null) {
            return value;
        }
        if (cellValue instanceof Number) {
            for (Map.Entry<Object, DBDLabelValuePair> pair : rowData.entrySet()) {
                if (!(pair.getKey() instanceof Number) || CommonUtils.compareNumbers((Number)((Number)pair.getKey()), (Number)((Number)cellValue)) != 0) continue;
                return pair.getValue();
            }
        }
        if (cellValue instanceof String) {
            for (Map.Entry<Object, DBDLabelValuePair> pair : rowData.entrySet()) {
                if (DBUtils.isNullValue((Object)pair.getKey()) || !CommonUtils.toString((Object)pair.getKey()).equals(cellValue)) continue;
                return pair.getValue();
            }
        }
        if (cellValue instanceof Timestamp) {
            for (Map.Entry<Object, DBDLabelValuePair> pair : rowData.entrySet()) {
                if (DBUtils.isNullValue((Object)pair.getKey())) continue;
                Object key = pair.getKey();
                try {
                    Timestamp timestamp = Timestamp.valueOf(key.toString());
                    if (timestamp.compareTo((Timestamp)cellValue) != 0) continue;
                    return pair.getValue();
                }
                catch (Exception exception) {}
            }
        }
        return rowData.get(cellValue.toString());
    }

    @Nullable
    public Object getFilterValue() {
        if (this.tableViewer != null) {
            LinkedHashSet<Object> values = new LinkedHashSet<Object>();
            for (DBDLabelValuePair item : this.getMultiValues()) {
                if (!((TableItem)this.tableViewer.testFindItem((Object)item)).getChecked()) continue;
                values.add(item.getValue());
            }
            values.addAll(this.savedValues);
            return values.toArray();
        }
        if (this.editor != null) {
            try {
                return this.editor.extractEditorValue();
            }
            catch (DBException e) {
                log.error((Object)"Can't get editor value", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public Object getSelectedFilterValue() {
        if (this.tableViewer != null) {
            Object selection = this.tableViewer.getStructuredSelection().getFirstElement();
            if (selection instanceof DBDLabelValuePair) {
                return new Object[]{((DBDLabelValuePair)selection).getValue()};
            }
        } else if (this.editor != null) {
            try {
                return this.editor.extractEditorValue();
            }
            catch (DBException e) {
                log.error((Object)"Can't get editor value", (Throwable)e);
            }
        }
        return null;
    }

    public Composite getButtonsPanel() {
        return this.buttonsPanel;
    }

    Button createFilterButton(String label, SelectionAdapter selectionAdapter) {
        if (this.isCheckedTable) {
            Button button = UIUtils.createDialogButton((Composite)this.buttonsPanel, (String)label, (SelectionListener)selectionAdapter);
            ++((GridLayout)this.buttonsPanel.getLayout()).numColumns;
            return button;
        }
        return null;
    }

    boolean isDictionarySelector() {
        return ResultSetUtils.getEnumerableConstraint(this.attribute) != null;
    }

    void setQueryDatabase(boolean queryDatabase) {
        this.queryDatabase = queryDatabase;
    }

    void setShowRowCount(boolean showRowCount) {
        this.showRowCount = showRowCount;
    }

    public void setShowDistinctValuesCount(boolean showDistinctValuesCount) {
        this.showDistinctValuesCount = showDistinctValuesCount;
    }

    public void setCaseInsensitiveSearch(boolean caseInsensitiveSearch) {
        this.caseInsensitiveSearch = caseInsensitiveSearch;
    }

    static /* synthetic */ String access$0(GenericFilterValueEdit genericFilterValueEdit) {
        return genericFilterValueEdit.filterPattern;
    }

    static /* synthetic */ boolean access$1(GenericFilterValueEdit genericFilterValueEdit) {
        return genericFilterValueEdit.showRowCount;
    }

    static /* synthetic */ boolean access$2(GenericFilterValueEdit genericFilterValueEdit) {
        return genericFilterValueEdit.caseInsensitiveSearch;
    }

    static /* synthetic */ DBDAttributeBinding access$3(GenericFilterValueEdit genericFilterValueEdit) {
        return genericFilterValueEdit.attribute;
    }

    private abstract class KeyLoadJob
    extends AbstractJob {
        private final Consumer<Result> onFinish;

        KeyLoadJob(@Nullable String name, Consumer<Result> onFinish) {
            super(name);
            this.onFinish = onFinish;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            block10: {
                List<DBDLabelValuePair> valueEnumeration;
                Result result;
                block9: {
                    monitor.beginTask("Read filter values", 1);
                    DBCExecutionContext executionContext = GenericFilterValueEdit.this.viewer.getExecutionContext();
                    if (executionContext == null) {
                        return Status.OK_STATUS;
                    }
                    UIUtils.syncExec(() -> {
                        Table table = GenericFilterValueEdit.this.tableViewer.getTable();
                        if (table != null && !table.isDisposed()) {
                            table.setEnabled(false);
                        }
                    });
                    result = new Result();
                    if (GenericFilterValueEdit.this.showDistinctValuesCount) {
                        try {
                            monitor.subTask("Read distinct values count");
                            result.setTotalDistinctCount(this.readDistinctValuesCount(monitor));
                        }
                        catch (Throwable e) {
                            log.error((Object)"Can't read count of distinct values", e);
                        }
                    }
                    monitor.subTask("Read enumeration");
                    valueEnumeration = this.readEnumeration(monitor);
                    if (valueEnumeration != null) break block9;
                    this.populateValues(Collections.emptyList());
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
                try {
                    try {
                        this.populateValues(valueEnumeration);
                        if (this.onFinish == null) break block10;
                        this.onFinish.accept(result);
                    }
                    catch (Throwable e) {
                        this.populateValues(Collections.emptyList());
                        log.error((Object)e);
                        monitor.done();
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            GenericFilterValueEdit.this.loadJob = null;
            return Status.OK_STATUS;
        }

        @Nullable
        abstract List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor var1) throws DBException;

        @Nullable
        protected Long readDistinctValuesCount(@NotNull DBRProgressMonitor monitor) throws DBException {
            return null;
        }

        boolean mergeResultsWithData() {
            return CommonUtils.isEmpty((String)GenericFilterValueEdit.this.filterPattern);
        }

        void populateValues(@NotNull Collection<DBDLabelValuePair> values) {
            UIUtils.asyncExec(() -> {
                Table table = GenericFilterValueEdit.this.tableViewer.getTable();
                if (table != null && !table.isDisposed()) {
                    GenericFilterValueEdit.this.loadMultiValueList(values, this.mergeResultsWithData(), null);
                    table.setEnabled(true);
                }
            });
        }
    }

    static class Result {
        private Long totalDistinctCount;

        Result() {
        }

        public void setTotalDistinctCount(@Nullable Long totalDistinctCount) {
            this.totalDistinctCount = totalDistinctCount;
        }

        @Nullable
        public Long getTotalDistinctCount() {
            return this.totalDistinctCount;
        }
    }
}

