/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDContext;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class ERDEntityAttribute
extends ERDObject<DBSEntityAttribute> {
    private boolean isChecked;
    private int order = -1;
    private boolean inPrimaryKey;
    private boolean inForeignKey;
    private String alias;

    public ERDEntityAttribute(DBSEntityAttribute attribute, boolean inPrimaryKey) {
        super(attribute);
        this.inPrimaryKey = inPrimaryKey;
    }

    public String getLabelText() {
        return ((DBSEntityAttribute)this.object).getName();
    }

    public DBPImage getLabelImage() {
        return DBValueFormatting.getObjectImage((DBPObject)((DBPObject)this.object));
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isInPrimaryKey() {
        return this.inPrimaryKey;
    }

    public boolean isInForeignKey() {
        return this.inForeignKey;
    }

    public void setInForeignKey(boolean inForeignKey) {
        this.inForeignKey = inForeignKey;
    }

    @NotNull
    public String getName() {
        return ((DBSEntityAttribute)this.getObject()).getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void fromMap(@NotNull ERDContext context, Map<String, Object> attrMap) {
        this.alias = JSONUtils.getString(attrMap, (String)"alias");
        this.isChecked = JSONUtils.getBoolean(attrMap, (String)"checked");
        this.inPrimaryKey = JSONUtils.getBoolean(attrMap, (String)"inPrimaryKey");
        this.inForeignKey = JSONUtils.getBoolean(attrMap, (String)"inForeignKey");
    }

    @Override
    public Map<String, Object> toMap(@NotNull ERDContext context) {
        DBSEntityAttribute entityAttribute;
        LinkedHashMap<String, Object> attrMap = new LinkedHashMap<String, Object>();
        attrMap.put("name", this.getName());
        if (!CommonUtils.isEmpty((String)this.getAlias())) {
            attrMap.put("alias", this.getAlias());
        }
        if ((entityAttribute = (DBSEntityAttribute)this.getObject()) != null) {
            attrMap.put("dataKind", entityAttribute.getDataKind().name());
            attrMap.put("typeName", entityAttribute.getTypeName());
            if (!entityAttribute.isRequired()) {
                attrMap.put("optional", true);
            }
            int iconIndex = context.getIconIndex(DBValueFormatting.getObjectImage((DBPObject)entityAttribute));
            attrMap.put("iconIndex", iconIndex);
            attrMap.put("fullTypeName", entityAttribute.getFullTypeName());
            if (!CommonUtils.isEmpty((String)entityAttribute.getDefaultValue())) {
                attrMap.put("defaultValue", entityAttribute.getDefaultValue());
            }
            if (!CommonUtils.isEmpty((String)entityAttribute.getDescription())) {
                attrMap.put("description", entityAttribute.getDescription());
            }
        }
        if (this.isChecked()) {
            attrMap.put("checked", true);
        }
        if (this.isInPrimaryKey()) {
            attrMap.put("inPrimaryKey", true);
        }
        if (this.isInForeignKey()) {
            attrMap.put("inForeignKey", true);
        }
        return attrMap;
    }
}

