/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupInfo;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreNativeToolHandler;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDatabaseBackupHandler
extends PostgreNativeToolHandler<PostgreDatabaseBackupSettings, DBSObject, PostgreDatabaseBackupInfo> {
    public Collection<PostgreDatabaseBackupInfo> getRunInfo(PostgreDatabaseBackupSettings settings) {
        return settings.getExportObjects();
    }

    protected PostgreDatabaseBackupSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        PostgreDatabaseBackupSettings settings = new PostgreDatabaseBackupSettings();
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, PostgreDatabaseBackupSettings settings, Log log) {
        if (task.getType().getId().equals("pgDatabaseBackup")) {
            for (PostgreDatabaseBackupInfo exportObject : settings.getExportObjects()) {
                File dir = settings.getOutputFolder(exportObject);
                if (dir.exists() || dir.mkdirs()) continue;
                log.error((Object)("Can't create directory '" + dir.getAbsolutePath() + "'"));
                return false;
            }
        }
        return true;
    }

    protected boolean needsModelRefresh() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    protected boolean isLogInputStream() {
        return false;
    }

    @Override
    protected boolean isExportWizard() {
        return true;
    }

    @Override
    public void fillProcessParameters(PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg, List<String> cmd) throws IOException {
        block9: {
            block10: {
                super.fillProcessParameters(settings, arg, cmd);
                cmd.add("--format=" + settings.getFormat().getId());
                if (!CommonUtils.isEmpty((String)settings.getCompression())) {
                    cmd.add("--compress=" + settings.getCompression());
                }
                if (!CommonUtils.isEmpty((String)settings.getEncoding())) {
                    cmd.add("--encoding=" + settings.getEncoding());
                }
                if (settings.isUseInserts()) {
                    cmd.add("--inserts");
                }
                if (settings.isNoPrivileges()) {
                    cmd.add("--no-privileges");
                }
                if (settings.isNoOwner()) {
                    cmd.add("--no-owner");
                }
                if (settings.isDropObjects()) {
                    cmd.add("--clean");
                }
                if (settings.isCreateDatabase()) {
                    cmd.add("--create");
                }
                cmd.add("--file");
                cmd.add(settings.getOutputFile(arg).getAbsolutePath());
                if (settings.getExportObjects().isEmpty()) break block9;
                if (CommonUtils.isEmpty(arg.getTables())) break block10;
                for (PostgreTableBase table : arg.getTables()) {
                    cmd.add("-t");
                    cmd.add(PostgreDatabaseBackupHandler.escapeCLIIdentifier(table.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                }
                break block9;
            }
            if (CommonUtils.isEmpty(arg.getSchemas())) break block9;
            for (PostgreSchema schema : arg.getSchemas()) {
                cmd.add("-n");
                cmd.add(PostgreDatabaseBackupHandler.escapeCLIIdentifier(DBUtils.getQuotedIdentifier((DBSObject)schema)));
            }
        }
    }

    private static String escapeCLIIdentifier(String name) {
        if (RuntimeUtils.isWindows()) {
            return "\"" + name.replace("\"", "\\\"") + "\"";
        }
        return name;
    }

    protected List<String> getCommandLine(PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.fillProcessParameters(settings, arg, cmd);
        cmd.add(arg.getDatabase().getName());
        return cmd;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, PostgreDatabaseBackupSettings settings, PostgreDatabaseBackupInfo arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException {
        super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
    }
}

