/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttributeIdentity;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandlerProvider;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class PostgreAttribute<OWNER extends DBSEntity & PostgreObject>
extends JDBCTableColumn<OWNER>
implements PostgreObject,
DBSTypedObjectEx,
DBPNamedObject2,
DBPHiddenObject,
DBPInheritedObject,
DBSTypedObjectExt4<PostgreDataType> {
    private static final Log log = Log.getLog(PostgreAttribute.class);
    private PostgreDataType dataType;
    private String comment;
    private long charLength;
    private int arrayDim;
    private int inheritorsCount;
    private String description;
    @Nullable
    private PostgreAttributeIdentity identity;
    private boolean isLocal;
    private long collationId;
    private Object acl;
    private long typeId;
    private int typeMod;
    @Nullable
    private String[] foreignTableColumnOptions;
    @Nullable
    private String defaultValue;
    @Nullable
    private boolean isGeneratedColumn;

    protected PostgreAttribute(OWNER table) {
        super(table, false);
        this.isLocal = true;
    }

    public PostgreAttribute(DBRProgressMonitor monitor, OWNER table, JDBCResultSet dbResult) throws DBException {
        super(table, true);
        this.loadInfo(monitor, dbResult);
    }

    public PostgreAttribute(DBRProgressMonitor monitor, OWNER table, PostgreAttribute source) throws DBException {
        super(table, (DBSEntityAttribute)source, true);
        this.dataType = source.dataType;
        this.comment = source.comment;
        this.charLength = source.charLength;
        this.arrayDim = source.arrayDim;
        this.inheritorsCount = source.inheritorsCount;
        this.description = source.description;
        this.identity = source.identity;
        this.isLocal = source.isLocal;
        this.collationId = source.collationId;
        this.acl = source.acl;
        this.typeId = source.typeId;
        this.typeMod = source.typeMod;
        this.defaultValue = source.defaultValue;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return ((PostgreObject)this.getTable()).getDatabase();
    }

    public long getObjectId() {
        return this.getOrdinalPosition();
    }

    private void loadInfo(DBRProgressMonitor monitor, JDBCResultSet dbResult) throws DBException {
        String identityStr;
        String generatedColumn;
        PostgreDataSource dataSource = this.getDataSource();
        PostgreServerExtension serverType = dataSource.getServerType();
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attnum"));
        this.setRequired(JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"attnotnull"));
        this.typeId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"atttypid");
        this.defaultValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"def_value");
        String serialValuePattern = String.valueOf(this.getParentObject().getName()) + "_" + this.getName() + "_seq";
        if ((this.typeId == 21L || this.typeId == 23L || this.typeId == 20L) && CommonUtils.isNotEmpty((String)this.defaultValue) && this.defaultValue.startsWith("nextval(") && this.defaultValue.contains(serialValuePattern)) {
            if (this.typeId == 23L) {
                this.typeId = 4443L;
            } else if (this.typeId == 21L) {
                this.typeId = 4444L;
            } else if (this.typeId == 20L) {
                this.typeId = 4442L;
            }
        }
        if (!CommonUtils.isEmpty((String)this.defaultValue) && serverType.supportsGeneratedColumns() && !CommonUtils.isEmpty((String)(generatedColumn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attgenerated")))) {
            this.isGeneratedColumn = true;
        }
        this.dataType = ((PostgreObject)this.getTable()).getDatabase().getDataType(monitor, this.typeId);
        if (this.dataType == null) {
            log.error((Object)("Attribute data type '" + this.typeId + "' not found. Use " + "varchar"));
            this.dataType = ((PostgreObject)this.getTable()).getDatabase().getDataType(monitor, "varchar");
        }
        this.setValueType(this.dataType.getTypeID());
        this.typeMod = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"atttypmod");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.arrayDim = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attndims");
        this.inheritorsCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"attinhcount");
        boolean bl = this.isLocal = !serverType.supportsInheritance() || JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"attislocal", (boolean)true);
        if (dataSource.isServerVersionAtLeast(10, 0) && !CommonUtils.isEmpty((String)(identityStr = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attidentity")))) {
            this.identity = PostgreAttributeIdentity.getByCode(identityStr);
        }
        if (serverType.supportsCollations()) {
            this.collationId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attcollation");
        }
        this.acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"attacl");
        if (this.getTable() instanceof PostgreTableForeign) {
            this.foreignTableColumnOptions = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"attfdwoptions");
        }
        this.setPersisted(true);
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return ((PostgreObject)this.getTable()).getDataSource();
    }

    public Object getAcl() {
        return this.acl;
    }

    @Nullable
    public PostgreDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(@NotNull PostgreDataType dataType) {
        this.dataType = dataType;
        this.typeName = dataType.getTypeName();
        this.valueType = dataType.getTypeID();
    }

    public DBPDataKind getDataKind() {
        return this.dataType == null ? super.getDataKind() : this.dataType.getDataKind();
    }

    public long getMaxLength() {
        Integer length;
        PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(this.dataType);
        if (handler != null && (length = handler.getTypeLength(this.dataType, this.typeMod)) != null) {
            return length.intValue();
        }
        return PostgreUtils.getDisplaySize(this.typeId, this.typeMod);
    }

    public void setMaxLength(long maxLength) {
        log.debug((Object)"Attribute does not support updating its max length");
    }

    public Integer getPrecision() {
        PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(this.dataType);
        if (handler != null) {
            return handler.getTypePrecision(this.dataType, this.typeMod);
        }
        return null;
    }

    public void setPrecision(Integer precision) {
        log.debug((Object)"Attribute does not support updating its precision");
    }

    public Integer getScale() {
        PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(this.dataType);
        if (handler != null) {
            return handler.getTypeScale(this.dataType, this.typeMod);
        }
        return null;
    }

    public void setScale(Integer scale) {
        log.debug((Object)"Attribute does not support updating its scale");
    }

    @Property(viewable=true, editableExpr="!object.table.view", order=28)
    @Nullable
    public PostgreAttributeIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(PostgreAttributeIdentity identity) {
        this.identity = identity;
    }

    @Property(order=29)
    public boolean isLocal() {
        return this.isLocal;
    }

    @Property(viewable=true, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    public boolean isAutoGenerated() {
        if (this.identity != null) {
            return true;
        }
        String def = this.getDefaultValue();
        return def != null && def.contains("nextval(");
    }

    @Property(viewable=true, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=70)
    @Nullable
    public String getDefaultValue() {
        if (this.isGeneratedColumn) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Property(order=80)
    @Nullable
    public String getGeneratedValue() {
        if (this.isGeneratedColumn) {
            return this.defaultValue;
        }
        return null;
    }

    public long getTypeId() {
        return this.typeId;
    }

    public int getTypeMod() {
        return this.typeMod;
    }

    public void setTypeMod(int typeMod) {
        this.typeMod = typeMod;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property(viewable=true, editableExpr="!object.table.view", order=30, listProvider=CollationListProvider.class)
    public PostgreCollation getCollation(DBRProgressMonitor monitor) throws DBException {
        if (this.collationId <= 0L) {
            return null;
        }
        return this.getDatabase().getCollation(monitor, this.collationId);
    }

    public void setCollation(PostgreCollation collation) {
        this.collationId = collation == null ? 0L : collation.getObjectId();
    }

    public boolean isHidden() {
        if (this.isPersisted()) {
            return this.getOrdinalPosition() < 0 || this.getDataSource().getServerType().isHiddenRowidColumn(this);
        }
        return false;
    }

    public boolean isInherited() {
        return !this.isLocal;
    }

    public String getTypeName() {
        if (this.dataType != null) {
            return this.dataType.getTypeName();
        }
        return this.typeName;
    }

    public void setTypeName(String typeName) throws DBException {
        PostgreDataType dataType = PostgreAttribute.findDataType(this.getSchema(), typeName);
        this.typeName = typeName;
        this.typeId = dataType.getTypeID();
        this.dataType = dataType;
    }

    @Property(viewable=true, editableExpr="!object.table.view", updatableExpr="!object.table.view", order=20, listProvider=DataTypeListProvider.class)
    public String getFullTypeName() {
        if (this.dataType == null) {
            return this.getTypeName();
        }
        PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(this.dataType);
        if (handler != null) {
            return String.valueOf(this.dataType.getTypeName()) + handler.getTypeModifiersString(this.dataType, this.typeMod);
        }
        return this.dataType.getTypeName();
    }

    public void setFullTypeName(String fullTypeName) throws DBException {
        Pair type = DBUtils.getTypeModifiers((String)fullTypeName);
        String typeName = (String)type.getFirst();
        String[] typeMods = (String[])type.getSecond();
        PostgreDataType dataType = PostgreAttribute.findDataType(this.getSchema(), typeName);
        PostgreTypeHandler handler = PostgreTypeHandlerProvider.getTypeHandler(dataType);
        if (handler != null) {
            this.typeMod = handler.getTypeModifiers(dataType, typeName, typeMods);
            this.typeId = dataType.getTypeID();
            this.dataType = dataType;
        } else {
            super.setFullTypeName(fullTypeName);
        }
    }

    @Nullable
    public String[] getForeignTableColumnOptions() {
        return this.foreignTableColumnOptions;
    }

    @NotNull
    public abstract PostgreSchema getSchema();

    @NotNull
    private static PostgreDataType findDataType(@NotNull PostgreSchema schema, @NotNull String typeName) throws DBException {
        PostgreDataType dataType = schema.getDataSource().getLocalDataType(typeName);
        if (dataType == null) {
            dataType = schema.getDatabase().getDataType(null, typeName);
        }
        if (dataType == null && schema.getDataSource().getServerType().supportsExternalTypes()) {
            log.debug((Object)("Can't find specified data type by name: '" + typeName + "', creating a fake type"));
            dataType = new PostgreDataType(schema, 1111, typeName);
            schema.getDataTypeCache().cacheObject(dataType);
        }
        if (dataType == null) {
            throw new DBException("Can't find specified data type by name: '" + typeName + "'");
        }
        return dataType;
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<PostgreAttribute> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreAttribute object) {
            try {
                return object.getDatabase().getCollations((DBRProgressMonitor)new VoidProgressMonitor()).toArray();
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class DataTypeListProvider
    implements IPropertyValueListProvider<PostgreAttribute<?>> {
        public boolean allowCustomValue() {
            return true;
        }

        public Object[] getPossibleValues(PostgreAttribute<?> column) {
            ArrayList<PostgreDataType> types = new ArrayList<PostgreDataType>();
            try {
                Collection<PostgreSchema> schemas = column.getDatabase().getSchemas((DBRProgressMonitor)new VoidProgressMonitor());
                for (PostgreSchema schema : schemas) {
                    List dataTypes = schema.getDataTypeCache().getCachedObjects();
                    types.addAll(dataTypes);
                }
            }
            catch (DBException e) {
                log.debug((Object)"Can't get data types from database schemas", (Throwable)e);
                types.addAll(column.getDatabase().getLocalDataTypes());
            }
            return types.stream().map(DBSTypedObject::getTypeName).sorted(Comparator.comparing(name -> name.startsWith("_")).thenComparing(Function.identity())).toArray(String[]::new);
        }
    }
}

