/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.ConstraintKeysCache;
import org.jkiss.dbeaver.ext.generic.model.ForeignKeysCache;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSourceInfo;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericStructureAssistant;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTableType;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.IndexCache;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.ext.generic.model.TableTriggerCache;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.time.ExtendedDateFormat;

public class GenericDataSource
extends JDBCDataSource
implements DBPTermProvider,
IAdaptable,
GenericStructContainer {
    private static final Log log = Log.getLog(GenericDataSource.class);
    private final TableTypeCache tableTypeCache;
    private final JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> dataTypeCache;
    private List<GenericCatalog> catalogs;
    private SimpleObjectCache<GenericStructContainer, GenericSchema> schemas;
    private final GenericMetaModel metaModel;
    private GenericObjectContainer structureContainer;
    boolean catalogsFiltered;
    private String queryGetActiveDB;
    private String querySetActiveDB;
    private String selectedEntityType;
    private boolean selectedEntityFromAPI;
    private boolean omitSingleCatalog;
    private String allObjectsPattern;
    private boolean supportsStructCache;
    private DBCQueryPlanner queryPlanner;
    private Format nativeFormatTimestamp;
    private Format nativeFormatTime;
    private Format nativeFormatDate;

    public GenericDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, dialect, false);
        this.metaModel = metaModel;
        DBPDriver driver = container.getDriver();
        this.dataTypeCache = metaModel.createDataTypeCache(this);
        this.tableTypeCache = new TableTypeCache();
        this.queryGetActiveDB = CommonUtils.toString((Object)driver.getDriverParameter("query-get-active-db"));
        this.querySetActiveDB = CommonUtils.toString((Object)driver.getDriverParameter("query-set-active-db"));
        this.selectedEntityType = CommonUtils.toString((Object)driver.getDriverParameter("active-entity-type"));
        this.omitSingleCatalog = CommonUtils.getBoolean((Object)driver.getDriverParameter("omit-single-catalog"), (boolean)false);
        if (CommonUtils.isEmpty((String)this.selectedEntityType)) {
            this.selectedEntityType = null;
        }
        this.allObjectsPattern = CommonUtils.toString((Object)driver.getDriverParameter("all-objects-pattern"));
        if (CommonUtils.isEmpty((String)this.allObjectsPattern)) {
            this.allObjectsPattern = "%";
        } else if ("null".equalsIgnoreCase(this.allObjectsPattern)) {
            this.allObjectsPattern = null;
        }
        this.nativeFormatTimestamp = this.makeNativeFormat("native-format-timestamp");
        this.nativeFormatTime = this.makeNativeFormat("native-format-time");
        this.nativeFormatDate = this.makeNativeFormat("native-format-date");
        this.initializeRemoteInstance(monitor);
    }

    public GenericDataSource(@NotNull DBRProgressMonitor monitor, @NotNull GenericMetaModel metaModel, @NotNull DBPDataSourceContainer container, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, dialect, false);
        this.metaModel = metaModel;
        this.dataTypeCache = metaModel.createDataTypeCache(this);
        this.tableTypeCache = new TableTypeCache();
    }

    protected String getConnectionURL(DBPConnectionConfiguration connectionInfo) {
        String connectionURL = this.getContainer().getDriver().getConnectionURL(connectionInfo);
        if (!this.getContainer().getDriver().isSampleURLApplicable() && connectionInfo.getUrl() != null && !CommonUtils.equalObjects((Object)connectionURL, (Object)connectionInfo.getUrl())) {
            log.warn((Object)("Actual connection URL (" + connectionURL + ") differs from previously saved (" + connectionInfo.getUrl() + "). " + "Probably driver properties were changed. Please go to the connection '" + this.getContainer().getName() + "' editor."));
            connectionInfo.setUrl(connectionURL);
        }
        return connectionURL;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection jdbcConnection = super.openConnection(monitor, context, purpose);
        if (this.isPopulateClientAppName() && !this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            this.populateClientAppName(context, purpose, jdbcConnection);
        }
        return jdbcConnection;
    }

    private void populateClientAppName(JDBCExecutionContext context, @NotNull String purpose, Connection jdbcConnection) {
        boolean wasPopulated;
        block10: {
            wasPopulated = false;
            try {
                ResultSet ciList = jdbcConnection.getMetaData().getClientInfoProperties();
                if (ciList == null) break block10;
                try {
                    while (ciList.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)ciList, (String)"NAME");
                        int maxLength = JDBCUtils.safeGetInt((ResultSet)ciList, (String)"MAX_LEN");
                        if (!"ApplicationName".equals(name)) continue;
                        String appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
                        if (maxLength <= 0) {
                            maxLength = 48;
                        }
                        jdbcConnection.setClientInfo("ApplicationName", CommonUtils.truncateString((String)appName, (int)maxLength));
                        wasPopulated = true;
                        break;
                    }
                }
                finally {
                    ciList.close();
                }
            }
            catch (Throwable e) {
                log.debug((Object)("Error reading and setting client application name: " + e.getMessage()));
            }
        }
        if (!wasPopulated) {
            String appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
            try {
                jdbcConnection.setClientInfo("ApplicationName", appName);
            }
            catch (Throwable e) {
                log.debug((Object)("Error setting client application name: " + e.getMessage()));
            }
        }
    }

    protected boolean isPopulateClientAppName() {
        return this.getClass() != GenericDataSource.class;
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new GenericExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        super.initializeContextState(monitor, context, initFrom);
        if (initFrom != null) {
            GenericExecutionContext metaContext = (GenericExecutionContext)initFrom;
            ((GenericExecutionContext)context).initDefaultsFrom(monitor, metaContext);
        } else {
            ((GenericExecutionContext)context).refreshDefaults(monitor, true);
        }
    }

    public String getAllObjectsPattern() {
        return this.allObjectsPattern;
    }

    @NotNull
    public GenericMetaModel getMetaModel() {
        return this.metaModel;
    }

    @Nullable
    public GenericMetaObject getMetaObject(String id) {
        return this.metaModel.getMetaObject(id);
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        Object supportSchemaSelection;
        Object supportsCatalogSelection;
        Object supportsStructCacheParam;
        Object supportsSubqueries;
        Object supportsStoredCode;
        Object supportsViews;
        Object supportsIndexes;
        GenericDataSourceInfo info = new GenericDataSourceInfo(this.getContainer().getDriver(), metaData);
        JDBCSQLDialect dialect = (JDBCSQLDialect)this.getSQLDialect();
        Object supportsReferences = this.getContainer().getDriver().getDriverParameter("supports-references");
        if (supportsReferences != null) {
            info.setSupportsReferences(CommonUtils.toBoolean((Object)supportsReferences));
        }
        if ((supportsIndexes = this.getContainer().getDriver().getDriverParameter("supports-indexes")) != null) {
            info.setSupportsIndexes(CommonUtils.toBoolean((Object)supportsIndexes));
        }
        if ((supportsViews = this.getContainer().getDriver().getDriverParameter("supports-views")) != null) {
            info.setSupportsViews(CommonUtils.toBoolean((Object)supportsViews));
        }
        if ((supportsStoredCode = this.getContainer().getDriver().getDriverParameter("supports-stored-code")) != null) {
            info.setSupportsStoredCode(CommonUtils.toBoolean((Object)supportsStoredCode));
        }
        if ((supportsSubqueries = this.getContainer().getDriver().getDriverParameter("supports-subqueries")) != null) {
            dialect.setSupportsSubqueries(CommonUtils.toBoolean((Object)supportsSubqueries));
        }
        if ((supportsStructCacheParam = this.getContainer().getDriver().getDriverParameter("supports-struct-cache")) != null) {
            this.supportsStructCache = CommonUtils.toBoolean((Object)supportsStructCacheParam);
        }
        if ((supportsCatalogSelection = this.getContainer().getDriver().getDriverParameter("supports-catalog-selection")) != null) {
            info.supportsCatalogSelection = CommonUtils.toBoolean((Object)supportsCatalogSelection);
        }
        if ((supportSchemaSelection = this.getContainer().getDriver().getDriverParameter("supports-schema-selection")) != null) {
            info.supportsSchemaSelection = CommonUtils.toBoolean((Object)supportSchemaSelection);
        }
        return info;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        String queryShutdown = CommonUtils.toString((Object)this.getContainer().getDriver().getDriverParameter("query-shutdown"));
        if (!CommonUtils.isEmpty((String)queryShutdown)) {
            for (JDBCRemoteInstance instance : this.getAvailableInstances()) {
                JDBCExecutionContext[] jDBCExecutionContextArray = instance.getAllContexts();
                int n = jDBCExecutionContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JDBCExecutionContext context = jDBCExecutionContextArray[n2];
                    try {
                        Throwable throwable = null;
                        Object var10_14 = null;
                        try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Shutdown database");){
                            JDBCUtils.executeStatement((Connection)session, (String)queryShutdown);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error shutting down database", e);
                    }
                    ++n2;
                }
            }
        }
        super.shutdown(monitor);
        String paramShutdown = CommonUtils.toString((Object)this.getContainer().getDriver().getDriverParameter("shutdown-url-param"));
        if (!CommonUtils.isEmpty((String)paramShutdown)) {
            monitor.subTask("Shutdown embedded database");
            try {
                Driver driver;
                Properties shutdownProps = new Properties();
                DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
                    shutdownProps.put("user", connectionInfo.getUserName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
                    shutdownProps.put("password", connectionInfo.getUserPassword());
                }
                if ((driver = this.getDriverInstance((DBRProgressMonitor)new VoidProgressMonitor())) != null) {
                    driver.connect(String.valueOf(this.getContainer().getActualConnectionConfiguration().getUrl()) + paramShutdown, shutdownProps.isEmpty() ? null : shutdownProps);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Shutdown finished: :" + e.getMessage()));
            }
            monitor.worked(1);
        }
    }

    boolean supportsStructCache() {
        return this.supportsStructCache;
    }

    @Association
    public Collection<GenericTableType> getTableTypes(DBRProgressMonitor monitor) throws DBException {
        return this.tableTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public List<GenericCatalog> getCatalogs() {
        return this.catalogs;
    }

    public GenericCatalog getCatalog(String name) {
        return (GenericCatalog)DBUtils.findObject(this.getCatalogs(), (String)name);
    }

    public final Collection<GenericCatalog> getCatalogList() {
        return this.getCatalogs();
    }

    public final Collection<GenericSchema> getSchemaList() {
        if (this.getDataSource().isMergeEntities()) {
            return null;
        }
        return this.getSchemas();
    }

    @Association
    public List<GenericSchema> getSchemas() {
        return this.schemas == null ? null : this.schemas.getCachedObjects();
    }

    public GenericSchema getSchema(String name) {
        return this.schemas == null ? null : (GenericSchema)this.schemas.getCachedObject(name);
    }

    @Override
    @NotNull
    public GenericDataSource getDataSource() {
        return this;
    }

    @Override
    public GenericStructContainer getObject() {
        return this;
    }

    @Override
    public GenericCatalog getCatalog() {
        return null;
    }

    @Override
    public GenericSchema getSchema() {
        return null;
    }

    @Override
    public TableCache getTableCache() {
        return this.structureContainer.getTableCache();
    }

    @Override
    public IndexCache getIndexCache() {
        return this.structureContainer.getIndexCache();
    }

    @Override
    public ConstraintKeysCache getConstraintKeysCache() {
        return this.structureContainer.getConstraintKeysCache();
    }

    @Override
    public ForeignKeysCache getForeignKeysCache() {
        return this.structureContainer.getForeignKeysCache();
    }

    @Override
    public TableTriggerCache getTableTriggerCache() {
        return this.structureContainer.getTableTriggerCache();
    }

    @Override
    public GenericObjectContainer.GenericSequenceCache getSequenceCache() {
        return this.structureContainer.getSequenceCache();
    }

    @Override
    public GenericObjectContainer.GenericSynonymCache getSynonymCache() {
        return this.structureContainer.getSynonymCache();
    }

    @Override
    public List<? extends GenericView> getViews(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getViews(monitor);
    }

    @Override
    public List<? extends GenericTable> getPhysicalTables(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getPhysicalTables(monitor);
    }

    @Override
    public List<? extends GenericTableBase> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTables(monitor);
    }

    @Override
    public GenericTableBase getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTable(monitor, name);
    }

    public Collection<GenericPackage> getPackages(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getPackages(monitor);
    }

    public Collection<GenericTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getIndexes(monitor);
    }

    @Override
    public Collection<? extends GenericProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedures(monitor);
    }

    @Override
    public Collection<? extends GenericProcedure> getProceduresOnly(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProceduresOnly(monitor);
    }

    @Override
    public GenericProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedure(monitor, uniqueName);
    }

    public Collection<GenericProcedure> getProcedures(DBRProgressMonitor monitor, String name) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getProcedures(monitor, name);
    }

    @Override
    public Collection<? extends GenericProcedure> getFunctionsOnly(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getFunctionsOnly(monitor);
    }

    @Override
    public Collection<? extends GenericSequence> getSequences(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getSequences(monitor);
    }

    @Override
    public Collection<? extends GenericSynonym> getSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getSynonyms(monitor);
    }

    @Override
    public Collection<? extends GenericTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTriggers(monitor);
    }

    @Override
    public Collection<? extends GenericTrigger> getTableTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.structureContainer == null ? null : this.structureContainer.getTableTriggers(monitor);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        block25: {
            super.initialize(monitor);
            boolean omitCatalog = this.isOmitCatalog();
            boolean omitTypeCache = CommonUtils.toBoolean((Object)this.getContainer().getDriver().getDriverParameter("omit-type-cache"));
            if (!omitTypeCache) {
                try {
                    this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
                }
                catch (Exception e) {
                    log.warn((Object)("Can't fetch database data types: " + e.getMessage()));
                }
                if (CommonUtils.isEmpty((Collection)this.dataTypeCache.getCachedObjects())) {
                    this.dataTypeCache.fillStandardTypes((DBSObject)this);
                }
            }
            try {
                Throwable e = null;
                Object var5_8 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read generic metadata");){
                    JDBCDatabaseMetaData metaData = session.getMetaData();
                    if (!omitCatalog) {
                        monitor.subTask("Extract catalogs");
                        monitor.worked(1);
                        GenericMetaObject catalogObject = this.getMetaObject("catalog");
                        DBSObjectFilter catalogFilters = this.getContainer().getObjectFilter(GenericCatalog.class, null, false);
                        List<String> catalogNames = this.getCatalogsNames(monitor, metaData, catalogObject, catalogFilters);
                        if (!catalogNames.isEmpty() || this.catalogsFiltered) {
                            this.catalogs = new ArrayList<GenericCatalog>();
                            for (String catalogName : catalogNames) {
                                GenericCatalog catalog = this.metaModel.createCatalogImpl(this, catalogName);
                                this.catalogs.add(catalog);
                            }
                        }
                    }
                    if (!CommonUtils.isEmpty(this.catalogs) || this.catalogsFiltered) break block25;
                    monitor.subTask("Extract schemas");
                    monitor.worked(1);
                    try {
                        List<GenericSchema> tmpSchemas = this.metaModel.loadSchemas(session, this, null);
                        if (tmpSchemas != null) {
                            this.schemas = new SimpleObjectCache();
                            this.schemas.setCaseSensitive(this.getSQLDialect().storesUnquotedCase() == DBPIdentifierCase.MIXED);
                            this.schemas.setCache(tmpSchemas);
                        }
                    }
                    catch (Throwable e2) {
                        if (this.metaModel.isSchemasOptional()) {
                            log.warn((Object)"Can't read schema list", e2);
                        }
                        if (e2 instanceof DBException) {
                            throw (DBException)e2;
                        }
                        throw new DBException("Error reading schema list", e2, (DBPDataSource)this);
                    }
                    if (this.isMergeEntities() || this.schemas == null || this.schemas.isEmpty()) {
                        this.structureContainer = new DataSourceObjectContainer();
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (Throwable ex) {
                if (ex instanceof DBException) {
                    throw (DBException)ex;
                }
                throw new DBException("Error reading metadata", ex, (DBPDataSource)this);
            }
        }
    }

    public List<String> getCatalogsNames(@NotNull DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData, GenericMetaObject catalogObject, @Nullable DBSObjectFilter catalogFilters) throws DBException {
        ArrayList<String> catalogNames = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (JDBCResultSet dbResult = metaData.getCatalogs();){
                int totalCatalogs = 0;
                while (dbResult.next()) {
                    String catalogName = GenericUtils.safeGetString(catalogObject, (ResultSet)dbResult, "TABLE_CAT");
                    if (CommonUtils.isEmpty((String)catalogName) && CommonUtils.isEmpty((String)(catalogName = GenericUtils.safeGetStringTrimmed(catalogObject, (ResultSet)dbResult, "TABLE_QUALIFIER")))) continue;
                    ++totalCatalogs;
                    if (catalogFilters == null || catalogFilters.matches(catalogName)) {
                        catalogNames.add(catalogName);
                        monitor.subTask("Extract catalogs - " + catalogName);
                    } else {
                        this.catalogsFiltered = true;
                    }
                    if (monitor.isCanceled()) break;
                }
                if (totalCatalogs == 1 && this.omitSingleCatalog) {
                    catalogNames.clear();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedOperationException | SQLFeatureNotSupportedException e) {
            log.debug((Object)("Catalog list not supported: " + e.getMessage()));
        }
        catch (Throwable e) {
            if (this.metaModel.isCatalogsOptional()) {
                log.warn((Object)"Can't read catalog list", e);
            }
            throw new DBException("Error reading catalog list", e);
        }
        return catalogNames;
    }

    public boolean isOmitCatalog() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("omit-catalog"), (boolean)false);
    }

    public boolean isOmitSchema() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("omit-schema"), (boolean)false);
    }

    public boolean isOmitSingleSchema() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("omit-single-schema"), (boolean)false);
    }

    public boolean isSchemaFiltersEnabled() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("schema-filters-enabled"), (boolean)true);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.structureContainer = null;
        this.tableTypeCache.clearCache();
        this.catalogs = null;
        this.schemas = null;
        this.initialize(monitor);
        return this;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        DBCQueryTransformer transformer;
        if (this.metaModel instanceof DBCQueryTransformProvider && (transformer = ((DBCQueryTransformProvider)this.metaModel).createQueryTransformer(type)) != null) {
            return transformer;
        }
        return super.createQueryTransformer(type);
    }

    GenericTableBase findTable(@NotNull DBRProgressMonitor monitor, String catalogName, String schemaName, String tableName) throws DBException {
        GenericObjectContainer container = null;
        if (!CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty(this.catalogs) && (container = this.getCatalog(catalogName)) == null) {
            log.error((Object)("Catalog " + catalogName + " not found"));
            return null;
        }
        if (!CommonUtils.isEmpty((String)schemaName) && (container = container != null ? ((GenericCatalog)container).getSchema(monitor, schemaName) : (this.schemas != null && !this.schemas.isEmpty() ? this.getSchema(schemaName) : this.structureContainer)) == null) {
            log.debug((Object)("Schema '" + schemaName + "' not found"));
            return null;
        }
        if (container == null) {
            container = this.structureContainer;
        }
        return container.getTable(monitor, tableName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.getCatalogs())) {
            return this.getCatalogs();
        }
        if (!CommonUtils.isEmpty(this.getSchemas())) {
            return this.getSchemas();
        }
        if (this.structureContainer != null) {
            return this.structureContainer.getTables(monitor);
        }
        return null;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        if (!CommonUtils.isEmpty(this.getCatalogs())) {
            return this.getCatalog(childName);
        }
        if (!CommonUtils.isEmpty(this.getSchemas())) {
            return this.getSchema(childName);
        }
        if (this.structureContainer != null) {
            return this.structureContainer.getChild(monitor, childName);
        }
        return null;
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        if (!CommonUtils.isEmpty(this.catalogs)) {
            return GenericCatalog.class;
        }
        if (this.schemas != null && !this.schemas.isEmpty()) {
            return GenericSchema.class;
        }
        return GenericTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        if (!CommonUtils.isEmpty(this.catalogs)) {
            for (GenericCatalog catalog : this.catalogs) {
                catalog.cacheStructure(monitor, scope);
            }
        } else if (!this.schemas.isEmpty()) {
            for (GenericSchema schema : this.schemas.getCachedObjects()) {
                schema.cacheStructure(monitor, scope);
            }
        } else if (this.structureContainer != null) {
            this.structureContainer.cacheStructure(monitor, scope);
        }
    }

    private boolean isChild(DBSObject object) throws DBException {
        if (object instanceof GenericCatalog) {
            return !CommonUtils.isEmpty(this.catalogs) && this.catalogs.contains(object);
        }
        if (object instanceof GenericSchema) {
            return this.schemas != null && !this.schemas.isEmpty() && this.schemas.getCachedObjects().contains(object);
        }
        return false;
    }

    boolean hasCatalogs() {
        return !CommonUtils.isEmpty(this.catalogs);
    }

    boolean hasSchemas() {
        return this.schemas != null && !this.schemas.isEmpty();
    }

    String getQueryGetActiveDB() {
        return this.queryGetActiveDB;
    }

    String getQuerySetActiveDB() {
        return this.querySetActiveDB;
    }

    String getSelectedEntityType() {
        return this.selectedEntityType;
    }

    void setSelectedEntityType(String selectedEntityType) {
        this.selectedEntityType = selectedEntityType;
    }

    boolean isSelectedEntityFromAPI() {
        return this.selectedEntityFromAPI;
    }

    void setSelectedEntityFromAPI(boolean selectedEntityFromAPI) {
        this.selectedEntityFromAPI = selectedEntityFromAPI;
    }

    public boolean isMergeEntities() {
        return this.getContainer().getNavigatorSettings().isMergeEntities();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast((Object)new GenericStructureAssistant(this));
        }
        if (adapter == DBCQueryPlanner.class) {
            if (this.queryPlanner == null) {
                this.queryPlanner = this.metaModel.getQueryPlanner(this);
            }
            return adapter.cast(this.queryPlanner);
        }
        if (adapter == DBDValueHandlerProvider.class && this.metaModel instanceof DBDValueHandlerProvider) {
            return adapter.cast(this.metaModel);
        }
        return (T)super.getAdapter(adapter);
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("catalog".equals(objectType)) {
            term = this.getInfo().getCatalogTerm();
        } else if ("schema".equals(objectType)) {
            term = this.getInfo().getSchemaTerm();
        } else if ("procedure".equals(objectType)) {
            term = this.getInfo().getProcedureTerm();
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        DBPErrorAssistant.ErrorPosition[] errorPositionArray;
        DBPErrorAssistant.ErrorPosition position = this.metaModel.getErrorPosition(error);
        if (position == null) {
            errorPositionArray = null;
        } else {
            DBPErrorAssistant.ErrorPosition[] errorPositionArray2 = new DBPErrorAssistant.ErrorPosition[1];
            errorPositionArray = errorPositionArray2;
            errorPositionArray2[0] = position;
        }
        return errorPositionArray;
    }

    protected JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    @Override
    public Collection<? extends DBSDataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DBSDataType getLocalDataType(int typeID) {
        return this.dataTypeCache.getCachedObject(typeID);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        DBSDataType dataType = this.getLocalDataType(typeName);
        if (dataType != null) {
            return super.resolveDataKind(dataType.getTypeName(), dataType.getTypeID());
        }
        return super.resolveDataKind(typeName, valueType);
    }

    public boolean splitProceduresAndFunctions() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("split-procedures-and-functions"), (boolean)false);
    }

    public Format getNativeFormatTimestamp() {
        return this.nativeFormatTimestamp;
    }

    public Format getNativeFormatTime() {
        return this.nativeFormatTime;
    }

    public Format getNativeFormatDate() {
        return this.nativeFormatDate;
    }

    private Format makeNativeFormat(String paramName) {
        Object param = this.getContainer().getDriver().getDriverParameter(paramName);
        if (param == null) {
            return null;
        }
        try {
            return new ExtendedDateFormat(CommonUtils.toString((Object)param));
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    GenericCatalog getDefaultCatalog() {
        return null;
    }

    GenericSchema getDefaultSchema() {
        if (this.schemas != null) {
            for (GenericSchema schema : this.schemas.getCachedObjects()) {
                if (!schema.isVirtual()) continue;
                return schema;
            }
        }
        return null;
    }

    public boolean supportsCatalogChangeInTransaction() {
        return true;
    }

    private class DataSourceObjectContainer
    extends GenericObjectContainer {
        private DataSourceObjectContainer() {
            super(GenericDataSource.this);
        }

        @Override
        public GenericCatalog getCatalog() {
            return null;
        }

        @Override
        public GenericSchema getSchema() {
            return null;
        }

        @Override
        public GenericStructContainer getObject() {
            return GenericDataSource.this;
        }

        @NotNull
        public Class<? extends DBSEntity> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
            return GenericTable.class;
        }

        @NotNull
        public String getName() {
            return GenericDataSource.this.getName();
        }

        @Nullable
        public String getDescription() {
            return GenericDataSource.this.getDescription();
        }

        public DBSObject getParentObject() {
            return GenericDataSource.this.getParentObject();
        }
    }

    private class TableTypeCache
    extends JDBCObjectCache<GenericDataSource, GenericTableType> {
        private TableTypeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericDataSource owner) throws SQLException {
            return session.getMetaData().getTableTypes().getSourceStatement();
        }

        protected GenericTableType fetchObject(@NotNull JDBCSession session, @NotNull GenericDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new GenericTableType(GenericDataSource.this, GenericUtils.safeGetString(GenericDataSource.this.getMetaObject("table-type"), (ResultSet)resultSet, "TABLE_TYPE"));
        }
    }
}

