/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridCellRenderer
extends AbstractRenderer {
    private static final int LEFT_MARGIN = 6;
    private static final int RIGHT_MARGIN = 6;
    private static final int TOP_MARGIN = 0;
    private static final int TEXT_TOP_MARGIN = 1;
    private static final int INSIDE_MARGIN = 3;
    static final Image LINK_IMAGE = DBeaverIcons.getImage((DBPImage)UIIcon.LINK);
    static final Image LINK2_IMAGE = DBeaverIcons.getImage((DBPImage)UIIcon.LINK2);
    static final Rectangle LINK_IMAGE_BOUNDS = new Rectangle(0, 0, 13, 13);
    private static final boolean USE_CLIPPING = false;
    private static final String[][] SPECIAL_CHARACTERS_MAP = new String[][]{{" ", "\u00b7"}, {"\r\n", "\u00b6"}, {"\r", "\u00b6"}, {"\n", "\u00b6"}, {"\t", "\u00bb"}, {"\u3000", "\u00b0"}, {"\u200b", "\u2588"}};
    protected Color colorLineFocused;

    public GridCellRenderer(LightGrid grid) {
        super(grid);
        this.colorLineFocused = grid.getDisplay().getSystemColor(24);
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, boolean focus, Object col, Object row) {
        Image image;
        boolean drawBackground = true;
        Color back = this.grid.getCellBackground(col, row, selected);
        if (back != null) {
            gc.setBackground(back);
        } else {
            drawBackground = false;
        }
        gc.setForeground(this.grid.getCellForeground(col, row, selected));
        if (drawBackground) {
            gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        String text = this.grid.getCellText(col, row);
        int state = this.grid.getContentProvider().getCellState(col, row, text);
        int x = 6;
        Rectangle imageBounds = null;
        DBPImage cellImage = this.grid.getCellImage(col, row);
        if (cellImage != null) {
            image = DBeaverIcons.getImage((DBPImage)cellImage);
            imageBounds = image.getBounds();
        } else {
            image = null;
        }
        if (image == null && GridCellRenderer.isLinkState(state)) {
            image = (state & 1) != 0 ? LINK_IMAGE : LINK2_IMAGE;
            imageBounds = LINK_IMAGE_BOUNDS;
        }
        int columnAlign = this.grid.getContentProvider().getCellAlign(col, row);
        if (image != null && columnAlign != 2) {
            int y = bounds.y + (bounds.height - imageBounds.height) / 2;
            if (columnAlign == 1) {
                x += (bounds.width - imageBounds.width - 6 - 6) / 2;
            }
            gc.drawImage(image, bounds.x + x, y);
            x += imageBounds.width + 3;
        }
        int width = bounds.width - x - 6;
        String originalText = text;
        if (text != null && !text.isEmpty()) {
            text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)width);
            text = CommonUtils.getSingleLineString((String)text);
            Font font = this.grid.getContentProvider().getCellFont(col, row);
            gc.setFont(font != null ? font : this.grid.normalFont);
            switch (columnAlign) {
                case 1: {
                    Point textSize = gc.textExtent(text);
                    gc.drawString(text, bounds.x + (bounds.width - textSize.x) / 2, bounds.y + 1 + 0, isTransparent);
                    break;
                }
                case 2: {
                    Point textSize = gc.textExtent(text);
                    int valueWidth = textSize.x + 3;
                    if (imageBounds != null) {
                        valueWidth += imageBounds.width + 3;
                    }
                    boolean useClipping = (valueWidth += 6) > bounds.width;
                    int imageMargin = 0;
                    if (image != null) {
                        imageMargin = imageBounds.width + 3;
                        if (useClipping) {
                            gc.setClipping(bounds.x, bounds.y, bounds.width - imageMargin, bounds.height);
                        }
                    } else if (useClipping) {
                        gc.setClipping(bounds);
                    }
                    gc.drawString(text, bounds.x + bounds.width - (textSize.x + 6 + imageMargin), bounds.y + 1 + 0, isTransparent);
                    if (!useClipping) break;
                    gc.setClipping(null);
                    break;
                }
                default: {
                    if (CommonUtils.isBitSet((int)state, (int)16)) {
                        this.drawCellTextDecorated(gc, originalText, col, row, selected, new Rectangle(bounds.x + x, bounds.y + 1 + 0, bounds.width - 6 - 6, bounds.height));
                        break;
                    }
                    gc.drawString(text, bounds.x + x, bounds.y + 1 + 0, isTransparent);
                }
            }
        }
        if (image != null && columnAlign == 2) {
            int y = bounds.y + (bounds.height - imageBounds.height) / 2;
            gc.drawImage(image, bounds.x + bounds.width - imageBounds.width - 6, y);
        }
        if (focus) {
            gc.setForeground(this.colorLineFocused);
            gc.drawRectangle(bounds.x + 1, bounds.y, bounds.width - 2, bounds.height - 1);
            if (this.grid.isFocusControl()) {
                gc.drawRectangle(bounds.x + 2, bounds.y + 1, bounds.width - 4, bounds.height - 3);
            }
        }
    }

    boolean isOverLink(GridColumn column, int row, int x, int y) {
        boolean isToggle;
        Object rowElement;
        Object colElement;
        IGridContentProvider contentProvider = this.grid.getContentProvider();
        int state = contentProvider.getCellState(colElement = column.getElement(), rowElement = this.grid.getRowElement(row), null);
        boolean bl = isToggle = (state & 8) != 0;
        if (isToggle && contentProvider.isElementReadOnly(colElement)) {
            return false;
        }
        if (GridCellRenderer.isLinkState(state) || isToggle) {
            Rectangle imageBounds;
            int columnAlign = contentProvider.getCellAlign(colElement, rowElement);
            Point origin = this.grid.getOrigin(column, row);
            if (isToggle) {
                String cellText = this.grid.getCellText(colElement, rowElement);
                Point textSize = this.grid.sizingGC.textExtent(cellText);
                imageBounds = new Rectangle(0, 0, textSize.x, textSize.y);
            } else {
                DBPImage cellImage = this.grid.getCellImage(colElement, rowElement);
                Image image = cellImage == null ? ((state & 1) != 0 ? LINK_IMAGE : LINK2_IMAGE) : DBeaverIcons.getImage((DBPImage)cellImage);
                imageBounds = image.getBounds();
            }
            int verMargin = (this.grid.getItemHeight() - imageBounds.height) / 2;
            switch (columnAlign) {
                case 0: {
                    if (x < origin.x + 6 || x > origin.x + 6 + imageBounds.width || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
                case 2: {
                    int width = column.getWidth();
                    if (x < origin.x + width - (6 + imageBounds.width) || x > origin.x + width - 6 || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
                case 1: {
                    int leftIndent = (column.getWidth() - imageBounds.width - 6 - 6) / 2;
                    if (x < origin.x + 6 + leftIndent || x > origin.x + 6 + leftIndent + imageBounds.width || y < origin.y + verMargin || y > origin.y + verMargin + imageBounds.height) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLinkState(int state) {
        return (state & 1) != 0 || (state & 2) != 0;
    }

    private void drawCellTextDecorated(@NotNull GC gc, @NotNull String text, @Nullable Object col, @Nullable Object row, boolean selected, @NotNull Rectangle bounds) {
        Color activeForeground = this.grid.getCellForeground(col, row, selected);
        Color activeBackground = this.grid.getCellBackground(col, row, selected);
        Color disabledForeground = UIUtils.getSharedColor((RGB)UIUtils.blend((RGB)activeForeground.getRGB(), (RGB)activeBackground.getRGB(), (int)50));
        int start = 0;
        while (start < text.length()) {
            boolean matches = false;
            String[][] stringArray = SPECIAL_CHARACTERS_MAP;
            int n = SPECIAL_CHARACTERS_MAP.length;
            int n2 = 0;
            while (n2 < n) {
                String[] mapping = stringArray[n2];
                String expected = mapping[0];
                String replacement = mapping[1];
                int index = text.indexOf(expected, start);
                if (index >= 0) {
                    if (this.drawCellTextSegment(gc, text.substring(start, index), bounds, activeForeground, disabledForeground)) {
                        return;
                    }
                    if (this.drawCellTextSegment(gc, replacement, bounds, disabledForeground, disabledForeground)) {
                        return;
                    }
                    start = index + expected.length();
                    matches = true;
                }
                ++n2;
            }
            if (matches) continue;
            this.drawCellTextSegment(gc, text.substring(start), bounds, activeForeground, disabledForeground);
            return;
        }
    }

    private boolean drawCellTextSegment(@NotNull GC gc, @NotNull String segment, @NotNull Rectangle bounds, @NotNull Color activeForeground, @NotNull Color disabledForeground) {
        Point extent = gc.textExtent(segment);
        if (extent.x > bounds.width) {
            int low = 0;
            int high = segment.length();
            String clipped = segment;
            while (low <= high) {
                int mid = low + high >>> 1;
                clipped = segment.substring(0, mid);
                int val = gc.textExtent((String)new StringBuilder((String)String.valueOf((Object)clipped)).append((String)"...").toString()).x;
                if (val < bounds.width) {
                    low = mid + 1;
                    continue;
                }
                if (val <= bounds.width) break;
                high = mid - 1;
            }
            this.drawTextAndAdvance(gc, clipped, activeForeground, bounds);
            this.drawTextAndAdvance(gc, "...", disabledForeground, bounds);
            return true;
        }
        this.drawTextAndAdvance(gc, segment, activeForeground, bounds);
        return false;
    }

    private void drawTextAndAdvance(@NotNull GC gc, @NotNull String text, @NotNull Color foreground, @NotNull Rectangle bounds) {
        gc.setForeground(foreground);
        gc.drawString(text, bounds.x, bounds.y);
        int extent = gc.textExtent((String)text).x + 1;
        bounds.x += extent;
        bounds.width -= extent;
    }
}

