/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.generic;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreGenericDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreGenericTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreGenericTypeCache;
import org.jkiss.dbeaver.ext.postgresql.model.generic.PostgreGenericQueryPlaner;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class PostgreMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("\\n\\s*Position: ([0-9]+)");

    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new PostgreGenericDataSource(monitor, container, this);
    }

    public JDBCBasicDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new PostgreGenericTypeCache(container);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Read view definition");){
                return JDBCUtils.queryString((Connection)session, (String)"SELECT definition FROM PG_CATALOG.PG_VIEWS WHERE SchemaName=? and ViewName=?", (Object[])new Object[]{((GenericStructContainer)sourceObject.getContainer()).getName(), sourceObject.getName()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, sourceObject.getDataSource());
        }
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Read procedure definition");){
                return JDBCUtils.queryString((Connection)session, (String)"SELECT pg_get_functiondef(p.oid) FROM PG_CATALOG.PG_PROC P, PG_CATALOG.PG_NAMESPACE NS\nWHERE ns.oid=p.pronamespace and ns.nspname=? AND p.proname=?", (Object[])new Object[]{((GenericStructContainer)sourceObject.getContainer()).getName(), sourceObject.getName()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, sourceObject.getDataSource());
        }
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        Version databaseVersion = dataSource.getInfo().getDatabaseVersion();
        return databaseVersion.getMajor() >= 9 || databaseVersion.getMajor() == 8 && databaseVersion.getMinor() >= 4;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    /*
     * Loose catch block
     */
    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        Version databaseVersion = container.getDataSource().getInfo().getDatabaseVersion();
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        String sequenceSql = "SELECT last_value,min_value,max_value,increment_by from " + container.getName() + "." + name;
        if (databaseVersion.getMajor() >= 10) {
            sequenceSql = "SELECT last_value, min_value, max_value, increment_by from pg_catalog.pg_sequences where schemaname=? and sequencename=?";
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (JDBCPreparedStatement dbSeqStat = session.prepareStatement(sequenceSql);){
                GenericSequence genericSequence;
                JDBCResultSet seqResults;
                Throwable throwable2;
                block24: {
                    if (databaseVersion.getMajor() >= 10) {
                        dbSeqStat.setString(1, container.getName());
                        dbSeqStat.setString(2, dbResult.getString(1));
                    }
                    throwable2 = null;
                    Object var11_15 = null;
                    seqResults = dbSeqStat.executeQuery();
                    seqResults.next();
                    genericSequence = new GenericSequence(container, name, PostgreUtils.getObjectComment(session.getProgressMonitor(), container, container.getName(), name), (Number)JDBCUtils.safeGetLong((ResultSet)seqResults, (int)1), (Number)JDBCUtils.safeGetLong((ResultSet)seqResults, (int)2), (Number)JDBCUtils.safeGetLong((ResultSet)seqResults, (int)3), (Number)JDBCUtils.safeGetLong((ResultSet)seqResults, (int)4));
                    if (seqResults == null) break block24;
                    seqResults.close();
                }
                return genericSequence;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (seqResults != null) {
                                seqResults.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer, @Nullable GenericTableBase table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT trigger_name, event_object_table as OWNER, event_manipulation,action_order,action_condition,action_statement,action_orientation,action_timing\nFROM INFORMATION_SCHEMA.TRIGGERS\nWHERE ");
        if (table == null) {
            sql.append("trigger_schema=?");
        } else {
            sql.append("event_object_schema=? AND event_object_table=?");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
        if (table == null) {
            dbStat.setString(1, genericStructContainer.getName());
        } else {
            dbStat.setString(1, table.getSchema().getName());
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    public GenericTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer genericStructContainer, @NotNull GenericTableBase genericTableBase, String name, @NotNull JDBCResultSet dbResult) throws DBException {
        if (CommonUtils.isEmpty((String)name)) {
            name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"trigger_name");
        }
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        String manipulation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"event_manipulation");
        String description = "";
        return new PostgreGenericTrigger(genericStructContainer, genericTableBase, name, description, manipulation, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_orientation"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_timing"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_statement"));
    }

    /*
     * Loose catch block
     */
    public List<PostgreGenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<PostgreGenericTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block37: {
                    StringBuilder sql = new StringBuilder();
                    sql.append("SELECT trigger_name,event_manipulation,action_order,action_condition,action_statement,action_orientation,action_timing\nFROM INFORMATION_SCHEMA.TRIGGERS\nWHERE ");
                    if (table == null) {
                        sql.append("trigger_schema=? AND event_object_table IS NULL");
                    } else {
                        sql.append("event_object_schema=? AND event_object_table=?");
                    }
                    throwable2 = null;
                    Object var9_13 = null;
                    dbStat = session.prepareStatement(sql.toString());
                    if (table == null) {
                        dbStat.setString(1, container.getSchema().getName());
                    } else {
                        dbStat.setString(1, table.getSchema().getName());
                        dbStat.setString(2, table.getName());
                    }
                    LinkedHashMap<String, PostgreGenericTrigger> result = new LinkedHashMap<String, PostgreGenericTrigger>();
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"trigger_name");
                            if (name == null) continue;
                            String manipulation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"event_manipulation");
                            PostgreGenericTrigger trigger = (PostgreGenericTrigger)((Object)result.get(name));
                            if (trigger != null) {
                                trigger.addManipulation(manipulation);
                                continue;
                            }
                            String description = "";
                            trigger = new PostgreGenericTrigger(container, table, name, description, manipulation, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_orientation"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_timing"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_statement"));
                            result.put(name, trigger);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = new ArrayList<PostgreGenericTrigger>(result.values());
                    if (dbStat == null) break block37;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return null;
    }

    public DBCQueryPlanner getQueryPlanner(@NotNull GenericDataSource dataSource) {
        return new PostgreGenericQueryPlaner(dataSource);
    }

    public DBPErrorAssistant.ErrorPosition getErrorPosition(@NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = this.ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.position = Integer.parseInt(matcher.group(1)) - 1;
            return pos;
        }
        return null;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }
}

