/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNodeVisitor;

public class SQLTokenEntry
extends TokenPredicateNode
implements TokenEntry {
    private final String string;
    private final SQLTokenType type;

    public SQLTokenEntry(@Nullable String string, @Nullable SQLTokenType type) {
        this.string = string;
        this.type = type;
    }

    @Nullable
    public String getString() {
        return this.string;
    }

    @Nullable
    public Enum getTokenType() {
        return this.type;
    }

    public boolean matches(@NotNull TokenEntry other) {
        boolean typeMatches;
        boolean stringMatches = this.getString() == null || other.getString() == null || this.string.equalsIgnoreCase(other.getString());
        boolean bl = typeMatches = this.getTokenType() == null || other.getTokenType() == null || this.type.equals(other.getTokenType());
        return stringMatches && typeMatches;
    }

    public boolean equals(@NotNull TokenEntry other) {
        boolean typeEquals;
        boolean stringEquals = this.getString() == null && other.getString() == null || this.getString() != null && other.getString() != null && this.getString().equals(other.getString());
        boolean bl = typeEquals = this.getTokenType() == null && other.getTokenType() == null || this.getTokenType() != null && other.getTokenType() != null && this.getTokenType().equals(other.getTokenType());
        return stringEquals && typeEquals;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof TokenEntry && this.equals((TokenEntry)o);
    }

    public int hashCode() {
        return Objects.hash(this.getString(), this.getTokenType());
    }

    @NotNull
    public StringBuilder format(@NotNull StringBuilder sb) {
        return sb.append("<").append(this.type != null ? this.type.name() : "?").append(">").append(this.string != null ? "'" + this.string + "'" : "any");
    }

    @Override
    @NotNull
    protected <T, R> R applyImpl(@NotNull TokenPredicateNodeVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTokenEntry(this, arg);
    }
}

