/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterJSON
extends StreamExporterAbstract
implements IDocumentDataExporter {
    public static final String PROP_FORMAT_DATE_ISO = "formatDateISO";
    public static final String PROP_PRINT_TABLE_NAME = "printTableName";
    private DBDAttributeBinding[] columns;
    private String tableName;
    private int rowNum = 0;
    private boolean printTableName = true;
    private boolean formatDateISO = true;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.formatDateISO = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_FORMAT_DATE_ISO), (boolean)true);
        this.printTableName = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_PRINT_TABLE_NAME), (boolean)true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.tableName = this.getSite().getSource().getName();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        if (this.printTableName) {
            out.write("{\n");
            out.write("\"" + JSONUtils.escapeJsonString((String)this.tableName) + "\": ");
        }
        out.write("[\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        out = this.getWriter();
        if (this.rowNum > 0) {
            out.write(",\n");
        }
        ++this.rowNum;
        if (this.isJsonDocumentResults(row)) {
            document = (DBDDocument)row[0];
            buffer = new ByteArrayOutputStream();
            document.serializeDocument(session.getProgressMonitor(), (OutputStream)buffer, StandardCharsets.UTF_8);
            jsonText = buffer.toString(StandardCharsets.UTF_8.name());
            out.write(jsonText);
        } else {
            out.write("\t{\n");
            i = 0;
            while (i < this.columns.length) {
                column = this.columns[i];
                columnName = column.getLabel();
                if (CommonUtils.isEmpty((String)columnName)) {
                    columnName = column.getName();
                }
                out.write("\t\t\"" + JSONUtils.escapeJsonString((String)columnName) + "\" : ");
                cellValue = row[column.getOrdinalPosition()];
                if (DBUtils.isNullValue((Object)cellValue)) {
                    this.writeTextCell(null);
                } else if (cellValue instanceof DBDContent) {
                    content = (DBDContent)cellValue;
                    try {
                        cs = content.getContents(session.getProgressMonitor());
                        if (cs == null) ** GOTO lbl62
                        if (ContentUtils.isTextContent((DBDContent)content)) {
                            var11_14 = null;
                            var12_16 = null;
                            try {
                                in = cs.getContentReader();
                                try {
                                    out.write("\"");
                                    this.writeCellValue(in);
                                    out.write("\"");
                                }
                                finally {
                                    if (in != null) {
                                        in.close();
                                    }
                                }
                            }
                            catch (Throwable var12_17) {
                                if (var11_14 == null) {
                                    var11_14 = var12_17;
                                } else if (var11_14 != var12_17) {
                                    var11_14.addSuppressed(var12_17);
                                }
                                throw var11_14;
                            }
                        }
                        this.getSite().writeBinaryData(cs);
                    }
                    finally {
                        content.release();
                    }
                } else if (cellValue instanceof Number || cellValue instanceof Boolean) {
                    out.write(cellValue.toString());
                } else if (cellValue instanceof Date && this.formatDateISO) {
                    this.writeTextCell(JSONUtils.formatDate((Date)((Date)cellValue)));
                } else {
                    this.writeTextCell(super.getValueDisplayString(column, cellValue));
                }
lbl62:
                // 7 sources

                if (i < this.columns.length - 1) {
                    out.write(",");
                }
                out.write("\n");
                ++i;
            }
            out.write("\t}");
        }
    }

    private boolean isJsonDocumentResults(@NotNull Object[] row) {
        if (!ArrayUtils.isEmpty((Object[])this.columns)) {
            DBPDataKind dataKind = this.columns[0].getDataKind();
            if (this.columns.length == 1 && (dataKind == DBPDataKind.DOCUMENT || dataKind == DBPDataKind.STRUCT) && row.length > 0 && !DBUtils.isNullValue((Object)row[0]) && row[0] instanceof DBDDocument) {
                DBDDocument document = (DBDDocument)row[0];
                return "text/json".equalsIgnoreCase(document.getDocumentContentType());
            }
        }
        return false;
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        PrintWriter out = this.getWriter();
        out.write("\n]");
        if (this.printTableName) {
            out.write("}");
        }
        out.write("\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            this.getWriter().write("\"" + JSONUtils.escapeJsonString((String)value) + "\"");
        } else {
            this.getWriter().write("null");
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            this.getWriter().write(JSONUtils.escapeJsonString((String)new String(buffer, 0, count)));
        }
    }
}

