/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.qm;

import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.qm.QMEventCriteria;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;

public class DefaultEventFilter
implements QMEventFilter {
    private QMEventCriteria eventCriteria = new QMEventCriteria();

    public DefaultEventFilter() {
        this.reloadPreferences();
    }

    public void reloadPreferences() {
        this.eventCriteria = QMUtils.createDefaultCriteria(ModelPreferences.getPreferences());
    }

    @Override
    public boolean accept(QMMetaEvent event) {
        QMMObject object = event.getObject();
        if (object instanceof QMMStatementExecuteInfo) {
            return this.eventCriteria.hasObjectType(QMObjectType.query) && this.eventCriteria.hasQueryType(((QMMStatementExecuteInfo)object).getStatement().getPurpose());
        }
        if (object instanceof QMMTransactionInfo || object instanceof QMMTransactionSavepointInfo) {
            return this.eventCriteria.hasObjectType(QMObjectType.txn);
        }
        if (object instanceof QMMConnectionInfo) {
            return this.eventCriteria.hasObjectType(QMObjectType.session);
        }
        return true;
    }
}

