/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.Log;

public abstract class QMMObject {
    static final Log log = Log.getLog(QMMObject.class);
    private static int globalObjectId = 0;
    private final long objectId = QMMObject.generateObjectId();
    private final long openTime;
    private long closeTime;
    private boolean synced;
    private boolean updated;

    public QMMObject() {
        this.openTime = QMMObject.getTimeStamp();
    }

    protected QMMObject(long openTime, long closeTime) {
        this.openTime = openTime;
        this.closeTime = closeTime;
    }

    protected void close() {
        this.closeTime = QMMObject.getTimeStamp();
        this.update();
    }

    protected void reopen() {
        this.closeTime = 0L;
        this.update();
    }

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public boolean isClosed() {
        return this.closeTime > 0L;
    }

    public abstract String getText();

    protected synchronized void update() {
        this.updated = true;
    }

    protected synchronized void sync() {
        this.synced = true;
        this.updated = false;
    }

    private static synchronized long generateObjectId() {
        return ++globalObjectId;
    }

    protected static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public long getDuration() {
        if (!this.isClosed()) {
            return -1L;
        }
        return this.getCloseTime() - this.getOpenTime();
    }
}

