/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorNested;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;

public class SQLSourceViewer<T extends DBPScriptObject & DBSObject>
extends SQLEditorNested<T> {
    protected Boolean showPermissions;
    protected Boolean showColumnComments;
    protected Boolean showFullDDL;
    private IAction OPEN_CONSOLE_ACTION = new Action("Open in SQL console", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)){

        public void run() {
            String sqlText = SQLSourceViewer.this.getDocument().get();
            ISelection selection = SQLSourceViewer.this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection && ((TextSelection)selection).getLength() > 0) {
                sqlText = ((TextSelection)selection).getText();
            }
            DBPDataSource dataSource = SQLSourceViewer.this.getDataSource();
            String consoleName = SQLSourceViewer.this.getSourceViewerType();
            DBPScriptObject sourceObject = (DBPScriptObject)SQLSourceViewer.this.getSourceObject();
            if (sourceObject != null) {
                consoleName = String.valueOf(consoleName) + " of <" + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)sourceObject), (DBPEvaluationContext)DBPEvaluationContext.UI) + ">";
            }
            SQLEditorHandlerOpenEditor.openSQLConsole(UIUtils.getActiveWorkbenchWindow(), new SQLNavigatorContext((DBSObject)dataSource), consoleName, sqlText);
        }
    };

    protected String getSourceViewerType() {
        return "DDL";
    }

    @Override
    protected String getSourceText(DBRProgressMonitor monitor) throws DBException {
        return ((DBPScriptObject)this.getSourceObject()).getObjectDefinitionText(monitor, this.getSourceOptions());
    }

    protected Map<String, Object> getSourceOptions() {
        DBPScriptObject genObject;
        IEditorInput editorInput = this.getEditorInput();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (editorInput instanceof IDatabaseEditorInput) {
            Collection attributeNames = ((IDatabaseEditorInput)editorInput).getAttributeNames();
            options.put("ddl.source", true);
            if (!attributeNames.isEmpty()) {
                for (String name : attributeNames) {
                    Object attribute = ((IDatabaseEditorInput)editorInput).getAttribute(name);
                    options.put(name, attribute);
                }
            }
        }
        if ((genObject = (DBPScriptObject)this.getSourceObject()) instanceof DBPScriptObjectExt2) {
            DBPScriptObjectExt2 sourceObject = (DBPScriptObjectExt2)genObject;
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeNestedObjects")) {
                options.put("ddl.includeNestedObjects", this.getShowFullDDL());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePermissions")) {
                options.put("ddl.includePermissions", this.getShowPermissions());
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeComments")) {
                options.put("ddl.includeComments", this.getShowColumnComments());
            }
        }
        return options;
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
    }

    @Override
    protected void contributeEditorCommands(IContributionManager toolBarManager) {
        super.contributeEditorCommands(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.OPEN_CONSOLE_ACTION);
        DBPScriptObject genObject = (DBPScriptObject)this.getSourceObject();
        if (genObject instanceof DBPScriptObjectExt2) {
            DBPScriptObjectExt2 sourceObject = (DBPScriptObjectExt2)genObject;
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeNestedObjects")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show full DDL", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE_EXTERNAL));
                        this.setToolTipText("Show DDL for all schema objects");
                        this.setChecked(SQLSourceViewer.this.getShowFullDDL());
                    }

                    public void run() {
                        SQLSourceViewer.this.showFullDDL = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includeNestedObjects", SQLSourceViewer.this.showFullDDL.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includePermissions")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show permissions", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PERMISSIONS));
                        this.setToolTipText("Shows object permission grants");
                        this.setChecked(SQLSourceViewer.this.getShowPermissions());
                    }

                    public void run() {
                        SQLSourceViewer.this.showPermissions = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includePermissions", SQLSourceViewer.this.showPermissions.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
            if (sourceObject.supportsObjectDefinitionOption("ddl.includeComments")) {
                toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show comments", 2){
                    {
                        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_TEXT));
                        this.setToolTipText("Show column comments in table definition");
                        this.setChecked(SQLSourceViewer.this.getShowColumnComments());
                    }

                    public void run() {
                        SQLSourceViewer.this.showColumnComments = this.isChecked();
                        SQLSourceViewer.this.getPreferenceStore().setValue("ddl.includeComments", SQLSourceViewer.this.showColumnComments.booleanValue());
                        SQLSourceViewer.this.refreshPart((Object)SQLSourceViewer.this, true);
                    }
                }, (boolean)true));
            }
        }
    }

    protected boolean getShowPermissions() {
        if (this.showPermissions == null) {
            this.showPermissions = this.getPreferenceStore().getBoolean("ddl.includePermissions");
        }
        return this.showPermissions;
    }

    protected Boolean getShowColumnComments() {
        if (this.showColumnComments == null) {
            this.showColumnComments = this.getPreferenceStore().getBoolean("ddl.includeComments");
        }
        return this.showColumnComments;
    }

    protected Boolean getShowFullDDL() {
        if (this.showFullDDL == null) {
            this.showFullDDL = this.getPreferenceStore().getBoolean("ddl.includeNestedObjects");
        }
        return this.showFullDDL;
    }
}

