/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableColumn;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class FireBirdTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn>,
DBEObjectReorderer<GenericTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<GenericTableColumn> ComputedModifier = (monitor, column, sql, command) -> {
        String definition = ((FireBirdTableColumn)column).getComputedDefinition();
        if (CommonUtils.isNotEmpty((String)definition)) {
            sql.append(" GENERATED ALWAYS AS ").append(definition);
        }
    };

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        String autoIncrementClause;
        StringBuilder decl = super.getNestedDeclaration(monitor, owner, command, options);
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        if (column.isAutoIncrement() && (autoIncrementClause = column.getDataSource().getMetaModel().getAutoIncrementClause(column)) != null && !autoIncrementClause.isEmpty()) {
            decl.append(" ").append(autoIncrementClause);
        }
        return decl;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        if (CommonUtils.isNotEmpty((String)((FireBirdTableColumn)column).getComputedDefinition())) {
            return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.ComputedModifier};
        }
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.DefaultModifier, this.NotNullModifier};
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        FireBirdTableColumn column = (FireBirdTableColumn)command.getObject();
        String prefix = "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)column) + " ";
        String typeClause = column.getFullTypeName();
        String computedDefinition = column.getComputedDefinition(monitor);
        if (command.getProperty((Object)"typeName") != null || command.getProperty((Object)"maxLength") != null || command.getProperty((Object)"precision") != null || command.getProperty((Object)"scale") != null) {
            StringBuilder ddl = new StringBuilder().append(prefix).append("TYPE ").append(typeClause);
            if (CommonUtils.isNotEmpty((String)computedDefinition)) {
                ddl.append(" GENERATED ALWAYS AS ").append(computedDefinition);
            }
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column type", ddl.toString()));
        }
        if (command.getProperty((Object)"defaultValue") != null) {
            if (CommonUtils.isEmpty((String)column.getDefaultValue())) {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Drop column default", String.valueOf(prefix) + "DROP DEFAULT"));
            } else {
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column default", String.valueOf(prefix) + "SET DEFAULT " + column.getDefaultValue()));
            }
        }
        if (command.getProperty((Object)"computedDefinition") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column computed definition", String.valueOf(prefix) + "TYPE " + typeClause + " GENERATED ALWAYS AS (" + computedDefinition + ")"));
        }
        if (command.getProperty((Object)"description") != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)column.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)CommonUtils.notEmpty((String)column.getDescription()))));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)column.getTable()) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectReorderActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectReorderCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Reorder column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((GenericTableColumn)command.getObject()).getTable()) + " ALTER COLUMN " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " POSITION " + column.getOrdinalPosition()));
    }

    public int getMinimumOrdinalPosition(GenericTableColumn object) {
        return 1;
    }

    public int getMaximumOrdinalPosition(GenericTableColumn object) {
        try {
            return ((GenericTableBase)object.getTable()).getAttributes((DBRProgressMonitor)new VoidProgressMonitor()).size();
        }
        catch (DBException e) {
            log.error((Object)"Error reading columns for maximum order position", (Throwable)e);
            return 0;
        }
    }

    public void setObjectOrdinalPosition(DBECommandContext commandContext, GenericTableColumn object, List<GenericTableColumn> siblingObjects, int newPosition) throws DBException {
        this.processObjectReorder(commandContext, (DBSObject)object, siblingObjects, newPosition);
    }
}

