/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.AbstractCommandContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class DatabaseTransferUtils {
    private static final Log log = Log.getLog(DatabaseTransferUtils.class);
    private static final boolean USE_STRUCT_DDL = true;
    private static final Pair<DBPDataKind, String> DATA_TYPE_UNKNOWN = new Pair((Object)DBPDataKind.UNKNOWN, null);
    private static final Pair<DBPDataKind, String> DATA_TYPE_INTEGER = new Pair((Object)DBPDataKind.NUMERIC, (Object)"INTEGER");
    private static final Pair<DBPDataKind, String> DATA_TYPE_REAL = new Pair((Object)DBPDataKind.NUMERIC, (Object)"REAL");
    private static final Pair<DBPDataKind, String> DATA_TYPE_BOOLEAN = new Pair((Object)DBPDataKind.BOOLEAN, (Object)"BOOLEAN");
    private static final Pair<DBPDataKind, String> DATA_TYPE_STRING = new Pair((Object)DBPDataKind.STRING, (Object)"VARCHAR");

    public static void refreshDatabaseModel(DBRProgressMonitor monitor, DatabaseConsumerSettings consumerSettings, DatabaseMappingContainer containerMapping) throws DBException {
        DBSObjectContainer container = consumerSettings.getContainer();
        if (container == null) {
            throw new DBException("Null target container");
        }
        monitor.subTask("Refresh navigator model");
        consumerSettings.getContainerNode().refreshNode(monitor, (Object)containerMapping);
        switch (containerMapping.getMappingType()) {
            case create: {
                DBSObject newTarget = container.getChild(monitor, DBUtils.getUnQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)containerMapping.getTargetName()));
                if (newTarget == null) {
                    throw new DBCException("New table " + containerMapping.getTargetName() + " not found in container " + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
                }
                if (!(newTarget instanceof DBSDataManipulator)) {
                    throw new DBCException("New table " + DBUtils.getObjectFullName((DBPNamedObject)newTarget, (DBPEvaluationContext)DBPEvaluationContext.UI) + " doesn't support data manipulation");
                }
                containerMapping.setTarget((DBSDataManipulator)newTarget);
                containerMapping.setMappingType(DatabaseMappingType.existing);
            }
            case existing: {
                for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                    if (attr.getMappingType() != DatabaseMappingType.create) continue;
                    attr.updateMappingType(monitor, false);
                    if (attr.getTarget() != null) continue;
                    log.debug((Object)("Can't find target attribute '" + attr.getTargetName() + "' in '" + containerMapping.getTargetName() + "'"));
                }
                break;
            }
        }
    }

    public static DBEPersistAction[] generateTargetTableDDL(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer schema, DatabaseMappingContainer containerMapping) throws DBException {
        if (containerMapping.getMappingType() == DatabaseMappingType.skip) {
            return new DBEPersistAction[0];
        }
        monitor.subTask("Create table '" + containerMapping.getTargetName() + "'");
        DBEPersistAction[] ddl = DatabaseTransferUtils.generateStructTableDDL(monitor, executionContext, schema, containerMapping);
        if (ddl != null) {
            return ddl;
        }
        DBPDataSource dataSource = executionContext.getDataSource();
        StringBuilder sql = new StringBuilder(500);
        String tableName = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)containerMapping.getTargetName());
        containerMapping.setTargetName(tableName);
        ArrayList<Object> actions = new ArrayList<Object>();
        if (containerMapping.getMappingType() == DatabaseMappingType.create) {
            List identifier;
            sql.append("CREATE TABLE ");
            if (schema instanceof DBSSchema || schema instanceof DBSCatalog) {
                sql.append(DBUtils.getQuotedIdentifier((DBSObject)schema));
                sql.append(dataSource.getSQLDialect().getCatalogSeparator());
            }
            sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)tableName)).append("(\n");
            HashMap<DBSAttributeBase, DatabaseMappingAttribute> mappedAttrs = new HashMap<DBSAttributeBase, DatabaseMappingAttribute>();
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                if (!mappedAttrs.isEmpty()) {
                    sql.append(",\n");
                }
                sql.append("\t");
                DatabaseTransferUtils.appendAttributeClause(dataSource, sql, attr);
                mappedAttrs.put(attr.getSource(), attr);
            }
            if (containerMapping.getSource() instanceof DBSEntity && !CommonUtils.isEmpty((Collection)(identifier = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)containerMapping.getSource()))))) {
                boolean idMapped = true;
                for (DBSEntityAttribute idAttr : identifier) {
                    if (mappedAttrs.containsKey(idAttr)) continue;
                    idMapped = false;
                    break;
                }
                if (idMapped) {
                    sql.append(",\n\tPRIMARY KEY (");
                    boolean hasAttr = false;
                    for (DBSEntityAttribute idAttr : identifier) {
                        DatabaseMappingAttribute mappedAttr = (DatabaseMappingAttribute)mappedAttrs.get(idAttr);
                        if (hasAttr) {
                            sql.append(",");
                        }
                        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)mappedAttr.getTargetName()));
                        hasAttr = true;
                    }
                    sql.append(")\n");
                }
            }
            sql.append(")");
            actions.add(new SQLDatabasePersistAction("Table DDL", sql.toString()));
        } else {
            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                actions.add(DatabaseTransferUtils.generateTargetAttributeDDL(dataSource, attr));
            }
        }
        return actions.toArray(new DBEPersistAction[0]);
    }

    private static DBEPersistAction[] generateStructTableDDL(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer schema, DatabaseMappingContainer containerMapping) {
        DBERegistry editorsRegistry = executionContext.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        try {
            String tableFinalName;
            DBSEntity table;
            SQLObjectEditor attributeManager;
            Class attrClass;
            Class tableClass = schema.getPrimaryChildType(monitor);
            if (!DBSEntity.class.isAssignableFrom(tableClass)) {
                throw new DBException("Wrong table container child type: " + tableClass.getName());
            }
            SQLObjectEditor tableManager = (SQLObjectEditor)editorsRegistry.getObjectManager(tableClass, SQLObjectEditor.class);
            if (tableManager == null) {
                throw new DBException("Table manager not found for '" + tableClass.getName() + "'");
            }
            if (executionContext.getDataSource().getInfo().isDynamicMetadata()) {
                attrClass = null;
                attributeManager = null;
            } else {
                if (!(tableManager instanceof DBEStructEditor)) {
                    throw new DBException("Table create not supported by " + executionContext.getDataSource().getContainer().getDriver().getName());
                }
                Class[] childTypes = ((DBEStructEditor)tableManager).getChildTypes();
                attrClass = BeanUtils.findAssignableType((Class[])childTypes, DBSEntityAttribute.class);
                if (attrClass == null) {
                    throw new DBException("Column manager not found for '" + tableClass.getName() + "'");
                }
                attributeManager = (SQLObjectEditor)editorsRegistry.getObjectManager(attrClass, SQLObjectEditor.class);
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("skip.object.configuration", true);
            TargetCommandContext commandContext = new TargetCommandContext(executionContext);
            SQLObjectEditor.ObjectCreateCommand createCommand = null;
            if (containerMapping.getMappingType() == DatabaseMappingType.create) {
                table = (DBSEntity)tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)schema, null, options);
                tableFinalName = DBObjectNameCaseTransformer.transformName((DBPDataSource)table.getDataSource(), (String)containerMapping.getTargetName());
                if (!(table instanceof DBPNamedObject2)) {
                    throw new DBException("Table name cannot be set for " + tableClass.getName());
                }
                ((DBPNamedObject2)table).setName(tableFinalName);
                createCommand = tableManager.makeCreateCommand((DBSObject)table, options);
            } else {
                table = (DBSEntity)containerMapping.getTarget();
                if (table == null) {
                    throw new DBException("Internal error - target table not set");
                }
                tableFinalName = table.getName();
            }
            if (attributeManager != null) {
                for (DatabaseMappingAttribute attributeMapping : containerMapping.getAttributeMappings(monitor)) {
                    if (attributeMapping.getMappingType() != DatabaseMappingType.create) continue;
                    DBSEntityAttribute newAttribute = (DBSEntityAttribute)attributeManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)table, null, options);
                    if (!(newAttribute instanceof DBPNamedObject2)) {
                        throw new DBException("Table column name cannot be set for " + attrClass.getName());
                    }
                    ((DBPNamedObject2)newAttribute).setName(DBObjectNameCaseTransformer.transformName((DBPDataSource)newAttribute.getDataSource(), (String)attributeMapping.getTargetName()));
                    if (newAttribute instanceof DBSTypedObjectExt2) {
                        DBSAttributeBase sourceAttr;
                        DBSTypedObjectExt2 typedAttr = (DBSTypedObjectExt2)newAttribute;
                        boolean typeModifiersSet = false;
                        if (typedAttr instanceof DBSTypedObjectExt3) {
                            String fullTargetTypeName = attributeMapping.getTargetType(executionContext.getDataSource(), true);
                            typeModifiersSet = fullTargetTypeName.contains("(");
                            ((DBSTypedObjectExt3)typedAttr).setFullTypeName(fullTargetTypeName);
                        } else {
                            String targetAttrType = attributeMapping.getTargetType(executionContext.getDataSource(), false);
                            typedAttr.setTypeName(targetAttrType);
                        }
                        if (!typeModifiersSet && (sourceAttr = attributeMapping.getSource()) != null) {
                            typedAttr.setMaxLength(sourceAttr.getMaxLength());
                            typedAttr.setPrecision(sourceAttr.getPrecision());
                            typedAttr.setScale(sourceAttr.getScale());
                            typedAttr.setRequired(sourceAttr.isRequired());
                        }
                    }
                    SQLObjectEditor.ObjectCreateCommand attrCreateCommand = attributeManager.makeCreateCommand((DBSObject)newAttribute, options);
                    if (!(createCommand instanceof DBECommandAggregator)) continue;
                    ((DBECommandAggregator)createCommand).aggregateCommand((DBECommand)attrCreateCommand);
                }
            }
            containerMapping.setTargetName(tableFinalName);
            List actions = DBExecUtils.getActionsListFromCommandContext((DBRProgressMonitor)monitor, (DBECommandContext)commandContext, (DBCExecutionContext)executionContext, options, null);
            return actions.toArray(new DBEPersistAction[0]);
        }
        catch (DBException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @NotNull
    static DBEPersistAction generateTargetAttributeDDL(DBPDataSource dataSource, DatabaseMappingAttribute attribute) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("ALTER TABLE ").append(DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" ADD ");
        DatabaseTransferUtils.appendAttributeClause(dataSource, sql, attribute);
        return new SQLDatabasePersistAction(sql.toString());
    }

    private static void appendAttributeClause(DBPDataSource dataSource, StringBuilder sql, DatabaseMappingAttribute attr) {
        String attrName = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)attr.getTargetName());
        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)attrName)).append(" ").append(attr.getTargetType(dataSource, true));
        if (SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource).supportsNullability() && attr.getSource().isRequired()) {
            sql.append(" NOT NULL");
        }
    }

    public static void executeDDL(DBCSession session, DBEPersistAction[] actions) throws DBCException {
        DBExecUtils.executeScript((DBCSession)session, (DBEPersistAction[])actions);
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
        if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            txnManager.commit(session);
        }
    }

    public static void createTargetDynamicTable(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer schema, DatabaseMappingContainer containerMapping) throws DBException {
        DBERegistry editorsRegistry = executionContext.getDataSource().getContainer().getPlatform().getEditorsRegistry();
        Class tableClass = schema.getPrimaryChildType(monitor);
        if (!DBSEntity.class.isAssignableFrom(tableClass)) {
            throw new DBException("Wrong table container child type: " + tableClass.getName());
        }
        SQLObjectEditor tableManager = (SQLObjectEditor)editorsRegistry.getObjectManager(tableClass, SQLObjectEditor.class);
        if (tableManager == null) {
            throw new DBException("Entity manager not found for '" + tableClass.getName() + "'");
        }
        TargetCommandContext commandContext = new TargetCommandContext(executionContext);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("skip.object.configuration", true);
        DBSObject targetEntity = tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)schema, null, options);
        if (targetEntity == null) {
            throw new DBException("Null target entity returned");
        }
        if (!(targetEntity instanceof DBPNamedObject2)) {
            throw new DBException("Can not set name for target entity '" + targetEntity.getClass().getName() + "'");
        }
        ((DBPNamedObject2)targetEntity).setName(containerMapping.getTargetName());
        commandContext.saveChanges(monitor, options);
    }

    public static Pair<DBPDataKind, String> getDataType(String value) {
        if (CommonUtils.isEmpty((String)value)) {
            return DATA_TYPE_UNKNOWN;
        }
        char firstChar = value.charAt(0);
        if (Character.isDigit(firstChar) || firstChar == '+' || firstChar == '-' || firstChar == '.') {
            try {
                Long.parseLong(value);
                return DATA_TYPE_INTEGER;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double.parseDouble(value);
                    return DATA_TYPE_REAL;
                }
                catch (NumberFormatException numberFormatException2) {}
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return DATA_TYPE_BOOLEAN;
        }
        return DATA_TYPE_STRING;
    }

    static class TargetCommandContext
    extends AbstractCommandContext {
        TargetCommandContext(DBCExecutionContext executionContext) {
            super(executionContext, true);
        }
    }
}

