/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.SimpleByteArrayTransfer;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.PropertyPageStandard;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelectionExt;
import org.jkiss.dbeaver.ui.controls.resultset.IStatefulControl;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetPasteSettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetPropertyTester;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetFindReplaceTarget;
import org.jkiss.dbeaver.ui.data.IMultiController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.IValueEditorStandalone;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.ui.properties.PropertySourceDelegate;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLUtils;

public class SpreadsheetPresentation
extends AbstractPresentation
implements IResultSetEditor,
ISelectionProvider,
IStatefulControl,
IAdaptable,
IGridController {
    public static final String PRESENTATION_ID = "spreadsheet";
    public static final String ATTR_OPTION_PINNED = "pinned";
    private static final Log log = Log.getLog(SpreadsheetPresentation.class);
    private Spreadsheet spreadsheet;
    @Nullable
    private DBDAttributeBinding curAttribute;
    private int columnOrder = -1;
    private final Map<SpreadsheetValueController, IValueEditorStandalone> openEditors = new HashMap<SpreadsheetValueController, IValueEditorStandalone>();
    private Color backgroundAdded;
    private Color backgroundDeleted;
    private Color backgroundModified;
    private Color backgroundNormal;
    private Color backgroundOdd;
    private Color backgroundReadOnly;
    private Color foregroundDefault;
    private Color foregroundSelected;
    private Color backgroundSelected;
    private Color backgroundMatched;
    private Color cellHeaderForeground;
    private Color cellHeaderBackground;
    private Color cellHeaderSelectionBackground;
    private boolean showOddRows = true;
    private boolean highlightRowsWithSelectedCells;
    private boolean showAttrOrdering;
    private boolean supportsAttributeFilter;
    private boolean autoFetchSegments;
    private boolean showAttributeIcons;
    private boolean showAttributeDescription;
    private boolean calcColumnWidthByValue;
    private boolean rightJustifyNumbers = true;
    private boolean rightJustifyDateTime = true;
    private boolean showBooleanAsCheckbox;
    private BooleanStyleSet booleanStyles;
    private int rowBatchSize;
    private IValueEditor activeInlineEditor;
    private int highlightScopeFirstLine;
    private int highlightScopeLastLine;
    private Color highlightScopeColor;
    private boolean useNativeNumbersFormat;

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public boolean isShowOddRows() {
        return this.showOddRows;
    }

    public void setShowOddRows(boolean showOddRows) {
        this.showOddRows = showOddRows;
    }

    public boolean isAutoFetchSegments() {
        return this.autoFetchSegments;
    }

    public void setAutoFetchSegments(boolean autoFetchSegments) {
        this.autoFetchSegments = autoFetchSegments;
    }

    @Nullable
    DBPDataSource getDataSource() {
        DBSDataContainer dataContainer = this.controller.getDataContainer();
        return dataContainer == null ? null : dataContainer.getDataSource();
    }

    @Override
    public boolean isDirty() {
        return this.activeInlineEditor != null && this.activeInlineEditor.getControl() != null && !this.activeInlineEditor.getControl().isDisposed() && !DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)this.getCurrentAttribute()) && !(this.activeInlineEditor instanceof IValueEditorStandalone);
    }

    @Override
    public void applyChanges() {
        if (this.activeInlineEditor != null && this.activeInlineEditor.getControl() != null && !this.activeInlineEditor.getControl().isDisposed()) {
            IValueController valueController = (IValueController)this.activeInlineEditor.getControl().getData("org.jkiss.dbeaver.resultset.value-controller");
            if (valueController != null) {
                try {
                    Object value = this.activeInlineEditor.extractEditorValue();
                    valueController.updateValue(value, true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error extracting editor value", null, (Throwable)e);
                }
            }
            this.spreadsheet.cancelInlineEditor();
        }
        super.applyChanges();
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        this.spreadsheet = new Spreadsheet(parent, 268436226, controller.getSite(), this, new ContentProvider(), new GridLabelProvider(), this);
        this.spreadsheet.setLayoutData(new GridData(1808));
        this.spreadsheet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 1 && e.detail != 4) {
                    SpreadsheetPresentation.this.updateGridCursor((GridCell)e.data);
                }
                SpreadsheetPresentation.this.fireSelectionChanged((ISelection)new SpreadsheetSelectionImpl());
            }
        });
        this.spreadsheet.addMouseWheelListener(e -> {});
        this.spreadsheet.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            }
        });
        this.activateTextKeyBindings(controller, (Control)this.spreadsheet);
        this.applyCurrentThemeSettings();
        this.trackPresentationControl();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)this.spreadsheet);
    }

    @Override
    public void dispose() {
        this.closeEditors();
        this.clearMetaData();
        UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
        super.dispose();
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        boolean recordMode = this.controller.isRecordMode();
        ResultSetRow curRow = this.controller.getCurrentRow();
        ResultSetModel model = this.controller.getModel();
        this.spreadsheet.setRedraw(false);
        try {
            int hScrollPos = this.spreadsheet.getHorizontalScrollBarProxy().getSelection();
            switch (position) {
                case FIRST: {
                    if (recordMode) {
                        if (model.getRowCount() > 0) {
                            this.controller.setCurrentRow(model.getRow(0));
                            break;
                        }
                        this.controller.setCurrentRow(null);
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, -this.spreadsheet.getItemCount(), false);
                    break;
                }
                case PREVIOUS: {
                    if (recordMode && curRow != null && curRow.getVisualNumber() > 0) {
                        this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() - 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, -1, false);
                    break;
                }
                case NEXT: {
                    if (recordMode && curRow != null && curRow.getVisualNumber() < model.getRowCount() - 1) {
                        this.controller.setCurrentRow(model.getRow(curRow.getVisualNumber() + 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, 1, false);
                    break;
                }
                case LAST: {
                    if (recordMode && model.getRowCount() > 0) {
                        this.controller.setCurrentRow(model.getRow(model.getRowCount() - 1));
                        break;
                    }
                    this.spreadsheet.shiftCursor(0, this.spreadsheet.getItemCount(), false);
                    break;
                }
                case CURRENT: {
                    if (curRow == null) break;
                    GridPos curPos = this.spreadsheet.getCursorPosition();
                    GridCell newCell = this.spreadsheet.posToCell(new GridPos(curPos.col, curRow.getVisualNumber()));
                    if (newCell == null) break;
                    this.spreadsheet.setCursor(newCell, false, true, true);
                }
            }
            if (recordMode && this.controller.getSelectedRecords().length > 1 && curRow != null) {
                curRow = this.controller.getCurrentRow();
                int newColumnIndex = ArrayUtils.indexOf((int[])this.controller.getSelectedRecords(), (int)0, (int)curRow.getVisualNumber());
                if (newColumnIndex >= 0) {
                    GridPos focusPos = this.spreadsheet.getCursorPosition();
                    GridCell newPos = this.spreadsheet.posToCell(new GridPos(newColumnIndex, focusPos.row));
                    if (newPos != null) {
                        this.spreadsheet.setCursor(newPos, true, true, false);
                    }
                }
            }
            this.spreadsheet.getHorizontalScrollBarProxy().setSelection(hScrollPos);
            this.controller.updateStatusMessage();
            this.controller.updatePanelsContent(false);
            if (recordMode) {
                this.refreshData(true, false, true);
            }
        }
        finally {
            this.spreadsheet.setRedraw(true);
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
        this.curAttribute = attribute;
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (curRow == null) {
            return;
        }
        GridCell cell = this.controller.isRecordMode() ? new GridCell(curRow, this.curAttribute) : new GridCell(this.curAttribute, curRow);
        this.spreadsheet.setCursor(cell, false, true, true);
    }

    @Override
    public void showAttribute(@NotNull DBDAttributeBinding attribute) {
        this.spreadsheet.showColumn(attribute);
    }

    @Override
    public Point getCursorLocation() {
        Rectangle columnBounds;
        GridPos focusPos = this.spreadsheet.getFocusPos();
        if (focusPos.col >= 0 && (columnBounds = this.spreadsheet.getColumnBounds(focusPos.col)) != null) {
            columnBounds.y += this.spreadsheet.getHeaderHeight() + (focusPos.row - this.spreadsheet.getTopIndex()) * (this.spreadsheet.getItemHeight() + 1) + this.spreadsheet.getItemHeight() / 2;
            return new Point(columnBounds.x + 20, columnBounds.y);
        }
        return super.getCursorLocation();
    }

    @Override
    protected void performHorizontalScroll(int scrollCount) {
        this.spreadsheet.scrollHorizontally(scrollCount);
    }

    void highlightRows(int firstLine, int lastLine, Color color) {
        this.highlightScopeFirstLine = firstLine;
        this.highlightScopeLastLine = lastLine;
        this.highlightScopeColor = color;
    }

    @Override
    public Object saveState() {
        return new ViewState(this.curAttribute, this.spreadsheet.getHorizontalScrollBarProxy().getSelection());
    }

    @Override
    public void restoreState(Object state) {
        if (state == null) {
            return;
        }
        ViewState viewState = (ViewState)state;
        this.curAttribute = this.controller.getModel().getAttributeBinding((DBSAttributeBase)viewState.focusedAttribute);
        this.spreadsheet.getHorizontalScrollBarProxy().setSelection(viewState.hScrollSelection);
        this.spreadsheet.setDefaultFocusRow();
    }

    private void updateGridCursor(GridCell cell) {
        boolean changed;
        Object newCol = cell == null ? null : cell.col;
        Object newRow = cell == null ? null : cell.row;
        ResultSetRow curRow = this.controller.getCurrentRow();
        if (!this.controller.isRecordMode()) {
            boolean bl = changed = curRow != newRow || this.curAttribute != newCol;
            if (newRow instanceof ResultSetRow) {
                curRow = (ResultSetRow)newRow;
                this.controller.setCurrentRow(curRow);
            }
            if (newCol instanceof DBDAttributeBinding) {
                this.curAttribute = (DBDAttributeBinding)newCol;
            }
        } else {
            boolean bl = changed = this.curAttribute != newRow;
            if (newRow instanceof DBDAttributeBinding) {
                this.curAttribute = (DBDAttributeBinding)newRow;
            }
            if (newCol instanceof ResultSetRow && curRow != newCol) {
                curRow = (ResultSetRow)newCol;
                this.controller.setCurrentRow(curRow);
            }
        }
        if (changed) {
            this.spreadsheet.cancelInlineEditor();
            ResultSetPropertyTester.firePropertyChange("canMove");
            ResultSetPropertyTester.firePropertyChange("editable");
            this.spreadsheet.redrawGrid();
        }
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        String quoteString;
        String rowDelimiter;
        boolean copyHTML = settings.isCopyHTML();
        StringBuilder tdt = new StringBuilder();
        StringBuilder html = new StringBuilder();
        byte[] binaryData = null;
        LinkedHashMap<Transfer, Object> formats = new LinkedHashMap<Transfer, Object>();
        String columnDelimiter = settings.getColumnDelimiter();
        if (columnDelimiter == null) {
            columnDelimiter = "\t";
        }
        if ((rowDelimiter = settings.getRowDelimiter()) == null) {
            rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        if (CommonUtils.isEmpty((String)(quoteString = settings.getQuoteString()))) {
            quoteString = "\"";
        }
        List<Object> selectedColumns = this.spreadsheet.getColumnSelection();
        IGridLabelProvider labelProvider = this.spreadsheet.getLabelProvider();
        if (copyHTML) {
            html.append("<table border=\"1\">");
        }
        if (settings.isCopyHeader()) {
            if (copyHTML) {
                html.append("<thead>");
            }
            if (settings.isCopyRowNumbers()) {
                tdt.append("#");
                if (copyHTML) {
                    html.append("<th>#</th>");
                }
            }
            for (Object column : selectedColumns) {
                if (tdt.length() > 0) {
                    tdt.append(columnDelimiter);
                }
                String columnText = labelProvider.getText(column);
                tdt.append(columnText);
                if (!copyHTML) continue;
                html.append("<th>").append(XMLUtils.escapeXml((CharSequence)columnText)).append("</th>");
            }
            tdt.append(rowDelimiter);
            if (copyHTML) {
                html.append("</thead>").append(rowDelimiter);
            }
        }
        if (copyHTML) {
            html.append("<tbody>");
        }
        List<GridCell> selectedCells = this.spreadsheet.getCellSelection();
        boolean quoteCells = settings.isQuoteCells() && selectedCells.size() > 1;
        boolean forceQuotes = settings.isForceQuotes();
        GridCell prevCell = null;
        for (GridCell cell : selectedCells) {
            SpreadsheetValueController valueController;
            boolean recordMode;
            int prevColIndex;
            if (prevCell == null || cell.row != prevCell.row) {
                if (prevCell != null && prevCell.col != cell.col) {
                    int i = prevColIndex = selectedColumns.indexOf(prevCell.col);
                    while (i < selectedColumns.size() - 1) {
                        tdt.append(columnDelimiter);
                        if (copyHTML) {
                            html.append("<td></td>");
                        }
                        ++i;
                    }
                }
                if (prevCell != null) {
                    tdt.append(rowDelimiter);
                    if (copyHTML) {
                        html.append("</tr>").append(rowDelimiter);
                    }
                }
                if (settings.isCopyRowNumbers()) {
                    String rowNumber = labelProvider.getText(cell.row);
                    tdt.append(rowNumber).append(columnDelimiter);
                    if (copyHTML) {
                        html.append("<td>").append(rowNumber).append("</td>");
                    }
                }
                if (copyHTML) {
                    html.append("<tr>");
                }
            }
            if (prevCell != null && prevCell.col != cell.col) {
                prevColIndex = selectedColumns.indexOf(prevCell.col);
                int curColIndex = selectedColumns.indexOf(cell.col);
                int i = prevColIndex;
                while (i < curColIndex) {
                    tdt.append(columnDelimiter);
                    if (i != prevColIndex && copyHTML) {
                        html.append("<td></td>");
                    }
                    ++i;
                }
            }
            DBDAttributeBinding column = (DBDAttributeBinding)(!(recordMode = this.controller.isRecordMode()) ? cell.col : cell.row);
            ResultSetRow row = (ResultSetRow)(!recordMode ? cell.row : cell.col);
            Object value = this.controller.getModel().getCellValue(column, row);
            if (binaryData == null && (column.getDataKind() == DBPDataKind.BINARY || column.getDataKind() == DBPDataKind.CONTENT)) {
                if (value instanceof byte[]) {
                    binaryData = (byte[])value;
                } else if (value instanceof DBDContent && !ContentUtils.isTextContent((DBDContent)((DBDContent)value)) && value instanceof DBDContentCached) {
                    try {
                        binaryData = ContentUtils.getContentBinaryValue((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContent)((DBDContent)value));
                    }
                    catch (DBCException dBCException) {
                        log.debug((Object)"Error reading content binary value");
                    }
                }
            }
            String cellText = column.getValueRenderer().getValueDisplayString((DBSTypedObject)column.getAttribute(), value, settings.getFormat());
            if ((forceQuotes || quoteCells && !CommonUtils.isEmpty((String)cellText)) && (forceQuotes || cellText.contains(columnDelimiter) || cellText.contains(rowDelimiter))) {
                cellText = String.valueOf(quoteString) + cellText + quoteString;
            }
            tdt.append(cellText);
            if (copyHTML) {
                html.append("<td>").append(XMLUtils.escapeXml((CharSequence)cellText)).append("</td> ");
            }
            if (settings.isCut() && !(valueController = new SpreadsheetValueController(this.controller, column, row, IValueController.EditType.NONE, null)).isReadOnly()) {
                valueController.updateValue(BaseValueManager.makeNullValue(valueController), false);
            }
            prevCell = cell;
        }
        if (copyHTML) {
            html.append("</tbody>").append(rowDelimiter);
            html.append("</table>").append(rowDelimiter);
        }
        if (settings.isCut()) {
            this.controller.redrawData(false, false);
            this.controller.updatePanelsContent(false);
        }
        formats.put((Transfer)TextTransfer.getInstance(), tdt.toString());
        if (copyHTML) {
            formats.put((Transfer)HTMLTransfer.getInstance(), html.toString());
        }
        if (binaryData != null) {
            formats.put((Transfer)SimpleByteArrayTransfer.getInstance(), binaryData);
        }
        return formats;
    }

    @Override
    public void pasteFromClipboard(@Nullable ResultSetPasteSettings settings) {
        try {
            block42: {
                if (settings != null) {
                    String strValue;
                    Clipboard clipboard = new Clipboard(Display.getCurrent());
                    try {
                        strValue = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    }
                    finally {
                        clipboard.dispose();
                    }
                    if (CommonUtils.isEmpty((String)strValue)) {
                        return;
                    }
                    GridPos focusPos = this.spreadsheet.getFocusPos();
                    int rowNum = focusPos.row;
                    if (rowNum < 0) {
                        return;
                    }
                    this.controller.getModel().getRow(rowNum).getState();
                    Throwable throwable = null;
                    Object var7_15 = null;
                    try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)this.controller.getDataContainer(), (String)"Advanced paste");){
                        String[][] newLines = this.parseGridLines(strValue, settings.isInsertMultipleRows());
                        while (rowNum + newLines.length > this.spreadsheet.getItemCount()) {
                            this.controller.addNewRow(false, true, false);
                            this.spreadsheet.refreshRowsData();
                        }
                        if (rowNum < 0 || rowNum >= this.spreadsheet.getItemCount()) {
                            return;
                        }
                        String[][] stringArray = newLines;
                        int n = newLines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] line = stringArray[n2];
                            int colNum = focusPos.col;
                            Object rowElement = this.spreadsheet.getRowElement(rowNum);
                            String[] stringArray2 = line;
                            int n3 = line.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String value = stringArray2[n4];
                                if (colNum >= this.spreadsheet.getColumnCount()) break;
                                Object colElement = this.spreadsheet.getColumnElement(colNum);
                                DBDAttributeBinding attr = (DBDAttributeBinding)(this.controller.isRecordMode() ? rowElement : colElement);
                                ResultSetRow row = (ResultSetRow)(this.controller.isRecordMode() ? colElement : rowElement);
                                if (this.controller.getAttributeReadOnlyStatus(attr) == null) {
                                    Object newValue = settings.isInsertNulls() && settings.getNullValueMark().equalsIgnoreCase(value) ? null : attr.getValueHandler().getValueFromObject(session, (DBSTypedObject)attr.getAttribute(), (Object)value, true, false);
                                    new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null).updateValue(newValue, false);
                                    ++colNum;
                                }
                                ++n4;
                            }
                            if (++rowNum >= this.spreadsheet.getItemCount()) {
                                break block42;
                            }
                            ++n2;
                        }
                        break block42;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Collection<GridPos> ssSelection = this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    ResultSetRow row;
                    DBDAttributeBinding attr;
                    if (this.controller.isRecordMode()) {
                        attr = (DBDAttributeBinding)this.spreadsheet.getRowElement(pos.row);
                        row = this.controller.getCurrentRow();
                    } else {
                        attr = (DBDAttributeBinding)this.spreadsheet.getColumnElement(pos.col);
                        row = (ResultSetRow)this.spreadsheet.getRowElement(pos.row);
                    }
                    if (attr == null || row == null || this.controller.getAttributeReadOnlyStatus(attr) != null) continue;
                    SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null);
                    Object newValue = null;
                    if (attr.getDataKind() == DBPDataKind.BINARY || attr.getDataKind() == DBPDataKind.CONTENT) {
                        Clipboard clipboard = new Clipboard(Display.getCurrent());
                        try {
                            Throwable throwable = null;
                            Object var11_27 = null;
                            try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)attr, (String)"Copy from clipboard");){
                                byte[] binaryContents = (byte[])clipboard.getContents((Transfer)SimpleByteArrayTransfer.getInstance());
                                if (binaryContents != null) {
                                    newValue = valueController.getValueHandler().getValueFromObject(session, (DBSTypedObject)attr, (Object)binaryContents, false, false);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            clipboard.dispose();
                        }
                    }
                    if (newValue == null && (newValue = ResultSetUtils.getAttributeValueFromClipboard(attr)) == null) continue;
                    valueController.updateValue(newValue, false);
                }
            }
            this.controller.redrawData(false, true);
            this.controller.updateEditControls();
            this.controller.updatePanelsContent(false);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Cannot replace cell value", null, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[][] parseGridLines(String strValue, boolean splitRows) {
        lines = new ArrayList<String[]>();
        cellValue = new StringBuilder();
        curLine = new ArrayList<String>();
        inQuote = false;
        length = strValue.length();
        i = 0;
        while (i < length) {
            block13: {
                block12: {
                    c = strValue.charAt(i);
                    if (!inQuote || c == '\"') break block12;
                    cellValue.append(c);
                    break block13;
                }
                switch (c) {
                    case '\t': 
                    case '\n': {
                        curLine.add(cellValue.toString());
                        cellValue.setLength(0);
                        if (c != '\n' || !splitRows) break;
                        lines.add(curLine.toArray(new String[0]));
                        curLine.clear();
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\"': {
                        if (!inQuote) ** GOTO lbl32
                        if (i == length - 1 || strValue.charAt(i + 1) == '\t' || strValue.charAt(i + 1) == '\r' || strValue.charAt(i + 1) == '\n') {
                            inQuote = false;
                            break;
                        }
                        ** GOTO lbl41
lbl32:
                        // 1 sources

                        if (cellValue.length() == 0) {
                            k = i + 1;
                            while (k < length) {
                                if (strValue.charAt(k) == '\"' && (k == length - 1 || strValue.charAt(k + 1) == '\t' || strValue.charAt(k + 1) == '\r' || strValue.charAt(k + 1) == '\n')) {
                                    inQuote = true;
                                    break;
                                }
                                ++k;
                            }
                            if (inQuote) break;
                        }
                    }
lbl41:
                    // 5 sources

                    default: {
                        cellValue.append(c);
                    }
                }
            }
            ++i;
        }
        if (cellValue.length() > 0) {
            curLine.add(cellValue.toString());
        }
        if (!curLine.isEmpty()) {
            lines.add(curLine.toArray(new String[0]));
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    @Override
    public Control getControl() {
        return this.spreadsheet;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        DBPPreferenceStore preferenceStore = this.getPreferenceStore();
        this.showOddRows = preferenceStore.getBoolean("resultset.show.oddRows");
        this.highlightRowsWithSelectedCells = preferenceStore.getBoolean("resultset.highlight.selectedRows");
        this.rightJustifyNumbers = preferenceStore.getBoolean("resultset.show.rightJustifyNumbers");
        this.rightJustifyDateTime = preferenceStore.getBoolean("resultset.show.rightJustifyDateTime");
        this.rowBatchSize = preferenceStore.getInt("resultset.show.row.batch.size");
        this.showAttrOrdering = preferenceStore.getBoolean("resultset.show.attOrdering");
        this.showAttributeIcons = this.controller.getPreferenceStore().getBoolean("resultset.show.attIcons");
        this.showAttributeDescription = this.getPreferenceStore().getBoolean("resultset.show.columnDescription");
        this.supportsAttributeFilter = (this.controller.getDecorator().getDecoratorFeatures() & 1L) != 0L && (this.controller.getDataContainer().getSupportedFeatures() & 4) != 0 && this.controller.getPreferenceStore().getBoolean("resultset.show.attFilters");
        this.autoFetchSegments = this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment");
        this.calcColumnWidthByValue = this.getPreferenceStore().getBoolean("resultset.calc.columnWidthByValues");
        this.showBooleanAsCheckbox = preferenceStore.getBoolean("resultset.show.boolean.checkbox");
        this.booleanStyles = BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)preferenceStore);
        this.useNativeNumbersFormat = this.controller.getPreferenceStore().getBoolean("resultset.format.numeric.native");
        this.spreadsheet.setColumnScrolling(!this.getPreferenceStore().getBoolean("resultset.hScroll.smooth"));
        this.spreadsheet.setRedraw(false);
        try {
            this.spreadsheet.refreshData(refreshMetadata, keepState, false);
        }
        finally {
            this.spreadsheet.setRedraw(true);
        }
    }

    @Override
    public void formatData(boolean refreshData) {
        this.spreadsheet.refreshData(false, true, false);
    }

    @Override
    public void clearMetaData() {
        this.curAttribute = null;
        if (this.columnOrder != 0) {
            this.columnOrder = -1;
        }
    }

    @Override
    public void updateValueView() {
        this.spreadsheet.redrawGrid();
        this.spreadsheet.updateScrollbars();
        if (this.curAttribute == null) {
            this.curAttribute = this.getFocusAttribute();
        }
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
        menu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.togglePreview", (int)32));
    }

    @Override
    public void changeMode(boolean recordMode) {
        ResultSetRow oldRow = this.controller.getCurrentRow();
        DBDAttributeBinding oldAttribute = this.curAttribute;
        int rowCount = this.controller.getModel().getRowCount();
        if (rowCount > 0) {
            if (oldRow == null) {
                oldRow = this.controller.getModel().getRow(0);
            } else if (oldRow.getVisualNumber() >= rowCount) {
                oldRow = this.controller.getModel().getRow(rowCount - 1);
            }
        }
        if (oldAttribute == null && this.controller.getModel().getVisibleAttributeCount() > 0) {
            oldAttribute = this.controller.getModel().getVisibleAttribute(0);
        }
        int n = this.columnOrder = recordMode ? -1 : 0;
        if (oldRow != null && oldAttribute != null) {
            if (!recordMode) {
                this.spreadsheet.setCursor(new GridCell(oldAttribute, oldRow), false, true, true);
            } else {
                this.spreadsheet.setCursor(new GridCell(oldRow, oldAttribute), false, true, true);
            }
        }
        this.spreadsheet.layout(true, true);
    }

    void fillContextMenu(@NotNull IMenuManager manager, @Nullable Object colObject, @Nullable Object rowObject) {
        DBDAttributeBinding attr = (DBDAttributeBinding)(this.controller.isRecordMode() ? rowObject : colObject);
        ResultSetRow row = (ResultSetRow)(this.controller.isRecordMode() ? colObject : rowObject);
        this.controller.fillContextMenu(manager, attr, row);
        if (attr != null && row == null) {
            final List<Object> selectedColumns = this.spreadsheet.getColumnSelection();
            if (selectedColumns.size() == 1 && attr != null) {
                selectedColumns.clear();
                selectedColumns.add(attr);
            }
            if (!this.controller.isRecordMode() && !selectedColumns.isEmpty()) {
                String hideTitle;
                manager.insertBefore("results_additions", (IContributionItem)new Separator());
                final DBDDataFilter dataFilter = this.controller.getModel().getDataFilter();
                boolean allPinned = selectedColumns.stream().map(x -> dataFilter.getConstraint(((DBDAttributeBinding)x).getTopParent())).allMatch(x -> x != null && x.hasOption(ATTR_OPTION_PINNED));
                final boolean allUnpinned = selectedColumns.stream().map(x -> dataFilter.getConstraint(((DBDAttributeBinding)x).getTopParent())).allMatch(x -> x != null && !x.hasOption(ATTR_OPTION_PINNED));
                if (allUnpinned != allPinned) {
                    String pinnedTitle = allUnpinned ? (selectedColumns.size() == 1 ? NLS.bind((String)ResultSetMessages.controls_resultset_viewer_pin_column, (Object)((DBDAttributeBinding)selectedColumns.get(0)).getName()) : NLS.bind((String)ResultSetMessages.controls_resultset_viewer_pin_columns, (Object)selectedColumns.size())) : (selectedColumns.size() == 1 ? NLS.bind((String)ResultSetMessages.controls_resultset_viewer_unpin_column, (Object)((DBDAttributeBinding)selectedColumns.get(0)).getName()) : NLS.bind((String)ResultSetMessages.controls_resultset_viewer_unpin_columns, (Object)selectedColumns.size()));
                    manager.insertBefore("results_additions", (IAction)new Action(pinnedTitle){

                        public void run() {
                            for (Object column : selectedColumns) {
                                DBDAttributeBinding attribute = (DBDAttributeBinding)column;
                                DBDAttributeConstraint constraint = dataFilter.getConstraint(attribute.getTopParent());
                                if (constraint == null) continue;
                                if (allUnpinned) {
                                    constraint.setOption(SpreadsheetPresentation.ATTR_OPTION_PINNED, (Object)SpreadsheetPresentation.getNextPinIndex(dataFilter));
                                    continue;
                                }
                                constraint.removeOption(SpreadsheetPresentation.ATTR_OPTION_PINNED);
                            }
                            SpreadsheetPresentation.this.spreadsheet.refreshData(true, true, false);
                        }
                    });
                }
                final ArrayList<DBDAttributeBinding> hiddenAttributes = new ArrayList<DBDAttributeBinding>();
                List constraints = this.getController().getModel().getDataFilter().getConstraints();
                for (DBDAttributeConstraint ac : constraints) {
                    DBSAttributeBase attribute = ac.getAttribute();
                    if (ac.isVisible() || !(attribute instanceof DBDAttributeBinding) || !DBDAttributeConstraint.isVisibleByDefault((DBDAttributeBinding)((DBDAttributeBinding)attribute))) continue;
                    hiddenAttributes.add((DBDAttributeBinding)attribute);
                }
                if (!hiddenAttributes.isEmpty()) {
                    manager.insertAfter("results_additions", (IAction)new Action(ResultSetMessages.controls_resultset_viewer_show_hidden_columns){

                        public void run() {
                            ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
                            for (DBDAttributeBinding attr : hiddenAttributes) {
                                model.setAttributeVisibility(attr, true);
                            }
                            SpreadsheetPresentation.this.refreshData(true, false, true);
                        }
                    });
                }
                if (selectedColumns.size() == 1) {
                    DBDAttributeBinding columnToHide = (DBDAttributeBinding)selectedColumns.get(0);
                    hideTitle = NLS.bind((String)ResultSetMessages.controls_resultset_viewer_hide_column_x, (Object)columnToHide.getName());
                } else {
                    hideTitle = NLS.bind((String)ResultSetMessages.controls_resultset_viewer_hide_columns_x, (Object)selectedColumns.size());
                }
                manager.insertAfter("results_additions", (IAction)new Action(hideTitle){

                    public void run() {
                        ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
                        if (selectedColumns.size() >= model.getVisibleAttributeCount()) {
                            UIUtils.showMessageBox((Shell)SpreadsheetPresentation.this.getControl().getShell(), (String)ResultSetMessages.controls_resultset_viewer_hide_columns_error_title, (String)ResultSetMessages.controls_resultset_viewer_hide_columnss_error_text, (int)1);
                        } else {
                            for (Object selectedColumn : selectedColumns) {
                                model.setAttributeVisibility((DBDAttributeBinding)selectedColumn, false);
                            }
                            SpreadsheetPresentation.this.refreshData(true, false, true);
                        }
                    }
                });
            }
        }
        if (this.controller.isRecordMode() && row != null) {
            ArrayList<Integer> selectedRowIndexes = new ArrayList<Integer>();
            for (Object sRow : this.spreadsheet.getColumnSelection()) {
                if (!(sRow instanceof ResultSetRow)) continue;
                selectedRowIndexes.add(((ResultSetRow)sRow).getVisualNumber());
            }
            if (!selectedRowIndexes.isEmpty() && selectedRowIndexes.size() < this.controller.getSelectedRecords().length) {
                final List curRowIndexes = Arrays.stream(this.controller.getSelectedRecords()).boxed().collect(Collectors.toList());
                curRowIndexes.removeAll(selectedRowIndexes);
                if (!curRowIndexes.isEmpty()) {
                    manager.insertAfter("results_additions", (IAction)new Action("Hide row(s)"){

                        public void run() {
                            SpreadsheetPresentation.this.controller.setSelectedRecords(curRowIndexes.stream().mapToInt(i -> i).toArray());
                            SpreadsheetPresentation.this.refreshData(true, false, true);
                        }
                    });
                }
            }
        }
        if (row == null && !this.controller.getModel().getVisibleAttributes().isEmpty()) {
            manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.columnsFitValue"));
            manager.insertAfter("results_additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.controller.getSite(), (String)"org.jkiss.dbeaver.core.resultset.grid.columnsFitScreen"));
        }
    }

    public static int getNextPinIndex(@NotNull DBDDataFilter dataFilter) {
        int maxIndex = 0;
        for (DBDAttributeConstraint ac : dataFilter.getConstraints()) {
            Integer pinIndex = (Integer)ac.getOption(ATTR_OPTION_PINNED);
            if (pinIndex == null) continue;
            maxIndex = Math.max(maxIndex, pinIndex + 1);
        }
        return maxIndex;
    }

    private void closeEditors() {
        ArrayList<IValueEditorStandalone> editors = new ArrayList<IValueEditorStandalone>(this.openEditors.values());
        for (IValueEditorStandalone editor : editors) {
            if (editor.getControl() == null || editor.getControl().isDisposed()) continue;
            editor.closeValueEditor();
        }
        this.openEditors.clear();
    }

    @Override
    @Nullable
    public Control openValueEditor(boolean inline) {
        IValueController.EditType[] supportedEditTypes;
        SpreadsheetValueController valueController;
        DBDAttributeBinding attr = this.getFocusAttribute();
        ResultSetRow row = this.getFocusRow();
        if (attr == null || row == null) {
            return null;
        }
        Object cellValue = this.getController().getModel().getCellValue(attr, row);
        if (cellValue instanceof DBDValueError) {
            return null;
        }
        if (!inline) {
            Iterator<SpreadsheetValueController> iterator = this.openEditors.keySet().iterator();
            while (iterator.hasNext()) {
                valueController = iterator.next();
                if (attr != valueController.getBinding() || row != valueController.getCurRow()) continue;
                IValueEditorStandalone editor = this.openEditors.get(valueController);
                if (editor.getControl() != null && !editor.getControl().isDisposed()) {
                    editor.showValueEditor();
                    return null;
                }
                iterator.remove();
            }
        } else if (this.isShowAsCheckbox(attr) && this.getPreferenceStore().getBoolean("resultset.show.boolean.toggleOnClick")) {
            return null;
        }
        Composite placeholder = null;
        if (inline) {
            String readOnlyStatus = this.controller.getAttributeReadOnlyStatus(attr);
            if (readOnlyStatus != null) {
                this.controller.setStatus("Column " + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.UI) + " is read-only: " + readOnlyStatus, DBPMessageType.ERROR);
            }
            this.spreadsheet.cancelInlineEditor();
            this.activeInlineEditor = null;
            placeholder = new Composite((Composite)this.spreadsheet, 0);
            placeholder.setFont(this.spreadsheet.getFont());
            placeholder.setLayout((Layout)new FillLayout());
            GridData gd = new GridData(1808);
            gd.horizontalIndent = 0;
            gd.verticalIndent = 0;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            placeholder.setLayoutData((Object)gd);
            placeholder.addDisposeListener(e -> this.controller.updateStatusMessage());
            this.controller.lockActionsByControl((Control)placeholder);
        }
        if ((supportedEditTypes = (valueController = new SpreadsheetValueController(this.controller, attr, row, inline ? IValueController.EditType.INLINE : IValueController.EditType.EDITOR, placeholder)).getValueManager().getSupportedEditTypes()).length == 0) {
            if (placeholder != null) {
                placeholder.dispose();
            }
            return null;
        }
        try {
            this.activeInlineEditor = valueController.getValueManager().createEditor(valueController);
        }
        catch (Exception e2) {
            DBWorkbench.getPlatformUI().showError("Cannot edit value", null, (Throwable)e2);
            return null;
        }
        if (this.activeInlineEditor != null) {
            this.activeInlineEditor.createControl();
            if (this.activeInlineEditor.getControl() != null) {
                this.activeInlineEditor.getControl().setFocus();
                this.activeInlineEditor.getControl().setData("org.jkiss.dbeaver.resultset.value-controller", (Object)valueController);
            }
        }
        if (this.activeInlineEditor instanceof IValueEditorStandalone) {
            valueController.registerEditor((IValueEditorStandalone)this.activeInlineEditor);
            Control editorControl = this.activeInlineEditor.getControl();
            if (editorControl != null) {
                editorControl.addDisposeListener(e -> valueController.unregisterEditor((IValueEditorStandalone)this.activeInlineEditor));
            }
            UIUtils.asyncExec(() -> ((IValueEditorStandalone)this.activeInlineEditor).showValueEditor());
        } else if (this.activeInlineEditor != null) {
            try {
                this.activeInlineEditor.primeEditorValue(valueController.getValue());
            }
            catch (DBException e3) {
                log.error((Object)e3);
            }
            this.activeInlineEditor.setDirty(false);
        }
        if (inline) {
            if (this.activeInlineEditor != null) {
                this.spreadsheet.showCellEditor(placeholder);
                return this.activeInlineEditor.getControl();
            }
            placeholder.dispose();
            if (ArrayUtils.contains((Object[])supportedEditTypes, (Object)((Object)IValueController.EditType.PANEL))) {
                this.controller.activatePanel("value-view", true, true);
                return null;
            }
        }
        return null;
    }

    public void resetCellValue(@NotNull Object colElement, @NotNull Object rowElement, boolean delete) {
        boolean recordMode = this.controller.isRecordMode();
        DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
        ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
        this.controller.getModel().resetCellValue(attr, row);
        this.updateValueView();
        this.controller.updatePanelsContent(false);
    }

    public void navigateLink(@NotNull GridCell cell, final int state) {
        boolean recordMode = this.controller.isRecordMode();
        final DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? cell.row : cell.col);
        final ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
        Object value = this.controller.getModel().getCellValue(attr, row);
        if (this.isShowAsCheckbox(attr)) {
            if (!this.getPreferenceStore().getBoolean("resultset.show.boolean.toggleOnClick")) {
                return;
            }
            if (!DBExecUtils.isAttributeReadOnly((DBDAttributeBinding)attr)) {
                this.toggleBooleanValue(attr, row, value);
            }
        } else if (DBUtils.isNullValue((Object)value)) {
            UIUtils.showMessageBox((Shell)this.getSpreadsheet().getShell(), (String)"Wrong link", (String)"Can't navigate to NULL value", (int)1);
        } else if (!CommonUtils.isEmpty((Collection)attr.getReferrers())) {
            new AbstractJob("Navigate association"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        boolean newWindow = RuntimeUtils.isMacOS() ? (state & 0x400000) == 0x400000 : (state & 0x40000) == 262144;
                        SpreadsheetPresentation.this.controller.navigateAssociation(monitor, SpreadsheetPresentation.this.controller.getModel(), DBExecUtils.getAssociationByAttribute((DBDAttributeBinding)attr), Collections.singletonList(row), newWindow);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            String strValue = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.UI);
            ShellUtils.launchProgram((String)strValue);
        }
    }

    public void toggleCellValue(Object columnElement, Object rowElement) {
        boolean recordMode = this.controller.isRecordMode();
        DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : columnElement);
        ResultSetRow row = (ResultSetRow)(recordMode ? columnElement : rowElement);
        if (this.isShowAsCheckbox(attr)) {
            Object cellValue = this.controller.getModel().getCellValue(attr, row);
            this.toggleBooleanValue(attr, row, cellValue);
        }
    }

    private void toggleBooleanValue(DBDAttributeBinding attr, ResultSetRow row, Object value) {
        boolean nullable;
        boolean bl = nullable = !attr.isRequired();
        if (value instanceof Number) {
            value = ((Number)value).byteValue() != 0;
        }
        value = Boolean.TRUE.equals(value) ? Boolean.valueOf(false) : (Boolean.FALSE.equals(value) ? (nullable ? null : Boolean.valueOf(true)) : Boolean.valueOf(true));
        SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null);
        for (ResultSetRow selRow : this.getSelection().getSelectedRows()) {
            valueController.setCurRow(selRow);
            valueController.updateValue(value, true);
        }
    }

    @Override
    protected void applyThemeSettings(ITheme currentTheme) {
        Font rsFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.resultset.font");
        if (rsFont != null) {
            this.spreadsheet.setFont(rsFont);
        }
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        Color previewBack = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.preview.background");
        this.backgroundAdded = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        this.backgroundOdd = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.odd.background");
        this.backgroundReadOnly = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.readonly.background");
        this.foregroundSelected = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.selection.foreground");
        this.backgroundSelected = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.selection.background");
        this.backgroundMatched = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.cell.matched.background");
        this.cellHeaderForeground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.foreground");
        this.cellHeaderBackground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.background");
        if (this.cellHeaderSelectionBackground != null) {
            UIUtils.dispose((Resource)this.cellHeaderSelectionBackground);
            this.cellHeaderSelectionBackground = null;
        }
        Color headerSelectionBackground = colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.header.selected.background");
        RGB cellSel = UIUtils.blend((RGB)headerSelectionBackground.getRGB(), (RGB)(UIStyles.isDarkTheme() ? new RGB(100, 100, 100) : new RGB(255, 255, 255)), (int)50);
        this.cellHeaderSelectionBackground = new Color((Device)this.getSpreadsheet().getDisplay(), cellSel);
        this.spreadsheet.setLineColor(colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.lines.normal"));
        this.spreadsheet.setLineSelectedColor(colorRegistry.get("org.jkiss.dbeaver.sql.resultset.color.lines.selected"));
        this.spreadsheet.recalculateSizes();
        this.booleanStyles = BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)this.getPreferenceStore());
    }

    private boolean supportsDataFilter() {
        DBSDataContainer dataContainer = this.controller.getDataContainer();
        return dataContainer != null && (dataContainer.getSupportedFeatures() & 4) == 4;
    }

    public void changeSorting(Object columnElement, int state) {
        if (columnElement == null) {
            this.columnOrder = this.columnOrder == -1 ? 128 : (this.columnOrder == 128 ? 1024 : -1);
            this.spreadsheet.refreshData(false, true, false);
            this.spreadsheet.redrawGrid();
            return;
        }
        boolean ctrlPressed = (state & 0x40000) == 262144;
        boolean altPressed = (state & 0x10000) == 65536;
        this.controller.toggleSortOrder((DBDAttributeBinding)columnElement, ctrlPressed ? IResultSetController.ColumnOrder.ASC : (altPressed ? IResultSetController.ColumnOrder.DESC : null));
    }

    void showFiltering(Object columnElement) {
        if (!(columnElement instanceof DBDAttributeBinding)) {
            log.debug((Object)("Unable to show distinct filter for columnElement" + columnElement));
            return;
        }
        DBDAttributeBinding attributeBinding = (DBDAttributeBinding)columnElement;
        if (!this.getSelection().getSelectedAttributes().contains(attributeBinding)) {
            this.spreadsheet.deselectAll();
        }
        this.controller.showDistinctFilter(attributeBinding);
    }

    public DBPPreferenceStore getPreferenceStore() {
        return this.controller.getPreferenceStore();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            PropertyPageStandard page = new PropertyPageStandard();
            page.setPropertySourceProvider(object -> {
                if (object instanceof GridCell) {
                    GridCell cell = (GridCell)object;
                    boolean recordMode = this.controller.isRecordMode();
                    DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? cell.row : cell.col);
                    ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
                    SpreadsheetValueController valueController = new SpreadsheetValueController(this.controller, attr, row, IValueController.EditType.NONE, null);
                    PropertyCollector props = new PropertyCollector((Object)valueController.getBinding().getAttribute(), false);
                    props.collectProperties();
                    valueController.getValueManager().contributeProperties((DBPPropertyManager)props, valueController);
                    return new PropertySourceDelegate((DBPPropertySource)props);
                }
                return null;
            });
            return adapter.cast(page);
        }
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(SpreadsheetFindReplaceTarget.getInstance().owned(this));
        }
        return null;
    }

    @Nullable
    public DBDAttributeBinding getFocusAttribute() {
        return this.controller.isRecordMode() ? (DBDAttributeBinding)this.spreadsheet.getFocusRowElement() : (DBDAttributeBinding)this.spreadsheet.getFocusColumnElement();
    }

    @Nullable
    public ResultSetRow getFocusRow() {
        return this.controller.isRecordMode() ? (ResultSetRow)this.spreadsheet.getFocusColumnElement() : (ResultSetRow)this.spreadsheet.getFocusRowElement();
    }

    public int getHighlightScopeFirstLine() {
        return this.highlightScopeFirstLine;
    }

    public int getHighlightScopeLastLine() {
        return this.highlightScopeLastLine;
    }

    public IResultSetSelection getSelection() {
        return new SpreadsheetSelectionImpl();
    }

    @Override
    public void setSelection(ISelection selection) {
        if (selection instanceof IResultSetSelection && ((IResultSetSelection)selection).getController() == this.getController()) {
            return;
        }
        this.spreadsheet.deselectAll();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            ArrayList<GridPos> cellSelection = new ArrayList<GridPos>();
            for (Object cell : (IStructuredSelection)selection) {
                if (cell instanceof GridPos) {
                    cellSelection.add((GridPos)cell);
                    continue;
                }
                log.warn((Object)("Bad selection object: " + cell));
            }
            this.spreadsheet.selectCells(cellSelection);
            this.spreadsheet.showSelection();
        }
        this.fireSelectionChanged(selection);
    }

    @Override
    public void moveColumn(Object dragColumn, Object dropColumn, IGridController.DropLocation location) {
        if (dragColumn instanceof DBDAttributeBinding && dropColumn instanceof DBDAttributeBinding) {
            DBDDataFilter dataFilter = new DBDDataFilter(this.controller.getModel().getDataFilter());
            DBDAttributeConstraint dragC = dataFilter.getConstraint((DBDAttributeBinding)dragColumn);
            DBDAttributeConstraint dropC = dataFilter.getConstraint((DBDAttributeBinding)dropColumn);
            if (dragC == null || dropC == null) {
                return;
            }
            boolean pin = dragC.hasOption(ATTR_OPTION_PINNED) && dropC.hasOption(ATTR_OPTION_PINNED);
            int sourcePosition = SpreadsheetPresentation.getConstraintPosition(dragC, pin);
            int targetPosition = SpreadsheetPresentation.getConstraintPosition(dropC, pin);
            switch (location) {
                case DROP_AFTER: {
                    if (sourcePosition <= targetPosition || targetPosition >= dataFilter.getConstraints().size() - 1) break;
                    ++targetPosition;
                    break;
                }
                case DROP_BEFORE: {
                    if (sourcePosition >= targetPosition || targetPosition <= 0) break;
                    --targetPosition;
                    break;
                }
                case SWAP: {
                    SpreadsheetPresentation.setConstraintPosition(dropC, pin, sourcePosition);
                    SpreadsheetPresentation.setConstraintPosition(dragC, pin, targetPosition);
                }
            }
            if (sourcePosition == targetPosition) {
                return;
            }
            if (location != IGridController.DropLocation.SWAP) {
                List<DBDAttributeConstraint> constraints = SpreadsheetPresentation.getOrderedConstraints(dataFilter, pin);
                if (sourcePosition < targetPosition) {
                    int i = sourcePosition + 1;
                    while (i <= targetPosition) {
                        SpreadsheetPresentation.setConstraintPosition(constraints.get(i), pin, i - 1);
                        ++i;
                    }
                } else {
                    int i = sourcePosition - 1;
                    while (i >= targetPosition) {
                        SpreadsheetPresentation.setConstraintPosition(constraints.get(i), pin, i + 1);
                        --i;
                    }
                }
                SpreadsheetPresentation.setConstraintPosition(dragC, pin, targetPosition);
            }
            this.controller.setDataFilter(dataFilter, false);
            this.spreadsheet.setFocusColumn(targetPosition);
            this.spreadsheet.refreshData(false, true, false);
        }
    }

    private static int getConstraintPosition(@NotNull DBDAttributeConstraint constraint, boolean pin) {
        if (pin) {
            return (Integer)constraint.getOption(ATTR_OPTION_PINNED);
        }
        return constraint.getVisualPosition();
    }

    private static void setConstraintPosition(@NotNull DBDAttributeConstraint constraint, boolean pin, int position) {
        if (pin) {
            constraint.setOption(ATTR_OPTION_PINNED, (Object)position);
        } else {
            constraint.setVisualPosition(position);
        }
    }

    @NotNull
    private static List<DBDAttributeConstraint> getOrderedConstraints(@NotNull DBDDataFilter filter, boolean pin) {
        List constraints = filter.getConstraints();
        if (pin) {
            return constraints.stream().filter(x -> x.hasOption(ATTR_OPTION_PINNED)).sorted(Comparator.comparing(x -> (Comparable)x.getOption(ATTR_OPTION_PINNED))).collect(Collectors.toList());
        }
        return constraints.stream().sorted(Comparator.comparing(DBDAttributeConstraintBase::getVisualPosition)).collect(Collectors.toList());
    }

    @Override
    public boolean isMaximizeSingleColumn() {
        return this.controller.isRecordMode();
    }

    public Color getBackgroundAdded() {
        return this.backgroundAdded;
    }

    public Color getBackgroundDeleted() {
        return this.backgroundDeleted;
    }

    public Color getBackgroundModified() {
        return this.backgroundModified;
    }

    public Color getBackgroundNormal() {
        return this.backgroundNormal;
    }

    public Color getBackgroundOdd() {
        return this.backgroundOdd;
    }

    private DBDDisplayFormat getValueRenderFormat(DBDAttributeBinding attr, Object value) {
        if (value instanceof Number && this.useNativeNumbersFormat) {
            return DBDDisplayFormat.NATIVE;
        }
        return DBDDisplayFormat.UI;
    }

    private boolean isShowAsCheckbox(DBDAttributeBinding attr) {
        return this.showBooleanAsCheckbox && attr.getPresentationAttribute().getDataKind() == DBPDataKind.BOOLEAN;
    }

    private class ContentProvider
    implements IGridContentProvider {
        private ContentProvider() {
        }

        @Override
        @NotNull
        public Object[] getElements(boolean horizontal) {
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetModel model = SpreadsheetPresentation.this.controller.getModel();
            if (horizontal) {
                if (!recordMode) {
                    return model.getVisibleAttributes().toArray();
                }
                int[] selectedRecords = SpreadsheetPresentation.this.controller.getSelectedRecords();
                Object[] rows = new Object[selectedRecords.length];
                int i = 0;
                while (i < selectedRecords.length) {
                    rows[i] = SpreadsheetPresentation.this.controller.getModel().getRow(selectedRecords[i]);
                    ++i;
                }
                return rows;
            }
            if (!recordMode) {
                return model.getAllRows().toArray();
            }
            Object[] columns = model.getVisibleAttributes().toArray(new DBDAttributeBinding[model.getVisibleAttributeCount()]);
            if (SpreadsheetPresentation.this.columnOrder != 0 && SpreadsheetPresentation.this.columnOrder != -1) {
                Arrays.sort(columns, (o1, o2) -> o1.getName().compareTo(o2.getName()) * (SpreadsheetPresentation.this.columnOrder == 128 ? 1 : -1));
            }
            return columns;
        }

        @Override
        @Nullable
        public Object[] getChildren(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                switch (binding.getDataKind()) {
                    case ARRAY: {
                        if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                            Object value;
                            ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                            if (curRow != null && (value = SpreadsheetPresentation.this.controller.getModel().getCellValue(binding, curRow)) instanceof DBDCollection && !DBUtils.isNullValue((Object)value)) {
                                return curRow.getCollectionData(binding, (DBDCollection)value).getElements();
                            }
                            return null;
                        }
                    }
                    case STRUCT: 
                    case DOCUMENT: 
                    case ANY: {
                        List<DBDAttributeBinding> children = SpreadsheetPresentation.this.controller.getModel().getVisibleAttributes(binding);
                        if (children == null) break;
                        return children.toArray();
                    }
                }
            }
            return null;
        }

        @Override
        public int getSortOrder(@Nullable Object column) {
            if (SpreadsheetPresentation.this.showAttrOrdering) {
                if (column instanceof DBDAttributeBinding) {
                    DBDAttributeBinding binding = (DBDAttributeBinding)column;
                    if (!binding.hasNestedBindings()) {
                        DBDAttributeConstraint co = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(binding);
                        if (co != null && co.getOrderPosition() > 0) {
                            return co.isOrderDescending() ? 1024 : 128;
                        }
                        return -1;
                    }
                } else if (column == null && SpreadsheetPresentation.this.controller.isRecordMode()) {
                    return SpreadsheetPresentation.this.columnOrder;
                }
            }
            return 0;
        }

        @Override
        public IGridContentProvider.ElementState getDefaultState(@NotNull Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                switch (binding.getAttribute().getDataKind()) {
                    case STRUCT: 
                    case DOCUMENT: 
                    case ANY: {
                        return IGridContentProvider.ElementState.EXPANDED;
                    }
                    case ARRAY: {
                        Object cellValue;
                        ResultSetRow curRow = SpreadsheetPresentation.this.controller.getCurrentRow();
                        if (curRow == null || !((cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(binding, curRow)) instanceof DBDCollection)) break;
                        if (((DBDCollection)cellValue).getItemCount() < 3) {
                            return IGridContentProvider.ElementState.EXPANDED;
                        }
                        if (DBUtils.isNullValue((Object)cellValue)) break;
                        return IGridContentProvider.ElementState.COLLAPSED;
                    }
                }
            }
            return IGridContentProvider.ElementState.NONE;
        }

        @Override
        public int getCellAlign(@Nullable Object colElement, Object rowElement) {
            if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                DBDAttributeBinding attr = (DBDAttributeBinding)colElement;
                ResultSetRow row = (ResultSetRow)rowElement;
                if (attr != null) {
                    DBPDataKind dataKind;
                    if (SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                        Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
                        if (row.isChanged(attr)) {
                            cellValue = row.getOriginalValue(attr);
                        }
                        if (cellValue instanceof Number) {
                            cellValue = ((Number)cellValue).byteValue() != 0;
                        }
                        if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                            switch (SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getAlignment()) {
                                case LEFT: {
                                    return 0;
                                }
                                case CENTER: {
                                    return 1;
                                }
                                case RIGHT: {
                                    return 2;
                                }
                            }
                        }
                    }
                    if ((dataKind = attr.getDataKind()) == DBPDataKind.NUMERIC && SpreadsheetPresentation.this.rightJustifyNumbers || dataKind == DBPDataKind.DATETIME && SpreadsheetPresentation.this.rightJustifyDateTime) {
                        return 2;
                    }
                }
            }
            return 0;
        }

        @Override
        @Nullable
        public Font getCellFont(@Nullable Object colElement, Object rowElement) {
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
            DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
            if (row != null && attr != null && SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
                if (cellValue instanceof Number) {
                    cellValue = ((Number)cellValue).byteValue() != 0;
                }
                if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                    return SpreadsheetPresentation.this.spreadsheet.getFont(SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getFontStyle());
                }
            }
            return null;
        }

        @Override
        public int getColumnPinIndex(@NotNull Object element) {
            if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                DBDAttributeBinding attr = (DBDAttributeBinding)element;
                DBDAttributeConstraint ac = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(attr);
                if (ac != null) {
                    Integer pinIndex = (Integer)ac.getOption(SpreadsheetPresentation.ATTR_OPTION_PINNED);
                    return pinIndex == null ? -1 : pinIndex;
                }
            }
            return -1;
        }

        @Override
        public boolean isElementSupportsFilter(Object element) {
            if (element instanceof DBDAttributeBinding) {
                return SpreadsheetPresentation.this.supportsAttributeFilter;
            }
            return false;
        }

        @Override
        public boolean isElementSupportsSort(@Nullable Object element) {
            return element instanceof DBDAttributeBinding;
        }

        @Override
        public boolean isElementReadOnly(Object element) {
            if (element instanceof DBDAttributeBinding) {
                return SpreadsheetPresentation.this.controller.getAttributeReadOnlyStatus((DBDAttributeBinding)element) != null;
            }
            return false;
        }

        @Override
        public boolean isGridReadOnly() {
            return SpreadsheetPresentation.this.controller.isAllAttributesReadOnly();
        }

        @Override
        public int getCellState(Object colElement, Object rowElement, String cellText) {
            int state = 0;
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
            if ((SpreadsheetPresentation.this.controller.getDecorator().getDecoratorFeatures() & 0x20L) != 0L) {
                ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
                Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
                if (SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                    state |= SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT ? 8 : 1;
                } else if (!CommonUtils.isEmpty((Collection)attr.getReferrers()) && !DBUtils.isNullValue((Object)value)) {
                    state |= 1;
                } else {
                    String strValue;
                    String string = strValue = cellText != null ? cellText : attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, DBDDisplayFormat.UI);
                    if (strValue.contains("://")) {
                        try {
                            new URL(strValue);
                            state |= 2;
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
            if (attr.isTransformed()) {
                state |= 4;
            }
            return state;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        @Nullable
        public Object getCellValue(Object colElement, Object rowElement, boolean formatString, boolean lockData) {
            String defaultValue;
            DBSEntityAttribute entityAttribute;
            DBDAttributeBinding attr = (DBDAttributeBinding)(rowElement instanceof DBDAttributeBinding ? rowElement : colElement);
            ResultSetRow row = (ResultSetRow)(colElement instanceof ResultSetRow ? colElement : rowElement);
            int rowNum = row.getVisualNumber();
            Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
            if (formatString && DBUtils.isNullValue((Object)value) && row.getState() == 2 && (entityAttribute = attr.getEntityAttribute()) != null && (defaultValue = entityAttribute.getDefaultValue()) != null && !"NULL".equalsIgnoreCase(defaultValue)) {
                value = defaultValue;
            }
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            if (!lockData && rowNum > 0 && rowNum == SpreadsheetPresentation.this.controller.getModel().getRowCount() - 1 && SpreadsheetPresentation.this.autoFetchSegments && (recordMode || SpreadsheetPresentation.this.spreadsheet.isRowVisible(rowNum)) && SpreadsheetPresentation.this.controller.isHasMoreData()) {
                SpreadsheetPresentation.this.controller.readNextSegment();
            }
            if (value instanceof DBDValueError) {
                return ((DBDValueError)value).getErrorTitle();
            }
            if (SpreadsheetPresentation.this.isShowAsCheckbox(attr)) {
                if (formatString) {
                    if (SpreadsheetPresentation.this.booleanStyles.getMode() != BooleanMode.TEXT) {
                        return "";
                    }
                    if (value instanceof Number) {
                        value = ((Number)value).byteValue() != 0;
                    }
                    if (SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT && (DBUtils.isNullValue((Object)value) || value instanceof Boolean)) {
                        return SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)value).getText();
                    }
                }
                return value;
            }
            if (formatString) {
                if (recordMode) {
                    if (attr.getDataKind() == DBPDataKind.ARRAY && value instanceof DBDCollection && !DBUtils.isNullValue((Object)value)) {
                        return "[" + ((DBDCollection)value).getItemCount() + "]";
                    }
                    if (attr.getDataKind() == DBPDataKind.STRUCT && value instanceof DBDComposite && !DBUtils.isNullValue((Object)value)) {
                        return "[" + ((DBDComposite)value).getDataType().getName() + "]";
                    }
                }
                try {
                    return attr.getValueRenderer().getValueDisplayString((DBSTypedObject)attr.getAttribute(), value, SpreadsheetPresentation.this.getValueRenderFormat(attr, value));
                }
                catch (Exception e) {
                    return new DBDValueError((Throwable)e);
                }
            }
            return value;
        }

        @Override
        @Nullable
        public DBPImage getCellImage(Object colElement, Object rowElement) {
            DBDAttributeBinding attr;
            if (SpreadsheetPresentation.this.booleanStyles.getMode() != BooleanMode.TEXT && SpreadsheetPresentation.this.isShowAsCheckbox(attr = (DBDAttributeBinding)(rowElement instanceof DBDAttributeBinding ? rowElement : colElement))) {
                ResultSetRow row = (ResultSetRow)(colElement instanceof ResultSetRow ? colElement : rowElement);
                Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
                if (cellValue instanceof Number) {
                    cellValue = ((Number)cellValue).byteValue() != 0;
                }
                if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                    return SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getIcon();
                }
                return null;
            }
            return null;
        }

        @Override
        @NotNull
        public String getCellText(Object colElement, Object rowElement) {
            return String.valueOf(this.getCellValue(colElement, rowElement, true, false));
        }

        @Override
        @Nullable
        public Color getCellForeground(Object colElement, Object rowElement, boolean selected) {
            if (selected) {
                return SpreadsheetPresentation.this.foregroundSelected;
            }
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetRow row = (ResultSetRow)(!recordMode ? rowElement : colElement);
            DBDAttributeBinding attribute = (DBDAttributeBinding)(!recordMode ? colElement : rowElement);
            if (SpreadsheetPresentation.this.isShowAsCheckbox(attribute) && SpreadsheetPresentation.this.booleanStyles.getMode() == BooleanMode.TEXT) {
                Object cellValue = SpreadsheetPresentation.this.controller.getModel().getCellValue(attribute, row);
                if (cellValue instanceof Number) {
                    cellValue = ((Number)cellValue).byteValue() != 0;
                }
                if (DBUtils.isNullValue((Object)cellValue) || cellValue instanceof Boolean) {
                    return UIUtils.getSharedColor((RGB)SpreadsheetPresentation.this.booleanStyles.getStyle((Boolean)cellValue).getColor());
                }
                return null;
            }
            Color fg = SpreadsheetPresentation.this.controller.getLabelProvider().getCellForeground(attribute, row);
            if (fg != null) {
                return fg;
            }
            return UIUtils.getContrastColor((Color)this.getCellBackground(colElement, rowElement, false));
        }

        @Override
        @Nullable
        public Color getCellBackground(Object colElement, Object rowElement, boolean selected) {
            return this.getCellBackground(colElement, rowElement, selected, SpreadsheetPresentation.this.getController().isRecordMode());
        }

        private Color getCellBackground(Object colElement, Object rowElement, boolean cellSelected, boolean ignoreRowSelection) {
            if (cellSelected) {
                Color normalColor = this.getCellBackground(colElement, rowElement, false, true);
                if (normalColor == null || normalColor == SpreadsheetPresentation.this.backgroundNormal) {
                    return SpreadsheetPresentation.this.backgroundSelected;
                }
                RGB mixRGB = UIUtils.blend((RGB)normalColor.getRGB(), (RGB)SpreadsheetPresentation.this.backgroundSelected.getRGB(), (int)50);
                return UIUtils.getSharedTextColors().getColor(mixRGB);
            }
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            ResultSetRow row = (ResultSetRow)(!recordMode ? rowElement : colElement);
            DBDAttributeBinding attribute = (DBDAttributeBinding)(!recordMode ? colElement : rowElement);
            SpreadsheetFindReplaceTarget findReplaceTarget = SpreadsheetFindReplaceTarget.getInstance().owned(SpreadsheetPresentation.this);
            if (findReplaceTarget.isSessionActive()) {
                String cellText;
                Pattern searchPattern;
                boolean inScope;
                boolean hasScope = SpreadsheetPresentation.this.highlightScopeFirstLine >= 0 && SpreadsheetPresentation.this.highlightScopeLastLine >= 0;
                boolean bl = inScope = hasScope && row.getVisualNumber() >= SpreadsheetPresentation.this.highlightScopeFirstLine && row.getVisualNumber() <= SpreadsheetPresentation.this.highlightScopeLastLine;
                if ((!hasScope || inScope) && (searchPattern = findReplaceTarget.getSearchPattern()) != null && searchPattern.matcher(cellText = CommonUtils.toString((Object)this.getCellValue(colElement, rowElement, false, false))).find()) {
                    return SpreadsheetPresentation.this.backgroundMatched;
                }
                if (!recordMode && inScope) {
                    return SpreadsheetPresentation.this.highlightScopeColor != null ? SpreadsheetPresentation.this.highlightScopeColor : SpreadsheetPresentation.this.backgroundSelected;
                }
            }
            if (!ignoreRowSelection && SpreadsheetPresentation.this.highlightRowsWithSelectedCells && SpreadsheetPresentation.this.spreadsheet.isRowSelected(row.getVisualNumber())) {
                RGB mixRGB;
                Color selectedCellColor;
                Color normalColor = this.getCellBackground(colElement, rowElement, false, true);
                if (normalColor == null || normalColor == SpreadsheetPresentation.this.backgroundNormal) {
                    selectedCellColor = SpreadsheetPresentation.this.backgroundSelected;
                } else {
                    mixRGB = UIUtils.blend((RGB)normalColor.getRGB(), (RGB)SpreadsheetPresentation.this.backgroundSelected.getRGB(), (int)50);
                    selectedCellColor = UIUtils.getSharedTextColors().getColor(mixRGB);
                }
                mixRGB = UIUtils.blend((RGB)selectedCellColor.getRGB(), (RGB)normalColor.getRGB(), (int)25);
                return UIUtils.getSharedTextColors().getColor(mixRGB);
            }
            switch (row.getState()) {
                case 2: {
                    return SpreadsheetPresentation.this.backgroundAdded;
                }
                case 3: {
                    return SpreadsheetPresentation.this.backgroundDeleted;
                }
            }
            if (row.changes != null && row.changes.containsKey(attribute)) {
                return SpreadsheetPresentation.this.backgroundModified;
            }
            Color bg = SpreadsheetPresentation.this.controller.getLabelProvider().getCellBackground(attribute, row);
            if (bg != null) {
                return bg;
            }
            if (!recordMode && SpreadsheetPresentation.this.showOddRows) {
                int rowNumber;
                int rowRelativeNumber;
                boolean odd;
                if (SpreadsheetPresentation.this.rowBatchSize < 1) {
                    SpreadsheetPresentation.this.rowBatchSize = 1;
                }
                boolean bl = odd = (rowRelativeNumber = (rowNumber = row.getVisualNumber()) % (SpreadsheetPresentation.this.rowBatchSize * 2)) < SpreadsheetPresentation.this.rowBatchSize;
                if (odd) {
                    return SpreadsheetPresentation.this.backgroundOdd;
                }
            }
            if (SpreadsheetPresentation.this.backgroundNormal == null) {
                SpreadsheetPresentation.this.backgroundNormal = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            return SpreadsheetPresentation.this.backgroundNormal;
        }

        @Override
        public Color getCellHeaderForeground(Object element) {
            return SpreadsheetPresentation.this.cellHeaderForeground;
        }

        @Override
        public Color getCellHeaderBackground(Object element) {
            return SpreadsheetPresentation.this.cellHeaderBackground;
        }

        @Override
        public Color getCellHeaderSelectionBackground(Object element) {
            return SpreadsheetPresentation.this.cellHeaderSelectionBackground;
        }

        @Override
        @NotNull
        public String getCellLinkText(Object colElement, Object rowElement) {
            boolean recordMode = SpreadsheetPresentation.this.controller.isRecordMode();
            DBDAttributeBinding attr = (DBDAttributeBinding)(recordMode ? rowElement : colElement);
            ResultSetRow row = (ResultSetRow)(recordMode ? colElement : rowElement);
            Object value = SpreadsheetPresentation.this.controller.getModel().getCellValue(attr, row);
            List referrers = attr.getReferrers();
            if (!CommonUtils.isEmpty((Collection)referrers) && !DBUtils.isNullValue((Object)value)) {
                StringBuilder text = new StringBuilder();
                for (DBSEntityReferrer ref : referrers) {
                    DBSEntity associatedEntity;
                    if (!(ref instanceof DBSEntityAssociation) || (associatedEntity = ResultSetUtils.getAssociatedEntity((DBSEntityConstraint)ref)) == null) continue;
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    text.append(DBUtils.getObjectFullName((DBPNamedObject)associatedEntity, (DBPEvaluationContext)DBPEvaluationContext.UI));
                }
                return text.toString();
            }
            return "";
        }

        @Override
        public void resetColors() {
            SpreadsheetPresentation.this.backgroundNormal = null;
            SpreadsheetPresentation.this.foregroundDefault = null;
        }
    }

    private class GridLabelProvider
    implements IGridLabelProvider {
        private GridLabelProvider() {
        }

        @Override
        @Nullable
        public Image getImage(Object element) {
            if (element instanceof DBDAttributeBinding && SpreadsheetPresentation.this.showAttributeIcons) {
                DBDAttributeBinding attr = (DBDAttributeBinding)element;
                DBPImage objectImage = DBValueFormatting.getObjectImage((DBPObject)attr.getAttribute());
                if (!SpreadsheetPresentation.this.controller.getModel().isUpdateInProgress() && (SpreadsheetPresentation.this.controller.getDecorator().getDecoratorFeatures() & 8L) != 0L && SpreadsheetPresentation.this.controller.getAttributeReadOnlyStatus(attr) != null && !SpreadsheetPresentation.this.controller.isAllAttributesReadOnly()) {
                    objectImage = new DBIconComposite(objectImage, false, null, null, null, (DBPImage)DBIcon.OVER_LOCK);
                }
                return DBeaverIcons.getImage((DBPImage)objectImage);
            }
            return null;
        }

        @Override
        public Object getGridOption(String option) {
            if ("OPTION_EXCLUDE_COLUMN_NAME_FOR_WIDTH_CALC".equals(option)) {
                return SpreadsheetPresentation.this.calcColumnWidthByValue;
            }
            return null;
        }

        @Nullable
        public Color getForeground(Object element) {
            if (element == null) {
                if (SpreadsheetPresentation.this.foregroundDefault == null) {
                    SpreadsheetPresentation.this.foregroundDefault = SpreadsheetPresentation.this.controller.getDefaultForeground();
                }
                return SpreadsheetPresentation.this.foregroundDefault;
            }
            return null;
        }

        @Nullable
        public Color getBackground(Object element) {
            if (SpreadsheetPresentation.this.backgroundNormal == null) {
                SpreadsheetPresentation.this.backgroundNormal = SpreadsheetPresentation.this.controller.getDefaultBackground();
            }
            if (element == null) {
                return SpreadsheetPresentation.this.backgroundNormal;
            }
            return null;
        }

        @Override
        @NotNull
        public String getText(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                if (CommonUtils.isEmpty((String)attributeBinding.getLabel())) {
                    return CommonUtils.notEmpty((String)attributeBinding.getName());
                }
                return attributeBinding.getLabel();
            }
            String rowNumber = String.valueOf(((ResultSetRow)element).getVisualNumber() + 1);
            if (!SpreadsheetPresentation.this.controller.isRecordMode()) {
                return rowNumber;
            }
            return String.valueOf(ResultSetMessages.controls_resultset_viewer_status_row) + " #" + rowNumber;
        }

        @Override
        @Nullable
        public String getDescription(Object element) {
            if (!SpreadsheetPresentation.this.showAttributeDescription) {
                return null;
            }
            if (element instanceof DBDAttributeBinding) {
                return ((DBDAttributeBinding)element).getDescription();
            }
            return null;
        }

        @Nullable
        public Font getFont(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = SpreadsheetPresentation.this.controller.getModel().getDataFilter().getConstraint(attributeBinding);
                if (constraint != null && constraint.hasCondition()) {
                    return SpreadsheetPresentation.this.spreadsheet.getFont(UIElementFontStyle.BOLD);
                }
                if (attributeBinding.isTransformed()) {
                    return SpreadsheetPresentation.this.spreadsheet.getFont(UIElementFontStyle.ITALIC);
                }
            }
            return null;
        }

        @Nullable
        public String getToolTipText(Object element) {
            if (element instanceof DBDAttributeBinding) {
                DBDAttributeBinding attributeBinding = (DBDAttributeBinding)element;
                String name = attributeBinding.getName();
                String typeName = attributeBinding.getFullTypeName();
                String description = attributeBinding.getDescription();
                String tip = CommonUtils.isEmpty((String)description) ? String.valueOf(name) + ": " + typeName : String.valueOf(name) + ": " + typeName + "\n" + description;
                String readOnlyStatus = SpreadsheetPresentation.this.controller.getAttributeReadOnlyStatus(attributeBinding);
                if (readOnlyStatus != null) {
                    tip = String.valueOf(tip) + " (Read-only: " + readOnlyStatus + ")";
                }
                return tip;
            }
            return null;
        }
    }

    private class SpreadsheetSelectionImpl
    implements IResultSetSelection,
    IResultSetSelectionExt {
        private SpreadsheetSelectionImpl() {
        }

        @Nullable
        public GridPos getFirstElement() {
            Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
            if (ssSelection.isEmpty()) {
                return null;
            }
            return ssSelection.iterator().next();
        }

        @NotNull
        public Iterator<GridPos> iterator() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().iterator();
        }

        public int size() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().size();
        }

        public Object[] toArray() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().toArray();
        }

        public List<GridPos> toList() {
            return new ArrayList<GridPos>(SpreadsheetPresentation.this.spreadsheet.getSelection());
        }

        public boolean isEmpty() {
            return SpreadsheetPresentation.this.spreadsheet.getSelection().isEmpty();
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return SpreadsheetPresentation.this.getController();
        }

        @Override
        @NotNull
        public List<DBDAttributeBinding> getSelectedAttributes() {
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                Object[] elements = SpreadsheetPresentation.this.spreadsheet.getContentProvider().getElements(false);
                ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
                ArrayList<Integer> rowSelection = new ArrayList<Integer>(SpreadsheetPresentation.this.spreadsheet.getRowSelection());
                Collections.sort(rowSelection);
                for (Integer row : rowSelection) {
                    if (row >= elements.length) continue;
                    attrs.add((DBDAttributeBinding)elements[row]);
                }
                return attrs;
            }
            ArrayList<DBDAttributeBinding> attrs = new ArrayList<DBDAttributeBinding>();
            for (Object row : SpreadsheetPresentation.this.spreadsheet.getColumnSelection()) {
                attrs.add((DBDAttributeBinding)row);
            }
            return attrs;
        }

        @Override
        @NotNull
        public List<ResultSetRow> getSelectedRows() {
            ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
            if (SpreadsheetPresentation.this.controller.isRecordMode()) {
                for (Object col : SpreadsheetPresentation.this.spreadsheet.getColumnSelection()) {
                    if (!(col instanceof ResultSetRow)) continue;
                    rows.add((ResultSetRow)col);
                }
            } else {
                for (Integer row : SpreadsheetPresentation.this.spreadsheet.getRowSelection()) {
                    rows.add(SpreadsheetPresentation.this.controller.getModel().getRow(row));
                }
            }
            rows.sort(Comparator.comparingInt(ResultSetRow::getVisualNumber));
            return rows;
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            GridPos pos = (GridPos)element;
            return (DBDAttributeBinding)(SpreadsheetPresentation.this.controller.isRecordMode() ? SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row) : SpreadsheetPresentation.this.spreadsheet.getColumnElement(pos.col));
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return SpreadsheetPresentation.this.controller.isRecordMode() ? SpreadsheetPresentation.this.controller.getCurrentRow() : SpreadsheetPresentation.this.spreadsheet.getRowElement(((GridPos)element).row);
        }

        @Override
        public int getSelectedColumnCount() {
            return SpreadsheetPresentation.this.spreadsheet.getColumnSelectionSize();
        }

        @Override
        public int getSelectedRowCount() {
            return SpreadsheetPresentation.this.spreadsheet.getRowSelectionSize();
        }

        @Override
        public int getSelectedCellCount() {
            return SpreadsheetPresentation.this.spreadsheet.getCellSelectionSize();
        }
    }

    public class SpreadsheetValueController
    extends ResultSetValueController
    implements IMultiController {
        SpreadsheetValueController(@NotNull IResultSetController controller, @NotNull DBDAttributeBinding binding, @NotNull ResultSetRow row, @Nullable IValueController.EditType editType, Composite inlinePlaceholder) {
            super(controller, binding, row, editType, inlinePlaceholder);
        }

        @Override
        public Object getValue() {
            return SpreadsheetPresentation.this.spreadsheet.getContentProvider().getCellValue(this.curRow, this.binding, false, false);
        }

        @Override
        public void closeInlineEditor() {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
        }

        @Override
        public void nextInlineEditor(boolean next) {
            SpreadsheetPresentation.this.spreadsheet.cancelInlineEditor();
            int colOffset = next ? 1 : -1;
            int rowOffset = 0;
            int colCount = SpreadsheetPresentation.this.spreadsheet.getColumnCount();
            GridPos curPosition = SpreadsheetPresentation.this.spreadsheet.getCursorPosition();
            if (colOffset > 0 && curPosition.col + colOffset >= colCount) {
                colOffset = -colCount;
                rowOffset = 1;
            } else if (colOffset < 0 && curPosition.col + colOffset < 0) {
                colOffset = colCount;
                rowOffset = -1;
            }
            SpreadsheetPresentation.this.spreadsheet.shiftCursor(colOffset, rowOffset, false);
            SpreadsheetPresentation.this.openValueEditor(true);
        }

        @Override
        public void updateValue(@Nullable Object value, boolean updatePresentation) {
            super.updateValue(value, updatePresentation);
            if (updatePresentation) {
                SpreadsheetPresentation.this.spreadsheet.redrawGrid();
            }
        }

        @Override
        public void updateSelectionValue(Object value) {
            DBDAttributeBinding origAttr = this.getBinding();
            ResultSetRow origRow = this.getCurRow();
            try {
                Collection<GridPos> ssSelection = SpreadsheetPresentation.this.spreadsheet.getSelection();
                for (GridPos pos : ssSelection) {
                    ResultSetRow row;
                    DBDAttributeBinding attr;
                    if (this.controller.isRecordMode()) {
                        attr = (DBDAttributeBinding)SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row);
                        row = this.controller.getCurrentRow();
                    } else {
                        attr = (DBDAttributeBinding)SpreadsheetPresentation.this.spreadsheet.getColumnElement(pos.col);
                        row = (ResultSetRow)SpreadsheetPresentation.this.spreadsheet.getRowElement(pos.row);
                    }
                    if (attr == null || row == null || attr.getValueHandler() != origAttr.getValueHandler() || this.controller.getAttributeReadOnlyStatus(attr) != null) continue;
                    this.setBinding(attr);
                    this.setCurRow(row);
                    this.updateValue(value, false);
                }
                SpreadsheetPresentation.this.spreadsheet.redrawGrid();
                this.controller.updatePanelsContent(false);
            }
            finally {
                this.setBinding(origAttr);
                this.setCurRow(origRow);
            }
        }

        void registerEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.put(this, editor);
        }

        void unregisterEditor(IValueEditorStandalone editor) {
            SpreadsheetPresentation.this.openEditors.remove(this);
        }
    }

    private static class ViewState {
        DBDAttributeBinding focusedAttribute;
        int hScrollSelection;

        ViewState(DBDAttributeBinding focusedAttribute, int hScrollSelection) {
            this.focusedAttribute = focusedAttribute;
            this.hScrollSelection = hScrollSelection;
        }
    }
}

