/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferEventProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.DataTransferPageNodeSettings;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StreamConsumerPageOutput
extends DataTransferPageNodeSettings {
    private static final Log log = Log.getLog(StreamConsumerPageOutput.class);
    private Combo encodingCombo;
    private Button encodingBOMCheckbox;
    private Text timestampPattern;
    private Text directoryText;
    private Text fileNameText;
    private Button compressCheckbox;
    private Button clipboardCheck;
    private Button singleFileCheck;
    private Button showFinalMessageCheckbox;
    private Button splitFilesCheckbox;
    private Button appendToEndOfFileCheck;
    private Label maximumFileSizeLabel;
    private Text maximumFileSizeText;
    private final Map<String, EventProcessorComposite> processors = new HashMap<String, EventProcessorComposite>();

    public StreamConsumerPageOutput() {
        super(DTMessages.data_transfer_wizard_output_name);
        this.setTitle(DTMessages.data_transfer_wizard_output_title);
        this.setDescription(DTMessages.data_transfer_wizard_output_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        final StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.data_transfer_wizard_output_group_general, (int)5, (int)768, (int)0);
        this.clipboardCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_copy_to_clipboard, null, (boolean)false, (int)5);
        this.clipboardCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputClipboard(StreamConsumerPageOutput.this.clipboardCheck.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.directoryText = DialogUtils.createOutputFolderChooser((Composite)generalSettings, null, e -> {
            settings.setOutputFolder(this.directoryText.getText());
            this.updatePageCompletion();
        });
        ((GridData)this.directoryText.getParent().getLayoutData()).horizontalSpan = 4;
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_file_name_pattern);
        this.fileNameText = new Text((Composite)generalSettings, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 4;
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(e -> {
            settings.setOutputFilePattern(this.fileNameText.getText());
            this.updatePageCompletion();
        });
        UIUtils.createControlLabel((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)generalSettings, (String)settings.getOutputEncoding());
        this.encodingCombo.addModifyListener(e -> {
            settings.setOutputEncoding(this.encodingCombo.getText());
            this.updatePageCompletion();
        });
        this.timestampPattern = UIUtils.createLabelText((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_timestamp_pattern, (String)"yyyyMMddHHmm", (int)2048);
        this.timestampPattern.addModifyListener(e -> settings.setOutputTimestampPattern(this.timestampPattern.getText()));
        this.encodingBOMCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_insert_bom, (String)DTMessages.data_transfer_wizard_output_label_insert_bom_tooltip, (boolean)false, (int)1);
        this.encodingBOMCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOutputEncodingBOM(StreamConsumerPageOutput.this.encodingBOMCheckbox.getSelection());
            }
        });
        this.appendToEndOfFileCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_add_to_end_of_file, (String)DTMessages.data_transfer_wizard_output_label_add_to_end_of_file_tip, (boolean)true, (int)1);
        this.appendToEndOfFileCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setAppendToFileEnd(StreamConsumerPageOutput.this.appendToEndOfFileCheck.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
            }
        });
        this.singleFileCheck = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_label_use_single_file, (String)DTMessages.data_transfer_wizard_output_label_use_single_file_tip, (boolean)false, (int)5);
        this.singleFileCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseSingleFile(StreamConsumerPageOutput.this.singleFileCheck.getSelection());
                StreamConsumerPageOutput.this.updatePageCompletion();
            }
        });
        this.compressCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_compress, null, (boolean)false, (int)1);
        this.compressCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCompressResults(StreamConsumerPageOutput.this.compressCheckbox.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
            }
        });
        Composite outFilesSettings = UIUtils.createComposite((Composite)generalSettings, (int)3);
        outFilesSettings.setLayoutData((Object)new GridData(1, 1, true, false, 5, 1));
        this.splitFilesCheckbox = UIUtils.createCheckbox((Composite)outFilesSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_split_files, (String)DTMessages.data_transfer_wizard_output_checkbox_split_files_tip, (boolean)false, (int)1);
        this.splitFilesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setSplitOutFiles(StreamConsumerPageOutput.this.splitFilesCheckbox.getSelection());
                StreamConsumerPageOutput.this.updateControlsEnablement();
            }
        });
        this.maximumFileSizeLabel = UIUtils.createControlLabel((Composite)outFilesSettings, (String)DTUIMessages.stream_consumer_page_output_label_maximum_file_size);
        this.maximumFileSizeText = new Text(outFilesSettings, 2048);
        this.maximumFileSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        this.maximumFileSizeText.addModifyListener(e -> settings.setMaxOutFileSize(CommonUtils.toLong((Object)this.maximumFileSizeText.getText())));
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.maximumFileSizeText) * 10;
        this.maximumFileSizeText.setLayoutData((Object)gd);
        new VariablesHintLabel((Composite)generalSettings, DTUIMessages.stream_consumer_page_output_variables_hint_label, DTUIMessages.stream_consumer_page_output_variables_hint_label, StreamTransferConsumer.VARIABLES, true);
        Group resultsSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.stream_consumer_page_output_label_results, (int)1, (int)768, (int)0);
        this.showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)resultsSettings, (String)DTUIMessages.stream_consumer_page_output_label_show_finish_message, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        this.showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)StreamConsumerPageOutput.this.getWizard()).getSettings().setShowFinalMessage(StreamConsumerPageOutput.this.showFinalMessageCheckbox.getSelection());
            }
        });
        DataTransferRegistry dataTransferRegistry = DataTransferRegistry.getInstance();
        UIPropertyConfiguratorRegistry configuratorRegistry = UIPropertyConfiguratorRegistry.getInstance();
        for (DataTransferEventProcessorDescriptor descriptor : dataTransferRegistry.getEventProcessors("streamTransferConsumer")) {
            try {
                UIPropertyConfiguratorDescriptor configuratorDescriptor = configuratorRegistry.getDescriptor(descriptor.getType().getImplName());
                IDataTransferEventProcessorConfigurator configurator = (IDataTransferEventProcessorConfigurator)configuratorDescriptor.createConfigurator();
                this.processors.put(descriptor.getId(), new EventProcessorComposite((Composite)resultsSettings, settings, descriptor, configurator));
            }
            catch (Exception e2) {
                log.error((Object)"Can't create event processor", (Throwable)e2);
            }
        }
        String[] variables = this.getAvailableVariables();
        StringContentProposalProvider proposalProvider = new StringContentProposalProvider((String[])Arrays.stream(variables).map(GeneralUtils::variablePattern).toArray(String[]::new));
        UIUtils.setContentProposalToolTip((Control)this.directoryText, (String)DTUIMessages.stream_consumer_page_output_tooltip_output_directory_pattern, (String[])variables);
        UIUtils.setContentProposalToolTip((Control)this.fileNameText, (String)DTUIMessages.stream_consumer_page_output_tooltip_output_file_name_pattern, (String[])variables);
        ContentAssistUtils.installContentProposal((Control)this.directoryText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)proposalProvider);
        ContentAssistUtils.installContentProposal((Control)this.fileNameText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)proposalProvider);
        this.setControl((Control)composite);
    }

    private void updateControlsEnablement() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        boolean clipboard = !isBinary && this.clipboardCheck.getSelection();
        boolean isMulti = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().size() > 1;
        this.singleFileCheck.getSelection();
        boolean addToEnd = this.appendToEndOfFileCheck.getSelection();
        boolean compress = this.compressCheckbox.getSelection();
        this.clipboardCheck.setEnabled(!isBinary);
        this.singleFileCheck.setEnabled(isMulti && !clipboard && ((DataTransferWizard)this.getWizard()).getSettings().getMaxJobCount() <= 1);
        this.directoryText.setEnabled(!clipboard);
        this.fileNameText.setEnabled(!clipboard);
        this.compressCheckbox.setEnabled(!clipboard && !addToEnd);
        this.splitFilesCheckbox.setEnabled(!clipboard);
        this.appendToEndOfFileCheck.setEnabled(!clipboard && !compress);
        this.maximumFileSizeLabel.setEnabled(!clipboard && this.splitFilesCheckbox.getSelection());
        this.maximumFileSizeText.setEnabled(!clipboard && this.splitFilesCheckbox.getSelection());
        this.encodingCombo.setEnabled(!isBinary && !clipboard);
        this.encodingBOMCheckbox.setEnabled(!isBinary && !clipboard);
        this.timestampPattern.setEnabled(!clipboard);
        for (EventProcessorComposite processor : this.processors.values()) {
            processor.setProcessorAvailable(processor.isProcessorApplicable());
        }
    }

    public void activatePage() {
        boolean isBinary = ((DataTransferWizard)this.getWizard()).getSettings().getProcessor().isBinaryFormat();
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        this.clipboardCheck.setSelection(settings.isOutputClipboard());
        this.singleFileCheck.setSelection(settings.isUseSingleFile());
        this.appendToEndOfFileCheck.setSelection(settings.isAppendToFileEnd());
        this.directoryText.setText(CommonUtils.toString((Object)settings.getOutputFolder()));
        this.fileNameText.setText(CommonUtils.toString((Object)settings.getOutputFilePattern()));
        this.compressCheckbox.setSelection(settings.isCompressResults());
        this.splitFilesCheckbox.setSelection(settings.isSplitOutFiles());
        this.maximumFileSizeText.setText(String.valueOf(settings.getMaxOutFileSize()));
        this.encodingCombo.setText(CommonUtils.toString((Object)settings.getOutputEncoding()));
        this.timestampPattern.setText(settings.getOutputTimestampPattern());
        this.encodingBOMCheckbox.setSelection(settings.isOutputEncodingBOM());
        if (isBinary) {
            this.clipboardCheck.setSelection(false);
            this.encodingBOMCheckbox.setSelection(false);
            settings.setOutputClipboard(false);
        }
        this.showFinalMessageCheckbox.setSelection(((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage());
        for (Map.Entry<String, EventProcessorComposite> processor : this.processors.entrySet()) {
            processor.getValue().setProcessorEnabled(settings.hasEventProcessor(processor.getKey()));
            processor.getValue().loadSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
        this.updatePageCompletion();
        this.updateControlsEnablement();
    }

    public void deactivatePage() {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        for (Map.Entry<String, EventProcessorComposite> processor : this.processors.entrySet()) {
            EventProcessorComposite configurator = processor.getValue();
            if (!configurator.isProcessorEnabled() || !configurator.isProcessorApplicable() || !configurator.isProcessorComplete()) continue;
            configurator.saveSettings(settings.getEventProcessorSettings(processor.getKey()));
        }
    }

    protected boolean determinePageCompletion() {
        StreamConsumerSettings settings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamConsumerSettings.class);
        if (settings == null) {
            return false;
        }
        if (settings.isOutputClipboard()) {
            return true;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFolder())) {
            this.setErrorMessage(DTMessages.data_transfer_wizard_output_error_empty_output_directory);
            return false;
        }
        if (CommonUtils.isEmpty((String)settings.getOutputFilePattern())) {
            this.setErrorMessage(DTMessages.data_transfer_wizard_output_error_empty_output_filename);
            return false;
        }
        try {
            Charset.forName(settings.getOutputEncoding());
        }
        catch (Exception exception) {
            this.setErrorMessage(DTMessages.data_transfer_wizard_output_error_invalid_charset);
            return false;
        }
        for (EventProcessorComposite processor : this.processors.values()) {
            if (!processor.isProcessorApplicable() || !processor.isProcessorEnabled() || processor.isProcessorComplete()) continue;
            this.setErrorMessage(NLS.bind((String)DTMessages.data_transfer_wizard_output_event_processor_error_incomplete_configuration, (Object)processor.descriptor.getLabel()));
            return false;
        }
        return true;
    }

    @NotNull
    private String[] getAvailableVariables() {
        DBSObject object;
        SQLQueryContainer container;
        Set variables = Arrays.stream(StreamTransferConsumer.VARIABLES).map(x -> x[0]).collect(Collectors.toCollection(LinkedHashSet::new));
        List pipes = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes();
        if (pipes.size() == 1 && (container = (SQLQueryContainer)DBUtils.getAdapter(SQLQueryContainer.class, (Object)(object = ((DataTransferPipe)pipes.get(0)).getProducer().getDatabaseObject()))) != null) {
            variables.addAll(container.getQueryParameters().keySet());
        }
        return variables.toArray(new String[0]);
    }

    public boolean isPageApplicable() {
        return this.isConsumerOfType(StreamTransferConsumer.class);
    }

    private static class ConfigureDialog
    extends BaseDialog {
        private final IDataTransferEventProcessorConfigurator configurator;

        public ConfigureDialog(@NotNull Shell shell, @NotNull DataTransferEventProcessorDescriptor descriptor, @NotNull IDataTransferEventProcessorConfigurator configurator) {
            super(shell, NLS.bind((String)DTMessages.data_transfer_wizard_output_event_processor_configure_title, (Object)descriptor.getLabel()), null);
            this.configurator = configurator;
            this.setShellStyle(67696);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            this.configurator.createControl(composite, this::updateCompletion);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.updateCompletion();
        }

        private void updateCompletion() {
            this.getButton(0).setEnabled(this.configurator.isComplete());
        }
    }

    private class EventProcessorComposite
    extends Composite {
        private final DataTransferEventProcessorDescriptor descriptor;
        private final IDataTransferEventProcessorConfigurator configurator;
        private final StreamConsumerSettings settings;
        private final Button enabledCheckbox;
        private Link configureLink;

        public EventProcessorComposite(@NotNull Composite parent, @NotNull StreamConsumerSettings settings, final @Nullable DataTransferEventProcessorDescriptor descriptor, final IDataTransferEventProcessorConfigurator configurator) {
            super(parent, 0);
            this.descriptor = descriptor;
            this.configurator = configurator;
            this.settings = settings;
            boolean hasControl = configurator != null && configurator.hasControl();
            this.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
            this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(hasControl ? 2 : 1).create());
            this.enabledCheckbox = UIUtils.createCheckbox((Composite)this, (String)descriptor.getLabel(), (String)descriptor.getDescription(), (boolean)false, (int)1);
            this.enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EventProcessorComposite.this.setProcessorEnabled(EventProcessorComposite.this.enabledCheckbox.getSelection());
                }
            });
            if (hasControl) {
                this.configureLink = UIUtils.createLink((Composite)this, (String)DTMessages.data_transfer_wizard_output_event_processor_configure, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ConfigureDialog dialog = new ConfigureDialog(EventProcessorComposite.this.getShell(), descriptor, configurator);
                        if (dialog.open() == 0) {
                            StreamConsumerPageOutput.this.updatePageCompletion();
                        }
                    }
                });
            }
            UIUtils.asyncExec(() -> this.setProcessorEnabled(settings.hasEventProcessor(descriptor.getId())));
        }

        public void loadSettings(@NotNull Map<String, Object> settings) {
            this.configurator.loadSettings(settings);
        }

        public void saveSettings(@NotNull Map<String, Object> settings) {
            this.configurator.saveSettings(settings);
        }

        public boolean isProcessorEnabled() {
            return this.enabledCheckbox.getEnabled() && this.enabledCheckbox.getSelection();
        }

        public boolean isProcessorApplicable() {
            return this.configurator != null && this.configurator.isApplicable(this.settings);
        }

        public boolean isProcessorComplete() {
            return this.configurator.isComplete();
        }

        public void setProcessorAvailable(boolean available) {
            this.setProcessorEnabled(this.enabledCheckbox.getSelection(), available);
        }

        public void setProcessorEnabled(boolean enabled) {
            this.setProcessorEnabled(enabled, this.enabledCheckbox.getEnabled());
        }

        private void setProcessorEnabled(boolean enabled, boolean available) {
            this.enabledCheckbox.setSelection(enabled);
            this.enabledCheckbox.setEnabled(available);
            if (this.configurator.hasControl()) {
                this.configureLink.setEnabled(enabled && available);
            }
            if (enabled && available) {
                this.settings.addEventProcessor(this.descriptor.getId());
            } else {
                this.settings.removeEventProcessor(this.descriptor.getId());
            }
            StreamConsumerPageOutput.this.updatePageCompletion();
        }
    }
}

