/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.ProductBundleRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DriverUtils {
    private static final Log log = Log.getLog(DriverUtils.class);
    public static final String ZIP_EXTRACT_DIR = "zip-cache";

    public static boolean matchesBundle(IConfigurationElement config) {
        String bundle = config.getAttribute("bundle");
        if (!CommonUtils.isEmpty((String)bundle)) {
            boolean hasBundle;
            boolean not = false;
            if (bundle.startsWith("!")) {
                not = true;
                bundle = bundle.substring(1);
            }
            if (!(hasBundle = ProductBundleRegistry.getInstance().hasBundle(bundle)) && !not || hasBundle && not) {
                return false;
            }
        }
        return true;
    }

    static void copyZipStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] writeBuffer = new byte[16384];
        int br = inputStream.read(writeBuffer);
        while (br != -1) {
            outputStream.write(writeBuffer, 0, br);
            br = inputStream.read(writeBuffer);
        }
        outputStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<File> extractZipArchives(List<File> files) {
        if (files.isEmpty()) {
            return files;
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        block16: for (File inputFile : files) {
            jarFiles.add(inputFile);
            if (!inputFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) continue;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream is = new FileInputStream(inputFile);){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (ZipInputStream zipStream = new ZipInputStream(is);){
                        ZipEntry zipEntry;
                        while ((zipEntry = zipStream.getNextEntry()) != null) {
                            try {
                                if (zipEntry.isDirectory()) continue;
                                String zipEntryName = zipEntry.getName();
                                if (zipEntryName.endsWith(".class")) continue block16;
                                if (!zipEntryName.endsWith(".jar") && !zipEntryName.endsWith(".zip")) continue;
                                DriverUtils.checkAndExtractEntry(inputFile, zipStream, zipEntry, jarFiles);
                            }
                            finally {
                                zipStream.closeEntry();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error processing zip archive '" + inputFile.getName() + "': " + e.getMessage()));
            }
        }
        return jarFiles;
    }

    private static void checkAndExtractEntry(File sourceFile, InputStream zipStream, ZipEntry zipEntry, List<File> jarFiles) throws IOException {
        File localCacheDir;
        String sourceName = sourceFile.getName();
        if (sourceName.endsWith(".zip")) {
            sourceName = sourceName.substring(0, sourceName.length() - 4);
        }
        if (!(localCacheDir = new File(new File(DriverDescriptor.getCustomDriversHome().toFile(), ZIP_EXTRACT_DIR), sourceName)).exists() && !localCacheDir.mkdirs()) {
            throw new IOException("Can't create local cache folder '" + localCacheDir.getAbsolutePath() + "'");
        }
        File localFile = new File(localCacheDir, zipEntry.getName());
        jarFiles.add(localFile);
        if (localFile.exists()) {
            return;
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileOutputStream os = new FileOutputStream(localFile);){
            DriverUtils.copyZipStream(zipStream, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<DBPDataSourceContainer> getUsedBy(DBPDriver driver, List<DBPDataSourceContainer> containers) {
        ArrayList<DBPDataSourceContainer> usedBy = new ArrayList<DBPDataSourceContainer>();
        for (DBPDataSourceContainer ds : containers) {
            if (ds.getDriver() != driver) continue;
            usedBy.add(ds);
        }
        return usedBy;
    }

    public static List<DBPDriver> getRecentDrivers(List<DBPDriver> allDrivers, int total) {
        List<DBPDataSourceContainer> allDataSources = DataSourceRegistry.getAllDataSources();
        ArrayList<DBPDriver> recentDrivers = new ArrayList<DBPDriver>(allDrivers);
        DriverUtils.sortDriversByRating(allDataSources, recentDrivers);
        if (recentDrivers.size() > total) {
            return recentDrivers.subList(0, total);
        }
        return recentDrivers;
    }

    public static void sortDriversByRating(List<DBPDataSourceContainer> allDataSources, List<DBPDriver> drivers) {
        try {
            drivers.sort(new DriverScoreComparator(allDataSources));
        }
        catch (Throwable throwable) {}
    }

    public static List<DBPDriver> getAllDrivers() {
        List providers = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getEnabledDataSourceProviders();
        ArrayList<DBPDriver> allDrivers = new ArrayList<DBPDriver>();
        for (DBPDataSourceProviderDescriptor dpd : providers) {
            allDrivers.addAll(dpd.getEnabledDrivers());
        }
        allDrivers.sort(Comparator.comparing(DBPNamedObject::getName));
        return allDrivers;
    }

    public static class DriverNameComparator
    implements Comparator<DBPDriver> {
        @Override
        public int compare(DBPDriver o1, DBPDriver o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    public static class DriverScoreComparator
    extends DriverNameComparator {
        private final List<DBPDataSourceContainer> dataSources;

        public DriverScoreComparator(List<DBPDataSourceContainer> dataSources) {
            this.dataSources = dataSources;
        }

        @Override
        public int compare(DBPDriver o1, DBPDriver o2) {
            int ub2;
            int ub1 = DriverUtils.getUsedBy(o1, this.dataSources).size() + o1.getPromotedScore();
            if (ub1 == (ub2 = DriverUtils.getUsedBy(o2, this.dataSources).size() + o2.getPromotedScore())) {
                return super.compare(o1, o2);
            }
            return ub2 - ub1;
        }
    }
}

