/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNPath
extends DBNNode {
    private static final Log log = Log.getLog(DBNPath.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Path path;
    private DBNNode[] children;
    private DBPImage resourceImage;

    public DBNPath(DBNNode parentNode, Path path) {
        super(parentNode);
        this.path = path;
    }

    @Override
    public boolean isDisposed() {
        return this.path == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        this.path = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return "Path";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return this.path.getFileName().toString();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && Files.isDirectory(this.path, new LinkOption[0])) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBNNode> result = new ArrayList<DBNNode>();
        if (Files.exists(this.path, new LinkOption[0]) && Files.isDirectory(this.path, new LinkOption[0])) {
            try {
                Files.list(this.path).forEach(c -> {
                    DBNPath newChild = this.makeNode((Path)c);
                    if (newChild != null) {
                        result.add(newChild);
                    }
                });
            }
            catch (IOException e) {
                throw new DBException("Error reading directory members", e);
            }
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    private DBNPath getChild(Path thePath) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNPath && thePath.equals(((DBNPath)child).getPath())) {
                return (DBNPath)child;
            }
            ++n2;
        }
        return null;
    }

    private DBNPath makeNode(Path resource) {
        return null;
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.children = null;
        return this;
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + "/" + this.path.getFileName().toString();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        try {
            Files.move(this.path, this.path.getParent().resolve(newName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DBException("Can't rename resource", e);
        }
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            return false;
        }
        if (otherNode == null) {
            return true;
        }
        return otherNode instanceof DBNPath && otherNode != this && otherNode.getParentNode() != this && !this.isChildOf(otherNode);
    }

    @Override
    public void dropNodes(Collection<DBNNode> nodes) throws DBException {
        throw new DBException("Not implemented");
    }

    @Nullable
    public Path getPath() {
        return this.path;
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> {
            if (o1 instanceof DBNPath && o2 instanceof DBNPath) {
                Path res1 = ((DBNPath)o1).getPath();
                Path res2 = ((DBNPath)o2).getPath();
                if (res1 instanceof IFolder && !(res2 instanceof IFolder)) {
                    return -1;
                }
                if (res2 instanceof IFolder && !(res1 instanceof IFolder)) {
                    return 1;
                }
            }
            return o1.getNodeName().compareToIgnoreCase(o2.getNodeName());
        });
    }

    public void createNewFolder(String folderName) throws DBException {
        try {
            if (this.path instanceof IProject) {
                IFolder newFolder = ((IProject)this.path).getFolder(folderName);
                if (newFolder.exists()) {
                    throw new DBException("Folder '" + folderName + "' already exists in project '" + this.path.toString() + "'");
                }
                newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else if (this.path instanceof IFolder) {
                IFolder newFolder;
                IFolder parentFolder = (IFolder)this.path;
                if (!parentFolder.exists()) {
                    parentFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((newFolder = parentFolder.getFolder(folderName)).exists()) {
                    throw new DBException("Folder '" + folderName + "' already exists in '" + this.path.toString() + "'");
                }
                newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't create new folder", e);
        }
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.path == null ? "" : this.path.toAbsolutePath().toString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        return this.path == null ? "" : this.path.toString();
    }

    @Property(viewable=true, order=11)
    public long getResourceSize() throws IOException {
        return this.path == null ? 0L : Files.size(this.path);
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() {
        return this.path == null ? null : DATE_FORMAT.format(this.path.toFile().lastModified());
    }

    protected boolean isResourceExists() {
        return this.path != null && Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.path != null && adapter.isAssignableFrom(this.path.getClass())) {
            return adapter.cast(this.path);
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.path == null ? super.toString() : this.path.toString();
    }
}

