/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.util.ArrayList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.fs.DBFFileSystemDescriptor;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DBNFileSystemRoot
extends DBNNode {
    private static final Log log = Log.getLog(DBNFileSystemRoot.class);
    private DBNFileSystem[] children;

    public DBNFileSystemRoot(DBNNode parentNode) {
        super(parentNode);
    }

    @Override
    public String getNodeType() {
        return "FileSystemRoot";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return "File Systems";
    }

    @Override
    public String getNodeDescription() {
        return "All virtual file systems";
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public DBNFileSystem[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNFileSystem[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Read available file systems", 1);
        ArrayList<DBNFileSystem> result = new ArrayList<DBNFileSystem>();
        DBFFileSystemDescriptor[] dBFFileSystemDescriptorArray = DBWorkbench.getPlatform().getFileSystemRegistry().getFileSystemProviders();
        int n = dBFFileSystemDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBFVirtualFileSystem[] fsList;
            DBFFileSystemDescriptor fsProvider = dBFFileSystemDescriptorArray[n2];
            DBFVirtualFileSystem[] dBFVirtualFileSystemArray = fsList = fsProvider.getInstance().getAvailableFileSystems(monitor, this.getModel().getModelAuthContext());
            int n3 = fsList.length;
            int n4 = 0;
            while (n4 < n3) {
                DBFVirtualFileSystem fs = dBFVirtualFileSystemArray[n4];
                DBNFileSystem newChild = new DBNFileSystem(this, fs);
                result.add(newChild);
                ++n4;
            }
            ++n2;
        }
        result.sort(DBUtils.nameComparatorIgnoreCase());
        monitor.done();
        return result.toArray(new DBNFileSystem[0]);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) {
        this.children = null;
        return this;
    }

    @Override
    public String getNodeItemPath() {
        return DBNNode.NodePathType.path.getPrefix();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }
}

