/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.util;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.gef3.GraphicalEditPart;

public final class EditPartUtilities {
    private EditPartUtilities() {
    }

    public static LinkedHashSet getAllChildren(GraphicalEditPart parentEditPart) {
        LinkedHashSet transitiveChildren = new LinkedHashSet();
        List children = parentEditPart.getChildren();
        transitiveChildren.addAll(children);
        for (GraphicalEditPart child : children) {
            transitiveChildren.addAll(EditPartUtilities.getAllChildren(child));
        }
        return transitiveChildren;
    }

    public static HashSet getAllNestedConnectionEditParts(GraphicalEditPart graphicalEditPart) {
        HashSet transitiveConnections = new HashSet();
        LinkedHashSet transitiveChildren = EditPartUtilities.getAllChildren(graphicalEditPart);
        for (GraphicalEditPart child : transitiveChildren) {
            transitiveConnections.addAll(child.getSourceConnections());
            transitiveConnections.addAll(child.getTargetConnections());
        }
        return transitiveConnections;
    }

    public static HashSet getNestedConnectionEditParts(GraphicalEditPart graphicalEditPart) {
        HashSet edges = new HashSet();
        List children = graphicalEditPart.getChildren();
        for (Object child : children) {
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart childEditPart = (GraphicalEditPart)child;
            edges.addAll(childEditPart.getSourceConnections());
            edges.addAll(childEditPart.getTargetConnections());
        }
        return edges;
    }
}

