/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Layer;
import org.eclipse.draw2dl.LayeredPane;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.ScalableFigure;
import org.eclipse.draw2dl.ScalableLayeredPane;
import org.eclipse.draw2dl.StackLayout;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.AutoexposeHelper;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.LayerConstants;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editparts.GridLayer;
import org.eclipse.gef3.editparts.GuideLayer;
import org.eclipse.gef3.editparts.LayerManager;
import org.eclipse.gef3.editparts.SimpleRootEditPart;
import org.eclipse.gef3.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef3.editparts.ZoomManager;
import org.eclipse.gef3.tools.MarqueeDragTracker;

public class ScalableRootEditPart
extends SimpleRootEditPart
implements LayerConstants,
LayerManager {
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;
    private ScalableLayeredPane scaledLayers;
    private PropertyChangeListener gridListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("SnapToGrid.GridOrigin") || property.equals("SnapToGrid.GridSpacing") || property.equals("SnapToGrid.isVisible")) {
                ScalableRootEditPart.this.refreshGridLayer();
            }
        }
    };
    private ZoomManager zoomManager = this.createZoomManager((ScalableFigure)((ScalableLayeredPane)this.getScaledLayers()), (Viewport)this.getFigure());

    protected ZoomManager createZoomManager(ScalableFigure scalableFigure, Viewport viewport) {
        return new ZoomManager(scalableFigure, viewport);
    }

    @Override
    protected IFigure createFigure() {
        Viewport viewport = this.createViewport();
        this.innerLayers = new LayeredPane();
        this.createLayers(this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected GridLayer createGridLayer() {
        return new GridLayer();
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new Layer(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                return new Dimension();
            }
        }, (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected LayeredPane createPrintableLayers() {
        LayeredPane pane = new LayeredPane();
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new StackLayout());
        pane.add((IFigure)layer, (Object)"Primary Layer");
        layer = new ConnectionLayer();
        layer.setPreferredSize(new Dimension(5, 5));
        pane.add((IFigure)layer, (Object)"Connection Layer");
        return pane;
    }

    protected ScalableLayeredPane createScaledLayers() {
        ScalableLayeredPane layers = new ScalableLayeredPane();
        layers.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layers.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layers.add((IFigure)new FeedbackLayer(), (Object)"Scaled Feedback Layer");
        return layers;
    }

    protected Viewport createViewport() {
        return new Viewport(true);
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == AutoexposeHelper.class) {
            return new ViewportAutoexposeHelper(this);
        }
        return super.getAdapter(key);
    }

    @Override
    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    @Override
    public IFigure getLayer(Object key) {
        if (this.innerLayers == null) {
            return null;
        }
        Layer layer = this.scaledLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        layer = this.printableLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        return this.innerLayers.getLayer(key);
    }

    @Override
    public Object getModel() {
        return LayerManager.ID;
    }

    protected LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    protected LayeredPane getScaledLayers() {
        if (this.scaledLayers == null) {
            this.scaledLayers = this.createScaledLayers();
        }
        return this.scaledLayers;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    protected void refreshGridLayer() {
        boolean visible = false;
        GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
        Boolean val = (Boolean)this.getViewer().getProperty("SnapToGrid.isVisible");
        if (val != null) {
            visible = val;
        }
        grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
        grid.setSpacing((Dimension)this.getViewer().getProperty("SnapToGrid.GridSpacing"));
        grid.setVisible(visible);
    }

    @Override
    protected void register() {
        super.register();
        this.getViewer().setProperty(ZoomManager.class.toString(), this.getZoomManager());
        if (this.getLayer("Grid Layer") != null) {
            this.getViewer().addPropertyChangeListener(this.gridListener);
            this.refreshGridLayer();
        }
    }

    @Override
    protected void unregister() {
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
        this.getViewer().setProperty(ZoomManager.class.toString(), null);
    }

    class FeedbackLayer
    extends Layer {
        FeedbackLayer() {
            this.setEnabled(false);
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Rectangle rect = new Rectangle();
            int i = 0;
            while (i < this.getChildren().size()) {
                rect.union(((IFigure)this.getChildren().get(i)).getBounds());
                ++i;
            }
            return rect.getSize();
        }
    }
}

