/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.draw2dl.FreeformLayeredPane;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.SWTGraphics;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Resource;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.erd.ui.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ImageUtils;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class ERDExportRasterImage
implements ERDExportFormatHandler {
    private static final int MARGIN_X = 10;
    private static final int MARGIN_Y = 10;

    @Override
    public void exportDiagram(EntityDiagram diagram, IFigure figure, DiagramPart diagramPart, File targetFile) throws DBException {
        int imageType = 0;
        String filePath = targetFile.getName().toLowerCase();
        if (filePath.endsWith(".jpg")) {
            imageType = 4;
        } else if (filePath.endsWith(".png")) {
            imageType = 5;
        } else if (filePath.endsWith(".gif")) {
            imageType = 2;
        }
        Rectangle contentBounds = figure instanceof FreeformLayeredPane ? ((FreeformLayeredPane)figure).getFreeformExtent() : figure.getBounds();
        try {
            if (contentBounds.isEmpty()) {
                throw new DBException("Can't serializeDiagram empty diagram");
            }
            Throwable throwable = null;
            Object var8_10 = null;
            try (FileOutputStream fos = new FileOutputStream(targetFile);){
                GC gc = null;
                SWTGraphics graphics = null;
                try {
                    Image image = new Image(null, contentBounds.width + 20, contentBounds.height + 20);
                    try {
                        gc = new GC((Drawable)image);
                        gc.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
                        gc.fillRectangle(image.getBounds());
                        graphics = new SWTGraphics(gc);
                        graphics.translate(contentBounds.x * -1 + 10, contentBounds.y * -1 + 10);
                        figure.paint((Graphics)graphics);
                        ImageLoader imageLoader = new ImageLoader();
                        imageLoader.data = new ImageData[1];
                        imageLoader.data[0] = imageType == 2 ? ImageUtils.makeWebImageData((Image)image) : ImageUtils.getImageDataAtCurrentZoom((Image)image);
                        imageLoader.save((OutputStream)fos, imageType);
                    }
                    finally {
                        UIUtils.dispose((Resource)image);
                    }
                }
                catch (Throwable throwable2) {
                    if (graphics != null) {
                        graphics.dispose();
                    }
                    UIUtils.dispose(gc);
                    throw throwable2;
                }
                if (graphics != null) {
                    graphics.dispose();
                }
                UIUtils.dispose((Resource)gc);
                fos.flush();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ShellUtils.launchProgram((String)targetFile.getAbsolutePath());
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Save ERD as image", null, e);
        }
    }
}

