/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceEditable;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskObjectSelectorDialog;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizard;
import org.jkiss.dbeaver.tasks.ui.sql.internal.TasksSQLUIMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

class SQLToolTaskWizardPageSettings
extends ActiveWizardPage<SQLToolTaskWizard>
implements DBPContextProvider {
    private static final Log log = Log.getLog(SQLToolTaskWizardPageSettings.class);
    private SQLToolTaskWizard sqlWizard;
    private List<DBSObject> selectedObjects = new ArrayList<DBSObject>();
    private PropertyTreeViewer taskOptionsViewer;
    private Object sqlPreviewPanel;
    private TableViewer objectsViewer;
    private UIServiceSQL serviceSQL;

    SQLToolTaskWizardPageSettings(SQLToolTaskWizard wizard) {
        super(NLS.bind((String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_name, (Object)wizard.getTaskType().getName()));
        this.setTitle(NLS.bind((String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_title, (Object)wizard.getTaskType().getName()));
        this.setDescription(NLS.bind((String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_description, (Object)wizard.getTaskType().getName()));
        this.sqlWizard = wizard;
    }

    public void createControl(Composite parent) {
        ToolItem[] moveButtons;
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        SashForm previewSplitter = new SashForm(composite, 512);
        previewSplitter.setLayoutData((Object)new GridData(1808));
        SashForm settingsPanel = new SashForm((Composite)previewSplitter, 256);
        Group objectsPanel = UIUtils.createControlGroup((Composite)settingsPanel, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_group_label_objects, (int)2, (int)1808, (int)0);
        this.objectsViewer = new TableViewer((Composite)objectsPanel, 67586);
        this.objectsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.objectsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)element), (DBPEvaluationContext)DBPEvaluationContext.UI);
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)((DBPObject)element)));
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 200;
        final Table objectTable = this.objectsViewer.getTable();
        objectTable.setLayoutData((Object)gd);
        ToolBar buttonsToolbar = new ToolBar((Composite)objectsPanel, 512);
        buttonsToolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_tool_item_text_add_string, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(SQLToolTaskWizardPageSettings.this.sqlWizard.getProject());
                SQLToolTaskObjectSelectorDialog objectListDialog = new SQLToolTaskObjectSelectorDialog(SQLToolTaskWizardPageSettings.this.getShell(), projectNode, (TaskTypeDescriptor)SQLToolTaskWizardPageSettings.this.sqlWizard.getTaskType());
                if (objectListDialog.open() == 0) {
                    for (DBSObject object : objectListDialog.getSelectedObjects()) {
                        if (SQLToolTaskWizardPageSettings.this.selectedObjects.contains(object)) continue;
                        SQLToolTaskWizardPageSettings.this.selectedObjects.add(object);
                    }
                    SQLToolTaskWizardPageSettings.this.refreshObjects();
                    SQLToolTaskWizardPageSettings.this.updatePageCompletion();
                }
            }
        });
        ToolItem deleteItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_tool_item_text_remove_string, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SQLToolTaskWizardPageSettings.this.objectsViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof DBSObject) {
                            SQLToolTaskWizardPageSettings.this.selectedObjects.remove(element);
                        }
                        ++n2;
                    }
                    SQLToolTaskWizardPageSettings.this.refreshObjects();
                    SQLToolTaskWizardPageSettings.this.updatePageCompletion();
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        moveButtons = new ToolItem[]{UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_tool_item_text_move_script_up, (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = objectTable.getSelectionIndex();
                if (selectionIndex > 0) {
                    DBSObject prevScript = SQLToolTaskWizardPageSettings.this.selectedObjects.get(selectionIndex - 1);
                    SQLToolTaskWizardPageSettings.this.selectedObjects.set(selectionIndex - 1, SQLToolTaskWizardPageSettings.this.selectedObjects.get(selectionIndex));
                    SQLToolTaskWizardPageSettings.this.selectedObjects.set(selectionIndex, prevScript);
                    SQLToolTaskWizardPageSettings.this.refreshObjects();
                }
                moveButtons[0].setEnabled(selectionIndex > 1);
                moveButtons[1].setEnabled(selectionIndex < objectTable.getItemCount() - 1);
            }
        }), UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_tool_item_text_move_script_down, (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = objectTable.getSelectionIndex();
                if (selectionIndex < objectTable.getItemCount() - 1) {
                    DBSObject nextScript = SQLToolTaskWizardPageSettings.this.selectedObjects.get(selectionIndex + 1);
                    SQLToolTaskWizardPageSettings.this.selectedObjects.set(selectionIndex + 1, SQLToolTaskWizardPageSettings.this.selectedObjects.get(selectionIndex));
                    SQLToolTaskWizardPageSettings.this.selectedObjects.set(selectionIndex, nextScript);
                    SQLToolTaskWizardPageSettings.this.refreshObjects();
                }
                moveButtons[0].setEnabled(selectionIndex > 0);
                moveButtons[1].setEnabled(selectionIndex < objectTable.getItemCount() - 2);
            }
        })};
        this.objectsViewer.addSelectionChangedListener(event -> {
            int selectionIndex = objectTable.getSelectionIndex();
            deleteItem.setEnabled(selectionIndex >= 0);
            moveButtons[0].setEnabled(selectionIndex > 0);
            moveButtons[1].setEnabled(selectionIndex < objectTable.getItemCount() - 1);
        });
        deleteItem.setEnabled(false);
        moveButtons[0].setEnabled(false);
        moveButtons[1].setEnabled(false);
        Group optionsPanel = UIUtils.createControlGroup((Composite)settingsPanel, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_group_label_settings, (int)1, (int)1808, (int)0);
        this.taskOptionsViewer = new PropertyTreeViewer((Composite)optionsPanel, 2048);
        this.taskOptionsViewer.addPropertyChangeListener(event -> this.updateScriptPreview());
        Composite previewPanel = UIUtils.createComposite((Composite)previewSplitter, (int)1);
        previewPanel.setLayout((Layout)new FillLayout());
        this.serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (this.serviceSQL != null) {
            try {
                this.sqlPreviewPanel = this.serviceSQL.createSQLPanel((Object)UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite(), (Object)previewPanel, (DBPContextProvider)this, TasksSQLUIMessages.sql_tool_task_wizard_page_settings_sql_panel_name, true, "");
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(TasksSQLUIMessages.sql_tool_task_wizard_page_settings_title_sql_preview_error, TasksSQLUIMessages.sql_tool_task_wizard_page_settings_message_sql_preview_panel, (Throwable)e);
            }
        }
        Composite controlsPanel = UIUtils.createComposite((Composite)composite, (int)2);
        UIUtils.createDialogButton((Composite)controlsPanel, (String)TasksSQLUIMessages.sql_tool_task_wizard_page_settings_dialog_button_label_copy, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = SQLToolTaskWizardPageSettings.this.serviceSQL.getSQLPanelText(SQLToolTaskWizardPageSettings.this.sqlPreviewPanel);
                if (!CommonUtils.isEmpty((String)text)) {
                    UIUtils.setClipboardContents((Display)SQLToolTaskWizardPageSettings.this.getShell().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
                }
            }
        });
        this.loadSettings();
        if (this.taskOptionsViewer.getTree().getItemCount() == 0) {
            settingsPanel.setMaximizedControl((Control)objectsPanel);
        }
        this.setControl((Control)composite);
    }

    private void refreshObjects() {
        this.objectsViewer.refresh(true, true);
        this.saveSettings();
        this.updateScriptPreview();
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        if (this.selectedObjects.isEmpty()) {
            this.setErrorMessage("You must select object(s)");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void updateScriptPreview() {
        String sqlText = this.generateScriptText();
        if (this.serviceSQL != null) {
            this.serviceSQL.setSQLPanelText(this.sqlPreviewPanel, sqlText);
        }
    }

    private String generateScriptText() {
        SQLToolExecuteHandler taskHandler = this.sqlWizard.getTaskHandler();
        try {
            return taskHandler.generateScript((DBRProgressMonitor)new VoidProgressMonitor(), this.sqlWizard.getSettings());
        }
        catch (DBCException e) {
            log.error((Object)e);
            return "-- Error: " + e.getMessage();
        }
    }

    private void loadSettings() {
        this.selectedObjects.clear();
        SQLToolExecuteSettings settings = this.sqlWizard.getSettings();
        this.selectedObjects.addAll(settings.getObjectList());
        this.objectsViewer.setInput(this.selectedObjects);
        PropertySourceEditable propertyCollector = new PropertySourceEditable((Object)this.sqlWizard.getSettings(), (Object)this.sqlWizard.getSettings());
        propertyCollector.collectProperties();
        this.taskOptionsViewer.loadProperties((DBPPropertySource)propertyCollector);
        this.taskOptionsViewer.repackColumns();
        this.updateScriptPreview();
    }

    void saveSettings() {
        if (this.sqlWizard == null) {
            return;
        }
        SQLToolExecuteSettings settings = this.sqlWizard.getSettings();
        settings.setObjectList(this.selectedObjects);
        this.taskOptionsViewer.saveEditorValues();
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        SQLToolExecuteSettings settings = this.sqlWizard.getSettings();
        if (settings != null && !settings.getObjectList().isEmpty()) {
            return DBUtils.getDefaultContext((DBSObject)((DBSObject)settings.getObjectList().get(0)), (boolean)false);
        }
        return null;
    }
}

