/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class PasswordChangeDialog
extends BaseDialog {
    private DBAPasswordChangeInfo passwordInfo;
    private String verifyText;
    private boolean userEditable;
    private boolean oldPasswordVisible;

    public PasswordChangeDialog(Shell parentShell, String title, String userName, String oldPassword, boolean userEditable, boolean oldPasswordVisible) {
        super(parentShell, title, (DBPImage)DBIcon.TREE_USER);
        this.passwordInfo = new DBAPasswordChangeInfo(userName, oldPassword);
        this.userEditable = userEditable;
        this.oldPasswordVisible = oldPasswordVisible;
    }

    public DBAPasswordChangeInfo getPasswordInfo() {
        return this.passwordInfo;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite credGroup = super.createDialogArea(parent);
        ((GridLayout)credGroup.getLayout()).numColumns = 2;
        CLabel infoLabel = UIUtils.createInfoLabel((Composite)credGroup, (String)this.getTitle());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        infoLabel.setLayoutData((Object)gd);
        Text userNameText = UIUtils.createLabelText((Composite)credGroup, (String)CoreMessages.dialog_password_change_username, (String)this.passwordInfo.getUserName(), (int)2048);
        userNameText.addModifyListener(e -> this.passwordInfo.setUserName(userNameText.getText()));
        userNameText.setEditable(this.userEditable);
        if (this.oldPasswordVisible) {
            Text oldPasswordText = UIUtils.createLabelText((Composite)credGroup, (String)CoreMessages.dialog_password_change_old_password, (String)this.passwordInfo.getOldPassword(), (int)0x400800);
            oldPasswordText.addModifyListener(e -> this.passwordInfo.setOldPassword(oldPasswordText.getText()));
        }
        Text newPasswordText = UIUtils.createLabelText((Composite)credGroup, (String)CoreMessages.dialog_password_change_new_password, (String)"", (int)0x400800);
        newPasswordText.addModifyListener(e -> {
            this.passwordInfo.setNewPassword(newPasswordText.getText());
            this.updateButtons();
        });
        if (!this.userEditable) {
            newPasswordText.setFocus();
        }
        Text verifyPasswordText = UIUtils.createLabelText((Composite)credGroup, (String)CoreMessages.dialog_password_change_verify_password, (String)"", (int)0x400800);
        verifyPasswordText.addModifyListener(e -> {
            this.verifyText = verifyPasswordText.getText();
            this.updateButtons();
        });
        return credGroup;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(!CommonUtils.isEmpty((String)this.passwordInfo.getUserName()) && CommonUtils.equalObjects((Object)this.passwordInfo.getNewPassword(), (Object)this.verifyText));
    }
}

